package com.ptteng.wealth.interceptor;

import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Map;

public class UserInterceptor extends HandlerInterceptorAdapter {

    private static final Log log = LogFactory.getLog(UserInterceptor.class);

    @Autowired
    private UserService userService;

    @Autowired
    private CookieUtil cookieUtil;

    public static void main(String[] args) throws UnsupportedEncodingException {
        String x = URLEncoder.encode("p/hello", "utf-8");
        log.info(x);

    }

    /**
     * In this case intercept the request BEFORE it reaches the controller
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    	log.info("request uri: "+request.getRequestURI());

        Cookie[] cookies = request.getCookies();
        log.info("get cookies  " + Arrays.asList(cookies));
        Map<String, String> maps = cookieUtil.getIdentity(request);
        log.info("get maps  from cookie is " + maps);
        Long uid = cookieUtil.getID(request);
        if (uid == null) {
            log.error("not legal user request");
            return noLogin(response,request);

        }
        log.info("get uid  from cookie is " + uid);
        User user = this.userService.getObjectById(uid);
        if (user == null) {
            log.error(uid + " not get any data ");
            return noLogin(response,request);
        } else {
            log.info("get usr " + user);
            request.setAttribute("user", user);
        }
        log.info("get uid is " + uid);

        return true;
    }

    private boolean wrongUser(HttpServletResponse response) throws IOException {
        response.sendRedirect("/a/wrong");
        return false;

    }

    //用户未登录
    private boolean noLogin(HttpServletResponse response,HttpServletRequest request) throws IOException {

        log.info(" user don't login");

        RequestDispatcher rd =  request.getRequestDispatcher("/r/json/noLogin.json");
        try {

            rd.forward(request,response);
        } catch (ServletException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        return false;

    }

    @Override
    public void postHandle(HttpServletRequest request,
                           HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
        log.info("p =========================================== ");
    }

    /**
     * 获取跳转链接的地址
     *
     * @param request
     * @return
     */
    public String getInterceptorUrl(HttpServletRequest request) {

        String interceptorUrl = request.getRequestURI() + (null == request.getQueryString() ? "" : "?" + request.getQueryString()).toString();
        interceptorUrl = interceptorUrl.replace("/app/", "/");
        log.info("get getInterceptorUrl is " + interceptorUrl);
        return interceptorUrl;
    }
}
