package com.ptteng.wealth.finance.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.DESUtil;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.admin.util.ConstantParams;
import com.ptteng.wealth.finance.model.*;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.*;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.finance.util.FinanceConstant;
import com.ptteng.wealth.finance.util.PayAccountUtil;
import com.ptteng.wealth.model.Info;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.util.JinShenUtil;
import com.ptteng.wealth.util.OrderPayLineUtil;
import com.ptteng.wealth.util.SmallLoanService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

import static com.gemantic.common.util.json.GsonUtil.fromJson;

/**
 * Created by arthur on 16/6/24.
 */
@Controller
public class OmsController extends BaseController {

    @Autowired
    public SmallLoanService smallLoanService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private FundService fundService;
    @Autowired
    private RefundsService refundsService;
    @Autowired
    private UserAccountRelationService userAccountRelationService;
    @Autowired
    private FundHistoryService fundHistoryService;

    private Log log = LogFactory.getLog(OmsController.class);

    private Log omsPayLog = LogFactory.getLog("oms_pay");

    private Integer checkParams(String orderNo, Integer paymentType, String notifyUrl, String token, Double totalFee,
                                String info,Integer type, String company, Integer orderType, String additional) throws Exception {

        //传入参数检查
        if (null == orderNo || null == paymentType || null == totalFee || null == info  || null == notifyUrl  || null == type || null == token || null == company || null == orderType || null == additional) {
            omsPayLog.info("params is null");
            return  -1000;
        }
        omsPayLog.info("params not null");

        String userKailinCode = DESUtil.decrypt(token.getBytes());
        omsPayLog.info("kailin code : " + userKailinCode);
        Long uid = userService.getUserIdByKailinCode(userKailinCode);
        if (null == uid) {
            omsPayLog.info("PARAMFAIL: user not exist");
            return  -2000;
        }
        //冻结用户不能支付订单
        User user = userService.getObjectById(uid);
        omsPayLog.info("user : " + user);
        if (User.FREEZE_YES.equals(user.getFreezeStatus())) {
            omsPayLog.info("paymentType illegal");
            return  -3021;
        }
        //支付类型检查
        if (FinanceConstant.PAYMENT_TYPE_1 != paymentType && FinanceConstant.PAYMENT_TYPE_6 != paymentType && FinanceConstant.PAYMENT_TYPE_3 != paymentType && FinanceConstant.PAYMENT_TYPE_4 != paymentType) {
            omsPayLog.info("paymentType illegal");
            return -3010;
        }

        Fund fund = fundService.getObjectById(uid);
        if (null == fund) {
            omsPayLog.info("user have no fund");
            return -2010;
        }
        omsPayLog.info("user fund id : " + fund.getId());

        if (orderType == FinanceConstant.PAYMENT_TYPE_5) {
            Boolean checkResult = smallLoanService.check(totalFee);
            if (!checkResult) {
                omsPayLog.info("order Fee not in smallLoan range");
                return -3025;
            }
            //第一次小额订单自动授信
            Boolean updateLineResult = smallLoanService.smallLoanLineApply(uid);
        }
        omsPayLog.info("not smallLoan or smallLoanCheck ok");

        //补款订单先检查支付订单是否支付完成
        if(!orderNo.equals(additional)){
            omsPayLog.info("additional order");
            Long oldOrderId = orderService.getOrderIdByOrderNo(orderNo);

            if (null == oldOrderId) {//支付订单不存在
                omsPayLog.info("original order not exist");
                return -3036;
            }else {
                omsPayLog.info("original order : " + oldOrderId + " exist");
                Order order = orderService.getObjectById(oldOrderId);

                if (!Order.STATUS_COMPLETE.equals(order.getStatus())) {//支付订单未完成
                    omsPayLog.info("original order : " + oldOrderId + " not complete");
                    return -3037;
                }else {
                    omsPayLog.info("original order : " + oldOrderId + " complete");
                }
            }
        }else {
            omsPayLog.info("original order");
        }

        //重复订单检查
        Long oldOrderId = orderService.getOrderIdByOrderNoAndAdditional(orderNo, additional);
        log.info("old order id : " + oldOrderId);
        if (null != oldOrderId) {
            Order order = orderService.getObjectById(oldOrderId);
            if (Order.STATUS_COMPLETE.equals(order.getStatus())) {
                omsPayLog.info(" old order Id : " + oldOrderId + " has complete ");
                return -3009;
            }
            if (!uid.equals(order.getUid())) {
                omsPayLog.info("proccessOrder uid not match");
                return -3018;
            }
            order.setNotifyUrl(notifyUrl);
            orderService.update(order);
        }
        else if (orderType == FinanceConstant.PAYMENT_TYPE_5) {
            Integer ifLineEnough = 0;
            if(FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                ifLineEnough = smallLoanService.smallLoanLineCheck(totalFee, uid);
            }else {
                ifLineEnough = smallLoanService.onlyDailySmallLoanLineCheck(totalFee, uid);
            }
            if(ifLineEnough == 1){
                omsPayLog.info("user small loan line not enough");
                return -3026;
            }else if(ifLineEnough == 2){
                omsPayLog.info("user small loan line not enough");
                return -3027;
            }

            omsPayLog.info("small loan line check ok");
        }

        return 0;
    }

    //支付
    @RequestMapping(value = "/orderpay/order/{orderNo}", method = RequestMethod.POST)
    public String pay(ModelMap model, String notifyUrl, @PathVariable String orderNo, Integer paymentType, String token,
                      Double totalFee, String info, Integer type, String company,Integer orderType,String additional) throws Exception {
        Integer result = 0;
        omsPayLog.info("==============================================================");
        omsPayLog.info("oms pay order : orderNo = " + orderNo + " token " + token+ " paymentType = " + paymentType + " type "
                + type  + " totalFee = " + totalFee + " info " + info + " notifyUrl " + notifyUrl + " company " + company
                + " orderType " + orderType + " additional " + additional);
        if(StringUtil.isEmpty(additional)){
            additional = orderNo;
        }
        try {
            result = checkParams(orderNo, paymentType, notifyUrl, token, totalFee, info, type, company, orderType, additional);

            omsPayLog.info(" Step 1 : Check Paramter Result  : "+result);
            if(result.intValue() < 0){
                model.addAttribute("code", result);
                omsPayLog.info("======= PARAMETER CHECK FAIL   ");
                return "/common/success";
            }
            else {
                //第一步： 获取用户ID
                String userKailinCode = DESUtil.decrypt(token.getBytes());
                Long uid = userService.getUserIdByKailinCode(userKailinCode);
                omsPayLog.info(" Step 2 : USER ID : "+uid);

                User user = userService.getObjectById(uid);
                if(null == user){
                    log.info("user not exist");
                    model.addAttribute("code", -2000);
                    return "/common/success";
                }

                //第二步: 获取后者更新订单
                Long orderId = orderService.getOrderIdByOrderNoAndAdditional(orderNo, additional);
                Order order = null;
                if(null == orderId){
                    if(orderType == 1 && FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                        order = createSmallOrder(orderNo, paymentType, notifyUrl, totalFee, info, type, uid, company, additional);
                        result = 200;
                        omsPayLog.info(" create small order success ");
                        model.addAttribute("code",result);
                        return "/common/success";
                    }else {
                        order = new Order();
                        order.setOrderNo(orderNo);
                        order.setDepartment(type);
                        order.setResource(Order.Pay_Resource_oms);
                        order.setUid(uid);
                        order.setInfo(info);
                            order.setStatus(Order.STATUS_PROCCESS);
                        order.setOrderAt(System.currentTimeMillis());
                        order.setPriceTot(new BigDecimal(totalFee.toString()));
                        order.setNotifyUrl(notifyUrl);
                        order.setPayLine(OrderPayLineUtil.getPayLine(paymentType));
                        order.setAdditional(additional);
                        if(Order.Pay_Type_fund == paymentType){
                            order.setPayType(Order.Pay_Type_klfund);
                        }else {
                            order.setPayType(paymentType);
                        }
                        if(orderType.equals(FinanceConstant.PAYMENT_TYPE_5)){
                            order.setOrderType(Order.Type_small);
                        }else {
                            order.setOrderType(Order.Type_normal);
                        }
                        omsPayLog.info("insert order " + order);
                        orderId = orderService.insert(order);
                        order.setId(orderId);
                        omsPayLog.info("insert order success" + order.getId());
                    }
                }else if(orderType == 1 && FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                    result = 200;
                    model.addAttribute("code",result);
                    return "/common/success";
                }

                order = orderService.getObjectById(orderId);

                //第三步: 实际进行支付
                //信用支付
                if(FinanceConstant.PAYMENT_TYPE_6.equals(paymentType)){
                    List<LoanProduct> loanProducts = loanProductService.getLoanProductByManner(LoanProduct.SALE_ON_CREDIT);
                    if(CollectionUtils.isNotEmpty(loanProducts)){
                        //赊销的处理流程

                        loanApplyService.addLoanApply(order, loanProducts.get(0).getId(),user);
                        order.setPayType(Order.Pay_Type_Loan);
                        orderService.update(order);
                        result = 200;
                    }
                    else{
                        result = -3024;
                    }
                }
                //使用开磷余额支付
                else {
                    omsPayLog.info(" Step 3 : Order ID : "+orderId);
                    String accountCode = PayAccountUtil.getRightPayAccount(type);
                    //非常关键，获取要支付的开磷账号
                    Long userAccountId  = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
                    omsPayLog.info("Step 4 : account code:  "+accountCode+"  user account id: "+userAccountId);
                    if(null != userAccountId){
                        //进行实际订单支付及记录流水操作
                        UserAccountRelation userAccountRelationBefore = userAccountRelationService.getObjectById(userAccountId);
                        BigDecimal before = userAccountRelationBefore.getMoney();
                        log.info("account amount before : " + before);

                        result = userAccountRelationService.payOrder(orderId,userAccountId,order.getPayType());
                        //因为返回给OMS，是以200 作为成功的，所以此处做个转化

                        if(result == 0){
                            UserAccountRelation userAccountRelationAfter = userAccountRelationService.getObjectById(userAccountId);
                            BigDecimal after = userAccountRelationAfter.getMoney();
                            log.info("account amount after : " + after);
                            Long id = fundHistoryService.insertTransaction(order, user, FundHistory.TYPE_Pay, FundHistory.DETAIL_Pay, userAccountId,
                                    order.getPriceTot() , null, FundHistory.FLAG_Out, FundHistory.STATUS_Pass, null, before, after);
                            log.info("insert transaction success : id " + id);
                        }

                        if(0 == result.intValue()){
                            result = 200;
                            if(Order.Type_small.equals(order.getOrderType())){
                                smallLoanOver(uid , order.getPriceTot());
                            }
                        }
                    }

                    else{
                        result = -3022;
                    }
                }
                omsPayLog.info("Step 5 : pay  db result: "+result);
                model.addAttribute("code",result);
                omsPayLog.info("Step 6 : SUCCESS END ========== ");
            }
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            omsPayLog.error(t.getMessage());
            log.error("oms pay error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //新建退款
    @RequestMapping(value = "/orderpay/refund/{orderNo}", method = RequestMethod.POST)
    public String pay(ModelMap model, @PathVariable String orderNo, Double totalFee, String additional, String notifyUrl, String token) throws Exception {
        omsPayLog.info("===========================================================");
        omsPayLog.info("insert refunds data : orderNo : " + orderNo + " totalFee : " + totalFee + " additional : " + additional
                + " token : " + token + " notifyUrl : " + notifyUrl);

        if(null == totalFee){
            model.addAttribute("code", -5005);
            return "/common/success";
        }
        if(null == token){
            model.addAttribute("code", -5010);
            return "/common/success";
        }
        if(null == additional){
            model.addAttribute("code", -5011);
            return "/common/success";
        }
        if(null == notifyUrl){
            model.addAttribute("code", -5012);
            return "/common/success";
        }

        try {
            String userKailinCode = DESUtil.decrypt(token.getBytes());
            omsPayLog.info("kailin code : " + userKailinCode);
            Long uid = userService.getUserIdByKailinCode(userKailinCode);

            if (null == uid) {
                omsPayLog.info("PARAMFAIL: user not exist");
                model.addAttribute("code", -5003);
                return "/common/success";
            }else {
                omsPayLog.info("uid : " + uid);
            }

            Refunds refunds = new Refunds();

            Long oid = orderService.getOrderIdByOrderNo(orderNo);
            if(null == oid){
                model.addAttribute("code", -5006);
                return "/common/success";
            }else {
                omsPayLog.info("oid : " + oid);
            }

            Order order = orderService.getObjectById(oid);

            if(null == order){
                model.addAttribute("code", -5006);
                return "/common/success";
            }else {
                omsPayLog.info("order : " + order);
            }

            if(!uid.equals(order.getUid())){
                model.addAttribute("code", -5004);
                return "/common/success";
            }

            if(!Order.STATUS_COMPLETE.equals(order.getStatus())){
                model.addAttribute("code", -5007);
                return "/common/success";
            }

            BigDecimal refundTot = new BigDecimal(totalFee.toString());
            Integer result = refundTot.compareTo(order.getPriceTot());

            //退款金额大于订单金额报错
            if(1 == result){
                model.addAttribute("code", -5008);
                return "/common/success";
            }else {
                omsPayLog.info("result : " + result);
            }

            //信用订单退款金额不能大于借款金额
            if(Order.Pay_Type_Loan.equals(order.getPayType()) || Order.Pay_Type_Small.equals(order.getPayType())){
                Long loanApplyId = loanApplyService.getLoanApplyIdByOrderNoAndAdditional(orderNo, orderNo);
                LoanApply loanApply = loanApplyService.getObjectById(loanApplyId);
                Integer loanResult = refundTot.compareTo(loanApply.getDebtCount());

                //退款金额大于赊销金额报错
                if(1 == loanResult){
                    model.addAttribute("code", -5009);
                    return "/common/success";
                }
            }else if (Order.Pay_Type_Debt.equals(order.getPayType())){
                Long debtApplyId = debtApplyService.getDebtApplyIdByOrderNoAndAdditional(orderNo, orderNo);
                DebtApply debtApply = debtApplyService.getObjectById(debtApplyId);
                Integer debtResult = refundTot.compareTo(debtApply.getDebtCount());

                //退款金额大于借贷金额报错
                if(1 == debtResult){
                    model.addAttribute("code", -5009);
                    return "/common/success";
                }
            }

            //是否已存在该退款单
            Long refundId = refundsService.getRefundsIdByRefundNo(additional);
            omsPayLog.info("refundId : " + refundId);
            if(null != refundId){
                model.addAttribute("code", -3038);
                return "/common/success";
            }else {
                omsPayLog.info("refundId is null , so can insert");
            }

            User user = userService.getObjectById(uid);

            //根据订单支付方式判断将钱退到哪个账户
            Integer payType = order.getPayType();
            omsPayLog.info("order payType : " + payType);

            Long accountId = 0L;
            String accountName;
            if (Order.Pay_Type_fund.equals(payType)) {
                omsPayLog.info("refund to daixiao");
                accountId = 0L;
                accountName = Refunds.Account_name_zhenglian;
            } else {
                omsPayLog.info("refund to kailin");

                //第四步： 获取开磷账户信息
                String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
                Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
                UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
                Account account = accountService.getObjectById(userAccountRelation.getAccountId());

                accountId = userAccountId;
                accountName = account.getName();
            }

            refunds.setUid(uid);
            refunds.setAccountId(accountId);
            refunds.setAccountName(accountName);
            refunds.setMobile(user.getMobile());
            refunds.setName(user.getName());
            refunds.setOrderNo(orderNo);
            refunds.setRefundTot(new BigDecimal(totalFee.toString()));
            refunds.setStatus(Refunds.Status_Verifying);
            refunds.setRefundNo(additional);
            refunds.setNotifyUrl(notifyUrl);

            omsPayLog.info("insert refunds : " + refunds);
            refundsService.insert(refunds);

            model.addAttribute("code", 200);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            t.printStackTrace(System.err);
            omsPayLog.error(t.getMessage());
            omsPayLog.error("insert refunds error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    /**
     * @param
     * @return
     * @throws Exception
     */
    //支付查询
    @RequestMapping(value = "/orderpay/ordercheck/{orderNo}", method = RequestMethod.GET)
    public String checkPay(ModelMap model, @PathVariable String orderNo) throws Exception {
        log.info("check pay : " + orderNo);
        try {
            Long orderId = orderService.getOrderIdByOrderNo(orderNo);
            Order order = orderService.getObjectById(orderId);
            model.addAttribute("code", 200);
            model.addAttribute("order", order);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("check pay : " + orderNo + " error ");
            // for test
            model.addAttribute("code", -1);
        }
        return "/wealth-finance-service/pay/json/checkPay";
    }

    private Order createSmallOrder(@PathVariable String orderNo, Integer paymentType, String notifyUrl, Double totalFee,
                                   String info, Integer type, Long uid, String company, String additional) throws ServiceException, ServiceDaoException {
        String verifyLine = constantService.getValue("verifyLine", "smallLoan");
        User user = userService.getObjectById(uid);
        Boolean verifyResult = smallLoanService.ifVerify(totalFee);
        Order order = new Order();

        //判断是否可以自动审核
        if (verifyResult) {
            order.setStatus(Order.STATUS_COMPLETE);
        } else {
            order.setStatus(Order.STATUS_PROCCESS);
        }
        order.setOrderNo(orderNo);
        order.setDepartment(type);
        order.setResource(Order.Pay_Resource_oms);
        order.setUid(uid);
        order.setInfo(info);
        order.setPayType(Order.Pay_Type_Small);
        order.setOrderAt(System.currentTimeMillis());
        order.setPriceTot(new BigDecimal(totalFee.toString()));
        order.setNotifyUrl(notifyUrl);
        order.setPayLine(OrderPayLineUtil.getPayLine(paymentType));
        order.setCompany(company);
        order.setProductStatus(Order.product_status_choice);
        order.setOrderType(Order.Type_small);
        order.setAdditional(additional);
        order.setPayAt(System.currentTimeMillis());
        omsPayLog.info("insert order " + order);
        Long id = orderService.insert(order);
        order.setId(id);
        omsPayLog.info("insert order success");

        //插入小额借款申请
        Boolean result = loanApplyService.addSmallLoanApply(order, user, verifyResult);
        omsPayLog.info("insert SmallLoanApply result : " + result);

        Fund fund = fundService.getObjectById(uid);

        //更新最后小额申请时间
        Long lastSmallLoan = fund.getLastSmallLoan();
        fund.setLastSmallLoan(System.currentTimeMillis());
        omsPayLog.info("update lastSmallLoan success : " + lastSmallLoan + " >>>>>>>>>> " + fund.getLastSmallLoan());
        //更新今日小额订单数额，在拒绝时会还原
        BigDecimal todaySmallLoan = fund.getTodaySmallLoan();
        fund.setTodaySmallLoan(todaySmallLoan.add(new BigDecimal(totalFee.toString())));
        omsPayLog.info("update todaySmallLoan success : " + todaySmallLoan + " >>>>>>>>>> " + fund.getTodaySmallLoan());
        fundService.update(fund);
        omsPayLog.info("update fund success : " + fund);

        if(result && verifyResult){
            fund = fundService.getObjectById(uid);
            BigDecimal smallLoanTot = fund.getSmallLoanTot();
            fund.setSmallLoanTot(smallLoanTot.add(new BigDecimal(totalFee.toString())));
            omsPayLog.info("update smallLoanTot success : " + smallLoanTot + " >>>>>>>>>> " + fund.getSmallLoanTot());
            fundService.update(fund);
            omsPayLog.info("update fund success : " + fund);
        }

        return order;
    }


    private void smallLoanOver(Long uid, BigDecimal totalFee) throws Exception {

        Fund fund = fundService.getObjectById(uid);

        //更新最后小额申请时间
        Long lastSmallLoan = fund.getLastSmallLoan();
        fund.setLastSmallLoan(System.currentTimeMillis());
        omsPayLog.info("update lastSmallLoan success : " + lastSmallLoan + " >>>>>>>>>> " + fund.getLastSmallLoan());
        //更新今日小额订单数额
        BigDecimal todaySmallLoan = fund.getTodaySmallLoan();
        fund.setTodaySmallLoan(todaySmallLoan.add(totalFee));
        omsPayLog.info("update todaySmallLoan success : " + todaySmallLoan + " >>>>>>>>>> " + fund.getTodaySmallLoan());
        fundService.update(fund);
        omsPayLog.info("update fund success : " + fund);

    }
}
