package com.ptteng.wealth.finance.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Invoice;
import com.ptteng.wealth.finance.service.InvoiceService;

import static com.ptteng.wealth.finance.model.Invoice.TYPE_DEFAULT;
import static com.ptteng.wealth.finance.model.Invoice.TYPE_NORMAL;

/**
 * Invoice  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class InvoiceController {
    private static final Log log = LogFactory.getLog("invoice");

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private UserService userService;

    @Autowired
    private InvoiceService invoiceService;


    /**
     * @param
     * @return
     * @throws Exception
     */
    //增加发票记录
    @RequestMapping(value = "/a/u/invoice", method = RequestMethod.POST)
    public String addInvoice(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             @RequestBody Invoice invoice) throws Exception {

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        log.info("add invoice ");

        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }

        try {
            if(DataUtils.isNullOrEmpty(invoice.getProvice()) ||  DataUtils.isNullOrEmpty(invoice.getType()) || DataUtils.isNullOrEmpty(invoice.getAccount())
                    || DataUtils.isNullOrEmpty(invoice.getAddress()) || DataUtils.isNullOrEmpty(invoice.getBank()) || DataUtils.isNullOrEmpty(invoice.getBranchBank())
                    || DataUtils.isNullOrEmpty(invoice.getCity()) || DataUtils.isNullOrEmpty(invoice.getName()) || DataUtils.isNullOrEmpty(invoice.getPhone())
                    || DataUtils.isNullOrEmpty(invoice.getReciver()) || DataUtils.isNullOrEmpty(invoice.getTaxNo())){
                model.addAttribute("code", -1000);
                log.info("params is null");
                return "/common/success";
            }

            List<Long> invoiceListIds = invoiceService.getInvoiceIdsByUid(uid, 0, Integer.MAX_VALUE);
            invoice.setId(null);
            invoice.setUid(uid);

            if (CollectionUtils.isEmpty(invoiceListIds)) {
                invoice.setType(TYPE_DEFAULT);
            } else {
                if (1 == invoice.getType()) {
                    List<Long> ids = invoiceService.getInvoiceIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
                    if (CollectionUtils.isEmpty(ids)) {
                        invoice.setType(TYPE_DEFAULT);
                        invoiceService.update(invoice);
                    } else {
                        Invoice defaultInvoice = invoiceService.getObjectById(ids.get(0));
                        defaultInvoice.setType(0);
                        invoiceService.update(defaultInvoice);
                        invoice.setType(Invoice.TYPE_DEFAULT);
                        invoiceService.update(invoice);
                    }
                }
            }

            invoiceService.insert(invoice);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add invoice error");
            // for test
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @return
     * @throws Exception
     */
    //设置默认发票
    @RequestMapping(value = "/a/u/default/invoice/{id}", method = RequestMethod.PUT)
    public String defaultInvoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id,
                                 Integer status) throws Exception {

        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        log.info("set default invoice id : " + id + " status " + status);

        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }

        try {
            Invoice invoice = invoiceService.getObjectById(id);

            if(!(uid.equals(invoice.getUid()))){
                model.addAttribute("code", -3000);
                log.info("is not your invoice");
                return "/common/success";
            }

            List<Long> invoiceListIds = invoiceService.getInvoiceIdsByUid(uid, 0, Integer.MAX_VALUE);
            if (TYPE_DEFAULT == invoice.getType()) {
                if (TYPE_DEFAULT == status) {
                    model.addAttribute("code", 0);
                    log.info("invoice is already default");
                    return "/common/success";
                } else {
                    invoice.setType(TYPE_NORMAL);
                    invoiceService.update(invoice);
                    model.addAttribute("code, 0");
                    return "/common/success";
                }
            } else {
                if (TYPE_DEFAULT == status) {
                    List<Long> ids = invoiceService.getInvoiceIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
                    log.info("user old default invoice is : " + ids.size());
                    if (CollectionUtils.isEmpty(ids)) {
                        log.info("no old default address");
                        invoice.setType(TYPE_DEFAULT);
                        invoiceService.update(invoice);
                    } else {
                        log.info("change default address");
                        Invoice defaultInvoice = invoiceService.getObjectById(ids.get(0));
                        defaultInvoice.setType(0);
                        invoiceService.update(defaultInvoice);
                        invoice.setType(TYPE_DEFAULT);
                        invoiceService.update(invoice);
                    }
                } else {
                    model.addAttribute("code", 0);
                    log.info("invoice is already normal");
                    return "/common/success";
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add invoice error");
            // for test
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * @param
     * @return
     * @throws Exception
     */
    //删除发票记录
    @RequestMapping(value = "/a/u/invoice/{id}", method = RequestMethod.DELETE)
    public String deleteInvoice(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("delete invoice : " + id);
        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);

        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }

        try {
            Invoice invoice = invoiceService.getObjectById(id);
            Long invoiceUid = invoice.getUid();
            if(!(uid.equals(invoiceUid))){
                model.addAttribute("code", -3000);
                log.info("is not your invoice");
                return "/common/success";
            }

            invoiceService.delete(id);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete invoice : " + id);
            // for test
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    //修改地址记录
    @RequestMapping(value = "/a/u/invoice/{id}", method = RequestMethod.PUT)
    public String getInvoiceJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                 @PathVariable Long id, @RequestBody Invoice invoiceNew) throws Exception {

        log.info("update invoice : " + id);
        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);

        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }

        try {

            Invoice invoiceOld = invoiceService.getObjectById(id);
            if(null==invoiceOld){
                model.addAttribute("code", -4002);
                log.info("invoice not exist");
                return "/common/success";
            }
            Long invoiceUid = invoiceOld.getUid();
            if(!(uid.equals(invoiceUid))){
                model.addAttribute("code", -3000);
                log.info("is not your invoice");
                return "/common/success";
            }

            invoiceNew.setUid(uid);
            invoiceNew.setId(id);
            invoiceNew.setType(invoiceOld.getType());
            invoiceNew.setCreateAt(invoiceOld.getCreateAt());
            invoiceNew.setCreateBy(invoiceOld.getCreateBy());
            invoiceService.update(invoiceNew);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get invoice error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //查询用户发票记录列表
    @RequestMapping(value = "/a/u/invoice/list", method = RequestMethod.GET)
    public String getInvoiceList(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {

        List<Invoice> invoices = new ArrayList<>();
        Long uid = cookieUtil.getID(request);
        User user = userService.getObjectById(uid);
        log.info("get invoice list : " + uid);

        if (null == uid) {
            model.addAttribute("code", -2000);
            log.info("user not exist");
            return "/common/success";
        }

        try {

            List<Long> invoiceIds = invoiceService.getInvoiceIdsByUid(uid, 0 ,Integer.MAX_VALUE);

            log.info("invoiceIds : " + invoiceIds);
            if (CollectionUtils.isNotEmpty(invoiceIds)) {
                invoices = invoiceService.getObjectsByIds(invoiceIds);
            }

            List<Long> defaultId = invoiceService.getInvoiceIdsByUidAndType(uid, TYPE_DEFAULT, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isNotEmpty(defaultId)) {
//                model.addAttribute("defaultId", defaultId.get(0));
            }
            log.info("default is : " + defaultId.get(0));

            model.addAttribute("code", 0);
            model.addAttribute("invoices", invoices);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update invoice error,id is  " +uid);
            model.addAttribute("code", -6003);

        }

        return "/wealth-finance-service/invoice/json/invoiceListJson";
    }
}

