package com.ptteng.wealth.finance.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.OrderService;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.service.FundService;

/**
 * Fund  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class FundController {
	private static final Log log = LogFactory.getLog(FundController.class);

	@Autowired
	private FundService fundService;

	@Autowired
	private OrderService orderService;

	@Autowired
	private UserService userService;




	@RequestMapping(value = "/a/order/{oid}/detail", method = RequestMethod.GET)
	public String orderDetail(HttpServletRequest request, ModelMap model, HttpServletResponse response,@PathVariable Long oid) throws Exception {
		// 这里的name是单元name
		log.info("get  order detail  data : "+oid);
		try {
			Order order=this.orderService.getObjectById(oid);
			if(order==null){
				model.addAttribute("code", -2000);
				return "/data/json";
			}else{
				User user=this.userService.getObjectById(order.getUid());
				model.addAttribute("code", 0);
				model.addAttribute("order", order);
				model.addAttribute("user", user);
			}

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error(" get  user error "+oid);
			model.addAttribute("code", -1);
		}

		return "/wealth-finance-service/order/json/orderDetailJson";
	}
	
	
}

