//package com.ptteng.wealth.finance.controller;
//
//import java.math.BigDecimal;
//import java.util.HashMap;
//import java.util.List;
//
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//
//
//import com.gemantic.common.util.MyTimeUtil;
//import com.gemantic.common.util.PasswordUtils;
//import com.ptteng.wealth.BaseController;
//import com.ptteng.wealth.admin.service.ConstantService;
//import com.ptteng.wealth.consign.constant.GlobalConstant;
//import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
//import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
//import com.ptteng.wealth.consign.model.in.BalanceInquiryIn;
//import com.ptteng.wealth.consign.model.in.BindingBankIn;
//import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
//import com.ptteng.wealth.consign.model.out.BalanceInquiryOut;
//import com.ptteng.wealth.consign.model.out.BindingBank;
//import com.ptteng.wealth.consign.service.ConsignmentService;
//import com.ptteng.wealth.finance.model.Fund;
//import com.ptteng.wealth.finance.model.LoanApply;
//import com.ptteng.wealth.finance.model.Order;
//import com.ptteng.wealth.finance.model.account.Account;
//import com.ptteng.wealth.finance.model.account.UserAccountRelation;
//import com.ptteng.wealth.finance.service.FundService;
//import com.ptteng.wealth.finance.service.OrderService;
//import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
//import com.ptteng.wealth.finance.util.FinanceConstant;
//import com.ptteng.wealth.finance.util.PayAccountUtil;
//import com.ptteng.wealth.user.model.Organization;
//import com.ptteng.wealth.user.model.Person;
//import com.ptteng.wealth.user.model.User;
//import com.ptteng.wealth.user.service.UserService;
//import com.ptteng.wealth.user.util.Constant;
//import com.ptteng.wealth.util.DebtConstant;
//import com.qding.common.util.http.cookie.CookieUtil;
//import org.apache.commons.logging.Log;
//import org.apache.commons.logging.LogFactory;
//import org.aspectj.weaver.ast.Or;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.ui.ModelMap;
//import org.springframework.web.bind.annotation.PathVariable;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestMethod;
//
//import com.ptteng.wealth.finance.model.DebtApply;
//import com.ptteng.wealth.finance.service.DebtApplyService;
//
//import static java.lang.Math.ceil;
//
///**
// * DebtApply  crud
// *
// * @author magenm
// * @Date 2014-4-16 13:43
// */
//@Controller
//public class DebtController extends BaseController {
//    private static final Log debtLog = LogFactory.getLog("debt_log");
//    private static final Log depositPayLog = LogFactory.getLog("deposit_pay_log");
//
//    /**
//     * @param
//     * @return
//     * @throws Exception
//     */
//    //用户本人借贷详情
//    @RequestMapping(value = "/a/u/debt/self", method = RequestMethod.GET)
//    public String getUserDebtDetail(HttpServletRequest request, HttpServletResponse response, ModelMap model) throws Exception {
//
//        BigDecimal overTotalRepay = new BigDecimal("0");
//        BigDecimal repayLine = new BigDecimal("0");
//        BigDecimal overRepay = new BigDecimal("0");
//        BigDecimal overRate = new BigDecimal("0");
//        BigDecimal supposeRepay = new BigDecimal("0");
//        BigDecimal totalRepay = new BigDecimal("0");
//        BigDecimal debtCount = new BigDecimal("0");
//        BigDecimal rate = new BigDecimal("0");
//        BigDecimal dayCount = new BigDecimal("0");
//        Long debtStart = 0L;
//        Long time = 0L;
//
//        Long uid = cookieUtil.getID(request);
//        User user = userService.getObjectById(uid);
//        debtLog.info("get user : " + uid + " debt detail");
//
//        if (null == uid) {
//            model.addAttribute("code", -2000);
//            debtLog.info("user not exist");
//            return "/common/success";
//        }
//
//        try {
//            Fund fund = fundService.getObjectById(uid);
//
//            if (null == fund) {
//                model.addAttribute("code", -2010);
//                debtLog.info("the user have no fund");
//                return "/common/success";
//            }
//            Long id1 = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, UserAccountRelation.Account_CODE_1);
//            debtLog.info("id1 : " + id1);
//            UserAccountRelation account1 = userAccountRelationService.getObjectById(id1);
//            BigDecimal fundA = account1.getMoney();
//            debtLog.info("fundA" + fundA);
//
//            Long id2 = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, UserAccountRelation.Account_CODE_2);
//            UserAccountRelation account2 = userAccountRelationService.getObjectById(id2);
//            BigDecimal fundB = account2.getMoney();
//
//            //还款中金额
//            List<Long> repayIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_REPAY, 0, Integer.MAX_VALUE);
//            List<DebtApply> repayApply = debtApplyService.getObjectsByIds(repayIds);
//            debtLog.info("get debt repay data is " + repayApply.size());
//
//            for (DebtApply debtApply : repayApply) {
//                //借款本金利率
//                debtCount = debtApply.getDebtCount();
//                rate = debtApply.getRate();
//
//                //获取当前借款时间
//                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
//                time = System.currentTimeMillis() - debtStart;
//                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));
//
//                //加上本息
//                supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
//                totalRepay = totalRepay.add(supposeRepay);
//            }
//
//            List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_OVERTIME, 0, Integer.MAX_VALUE);
//            List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
//            debtLog.info("get debt over time data is " + debtApplys.size());
//
//            for (DebtApply debtApply : debtApplys) {
//                //借款本金、利率
//                debtCount = debtApply.getDebtCount();
//                overRate = debtApply.getOverRate();
//                rate = debtApply.getRate();
//
//                //获取总借款利息
//                repayLine = new BigDecimal(debtApply.getRepayLine());
//                overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
//
//                //获取当前逾期时间
//                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
//                time = System.currentTimeMillis() - debtStart;
//                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//
//                //获取当前罚息
//                overRepay = caculate(overTotalRepay, overRate, dayCount).add(overTotalRepay);
//                totalRepay = totalRepay.add(overRepay);
//            }
//
//            fund.setRepayTot(totalRepay);
//
//            //赊销总金额
//            BigDecimal totalLoanMoney = new BigDecimal("0");
//            List<Long> idLs = loanApplyService.getLoanApplyIdsByUid(uid, 0, Integer.MAX_VALUE);
//            List<LoanApply> loanApplies = loanApplyService.getObjectsByIds(idLs);
//            for (LoanApply loanApply : loanApplies) {
//                if (loanApply.getStatus().equals(LoanApply.STATUS_CLEAR) || loanApply.getStatus().equals(LoanApply.STATUS_REFUSE)
//                        || loanApply.getStatus().equals(LoanApply.STATUS_KAILIN_REFUSE) || loanApply.getStatus().equals(LoanApply.STATUS_CANCEL)) {
//                    continue;
//                }
//                totalLoanMoney = totalLoanMoney.add(loanApply.getDebtCount());
//            }
//
//            model.addAttribute("code", 0);
//            model.addAttribute("fund", fund);
//            model.addAttribute("fundA", fundA);
//            model.addAttribute("fundB", fundB);
//            model.addAttribute("totalLoanMoney", totalLoanMoney);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("get debtDetail error");
//            // for test
//            model.addAttribute("code", -1);
//        }
//
//        return "/wealth-finance-service/fund/json/fundDetail";
//    }
//
//    //30、查看借款详情
//    @RequestMapping(value = "/a/u/debt/detail/{id}", method = RequestMethod.GET)
//    public String getDebtDetail(HttpServletRequest request, ModelMap model, @PathVariable Long id) throws Exception {
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("user : " + uid + " get debt " + id + " detail");
//        User user = userService.getObjectById(uid);
//        debtLog.info("1 ");
//        try {
//            //第一步： 获取借款申请
//            DebtApply debtApply = debtApplyService.getObjectById(id);
//            debtLog.info("2 ");
//            //订单是否存在
//            if (null == debtApply) {
//                model.addAttribute("code", -3007);
//                debtLog.info("debt not exist");
//                return "/common/success";
//            }
//            debtLog.info("2 ");
//            //改订单是否为登陆用户订单
//            if (uid == debtApply.getUid()) {
//                debtLog.info("is not your debtApply");
//                model.addAttribute("code", -3006);
//                return "/common/success";
//            }
//            //第二步： 获取借款申请所对应的订单信息
//            Order order = orderService.getObjectById(debtApply.getOrderID());
//            debtLog.info("orderId: " + order);
//            debtLog.info("3 ");
//
//            //第三步: 获取账户基金信息
//            Fund fund = fundService.getObjectById(uid);
//            if (null == fund) {
//                model.addAttribute("code", -2010);
//                debtLog.info("the user have no fund");
//                return "/common/success";
//            }
//            model.addAttribute("fund", fund);
//
//            debtLog.info("4 ");
//
//            //第四步： 获取开磷账户信息
//            String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
//            //非常关键，获取要支付的开磷账号
//            Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
//            UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
//            Account account = accountService.getObjectById(userAccountRelation.getAccountId());
//            userAccountRelation.setAccountName(account.getName());
//            model.addAttribute("userAccount", userAccountRelation);
//            debtLog.info("use account relation : " + userAccountRelation);
//
//            //第五步: 获取代销账户信息
//            BalanceInquiryOut balance = null;
//            try {
//                BalanceInquiryIn balanceInquiryIn = new BalanceInquiryIn();
//                balanceInquiryIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                balanceInquiryIn.setFundAccount(user.getFundAccount());
//                balanceInquiryIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                balanceInquiryIn.setUserId(user.getId() + "");
//                if (user.getType().intValue() == User.TYPE_PERSON.intValue()) {
//                    Person person = personService.getObjectById(user.getId());
//                    balanceInquiryIn.setCertType("0");
//                    balanceInquiryIn.setCertId(person.getIdNo());
//                    balanceInquiryIn.setUserNameText(user.getName());
//                } else if (user.getType().intValue() == User.TYPE_ORG.intValue()) {
//                    Organization organization = organizationService.getObjectById(user.getId());
//                    balanceInquiryIn.setCertType(Constant.IDKIND);
//                    balanceInquiryIn.setUserNameText(organization.getName());
//                    balanceInquiryIn.setCertId(organization.getUseCertId());
//                }
//                balanceInquiryIn.setPassword(user.getPayPwd());
//                balanceInquiryIn.setGtTradePassword(user.getPayPwd());
//                balanceInquiryIn.setIfQueryTransitmAmt("1");
//                balance = consignmentService.getBalance(balanceInquiryIn);
//            } catch (Exception e) {
//                debtLog.info(e.getMessage());
//            }
//            if (null != balance) {
//                model.addAttribute("wayFund", balance.getRedeeTransitmAmt());
//                model.addAttribute("balance", balance.getTotalAmt());
//            } else {
//                model.addAttribute("wayFund", 0);
//                model.addAttribute("balance", 0);
//            }
//
//            //第六步：根据借款申请类型获得详情参数
//            Integer type = debtApply.getType();
//            if (DebtApply.TYPE_OVERTIME == type) {
//                BigDecimal debtCount = debtApply.getDebtCount();
//                BigDecimal overRate = debtApply.getOverRate();
//                BigDecimal rate = debtApply.getRate();
//
//                //获取总借款利息
//                BigDecimal repayLine = new BigDecimal(debtApply.getRepayLine());
//                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
//
//                //获取当前逾期时间
//                Long debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
//                Long time = System.currentTimeMillis() - debtStart;
//                BigDecimal dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//
//                //获取当前罚息
//                BigDecimal overRepay = caculate(overTotalRepay, overRate, dayCount);
//                BigDecimal totalMoney = overTotalRepay.add(overRepay);
//
//                debtApply.setOverDayCount(dayCount);
//                debtApply.setClearOverInte(overRepay);
//                debtApply.setRepayTot(totalMoney);
//            } else if (DebtApply.TYPE_REPAY.equals(debtApply.getType())) {
//                debtLog.info("repay debtApply ");
//
//                //借款本金、利率
//                BigDecimal debtCount = debtApply.getDebtCount();
//                BigDecimal overRate = debtApply.getOverRate();
//                BigDecimal rate = debtApply.getRate();
//
//                //获取总借款利息
//                BigDecimal repayLine = new BigDecimal(debtApply.getRepayLine());
//                BigDecimal overTotalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
//                debtApply.setRepayTot(overTotalRepay);
//
//            }
//
//            model.addAttribute("code", 0);
//            model.addAttribute("debtApply", debtApply);
//            model.addAttribute("order", order);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("get debt detail error , id is  " + id);
//            model.addAttribute("code", -1);
//        }
//        return "/wealth-finance-service/debt/json/getDebtDetail";
//    }
//
//    //31、缴纳保证金
//    @RequestMapping(value = "/a/u/load/deposi/{id}", method = RequestMethod.PUT)
//    public String updateDebtDeposi(HttpServletRequest request, ModelMap model,
//                                   @PathVariable Long id, String paypwd, Integer paymentType) throws Exception {
//
//        BigDecimal money = new BigDecimal("0");
//        BigDecimal payCount = new BigDecimal("0");
//        Integer result = 0;
//        Long uid = cookieUtil.getID(request);
//        depositPayLog.info("====================================================================");
//        depositPayLog.info(" PAY Deposit UserId: " + uid + "  DebtApplyId: " + id + "  paypwd: " + paypwd + "  paymentType: " + paymentType);
//        try {
//            User user = userService.getObjectById(uid);
//            DebtApply debtApply = debtApplyService.getObjectById(id);
//            depositPayLog.info("DebtApply  status : " + debtApply.getStatus());
//            if (!DebtApply.STATUS_PASS.equals(debtApply.getStatus())) {
//                model.addAttribute("code", -3008);
//                depositPayLog.info("PARAMFAIL: the loan not pass");
//                return "/common/success";
//            }
//            Long oid = debtApply.getOrderID();
//            Order order = orderService.getObjectById(oid);
//            if (null == order) {
//                model.addAttribute("code", -3015);
//                depositPayLog.info("PARAMFAIL: no such order");
//                return "/common/success";
//            }
//            depositPayLog.info("DebtApply  orderType: " + order.getDepartment());
//
//            //缴纳支付密码
//            if (paymentType == Order.Pay_Type_fund) {
//                if (user.getPayPwd().isEmpty()) {
//                    model.addAttribute("code", -3016);
//                    depositPayLog.info("USER: no payPwd");
//                    return "/common/success";
//                }
//                depositPayLog.info(" inputpass: " + paypwd + "  dbpasswords: " + user.getPayPwd());
//                boolean verify = paypwd.equals(user.getPayPwd().trim());
//                depositPayLog.info(" verify: " + verify);
//                if (!verify) {
//                    depositPayLog.info(uid + " wrong password " + paypwd);
//                    model.addAttribute("code", -2004);
//                    return "/common/success";
//                }
//            } else if (Order.Pay_Type_klfund.equals(paymentType)) {
//                String pass = PasswordUtils.encode(paypwd);
//                String passwords = user.getPwd();
//                depositPayLog.info(" inputpass: " + pass + "  dbpasswords: " + passwords);
//                boolean verify = passwords.trim().equals(pass.trim());
//                depositPayLog.info(" verify: " + verify);
//                if (!verify) {
//                    depositPayLog.info(uid + " wrong password " + paypwd);
//                    model.addAttribute("code", -2004);
//                    return "/common/success";
//                }
//            }
//            //保证金金额
//            payCount = debtApply.getTotal().subtract(debtApply.getDebtCount());
//            depositPayLog.info(" DebtApply payCount : " + payCount);
//            depositPayLog.info(" DebtApply : " + debtApply);
//            depositPayLog.info(" PAY Money Count: " + payCount);
//
//            Long time = (debtApply.getRepayLine() - 1) * FinanceConstant.DAILY_TIME;
//            Long overAt = MyTimeUtil.getDateEndTimeMillions(System.currentTimeMillis() + time).getTime();
//            depositPayLog.info(" OverAt : " + overAt);
//
//            //第一步：通过代销接口支付保证金
//            if (Order.Pay_Type_fund.equals(paymentType)) {
//                depositPayLog.info(" DAIXIAO PAY .. ");
//                AutoDocBailRechargeOut autoDocBailRechargeOut = null;
//                BindingBank bindingBank = null;
//                try {
//                    //一.  机构用户处理逻辑
//                    BindingBankIn bindingBankIn = new BindingBankIn();
//                    bindingBankIn.setUserId(user.getId() + "");
//                    bindingBankIn.setFundAccount(user.getFundAccount());
//                    bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
//                    for (BindingBank bank : bindingBanks) {
//                        if (bank.getBankNo().equals("ZLRT")) {
//                            bindingBank = bank;
//                            break;
//                        }
//                    }
//                    depositPayLog.info(" BANK:  " + bindingBank);
//                    AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
//                    organBindCardIn.setUserId(user.getId() + "");
//                    organBindCardIn.setFundAccount(user.getFundAccount());
//                    organBindCardIn.setPassword(paypwd);
//                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    organBindCardIn.setFundAccountG(user.getFundAccount());
//                    organBindCardIn.setOpbusinessFlag("8035");
//                    organBindCardIn.setOccurBalanceG(order.getPriceTot());
//                    organBindCardIn.setTiedCardType("0");
//                    organBindCardIn.setMoneyType("0");
//                    organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
//                    organBindCardIn.setFundCode(990006 + "");
//                    organBindCardIn.setPayType("0");
//                    organBindCardIn.setChannelResource("");
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setBankNoDk("ZLRT");
//                    organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setAutotransNo("");
//                    depositPayLog.info("organBindCardIn : " + organBindCardIn);
//                    autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
//                } catch (Exception e) {
//                    e.printStackTrace(System.out);
//                    depositPayLog.error(e.getMessage());
//                }
//                depositPayLog.info(autoDocBailRechargeOut);
//                model.put("code", autoDocBailRechargeOut.getErrorNo());
//                model.put("message", autoDocBailRechargeOut.getErrorInfo());
//                depositPayLog.info("error code is " + autoDocBailRechargeOut.getErrorNo());
//                depositPayLog.info("error info is " + autoDocBailRechargeOut.getErrorInfo());
//                if (0 == autoDocBailRechargeOut.getErrorNo()) {
//                    depositPayLog.info(" DAI XIAO Success ");
//                    result = userAccountRelationService.payDepositdaixiao(debtApply.getDebtCount().doubleValue(), debtApply.getId(), uid, oid, overAt);
//                    depositPayLog.info("DB result:  " + result);
//                    model.addAttribute("code", result);
//                } else {
//                    depositPayLog.info("DAI XIAO fail");
//                }
//                return "/common/pay";
//            }
//            //第二步：通过开磷账户进行支付
//            else if (Order.Pay_Type_klfund.equals(paymentType)) {
//                depositPayLog.info(" KAILIN  PAY .. ");
//                String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
//                //非常关键，获取要支付的开磷账号
//                Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
//                depositPayLog.info(" accountCode: " + accountCode + "  userAccountId: " + userAccountId + " payCount: " + payCount.doubleValue() + " debtCount: " + debtApply.getDebtCount().doubleValue() + " orderId: " + order + " debtApply: " + debtApply.getId());
//                if (null != userAccountId) {
//                    result = userAccountRelationService.payDeposit(userAccountId, payCount.doubleValue(), debtApply.getDebtCount().doubleValue(), debtApply.getId(), user.getId(), order.getId(), overAt);
//                } else {
//                    result = -3022;
//                }
//                depositPayLog.info("DB result: " + result);
//                model.addAttribute("code", result);
//            } else {
//                model.addAttribute("code", -3011);
//            }
//        } catch (Throwable t) {
//            t.printStackTrace(System.out);
//            depositPayLog.error(t.getMessage());
//            depositPayLog.error("update updateDebt deposi , id is  " + id);
//            model.addAttribute("code", -1);
//        }
//        return "/common/success";
//    }
//
//
//    //32、还款
//    @RequestMapping(value = "/a/u/debt/pay/{id}", method = RequestMethod.PUT)
//    public String repay(HttpServletRequest request, ModelMap model,
//                        @PathVariable Long id, String paypwd, Integer paymentType) throws Exception {
//
//        BigDecimal payCount = new BigDecimal("0");
//        Integer result = 0;
//        Long uid = cookieUtil.getID(request);
//        depositPayLog.info("====================================================================");
//        depositPayLog.info(" PAY Deposit UserId: " + uid + "  LoanApplyId: " + id + "  paypwd: " + paypwd + "  paymentType: " + paymentType);
//        try {
//            User user = userService.getObjectById(uid);
//            DebtApply debtApply = debtApplyService.getObjectById(id);
//            depositPayLog.info("DebtApply status : " + debtApply.getStatus());
//            if (!DebtApply.STATUS_REPAY.equals(debtApply.getStatus())&&!DebtApply.STATUS_OVERTIME.equals(debtApply.getStatus())) {
//                model.addAttribute("code", -3029);
//                depositPayLog.info("PARAMFAIL: the debt not pass");
//                return "/common/success";
//            }
//            Long oid = debtApply.getOrderID();
//            Order order = orderService.getObjectById(oid);
//            if (null == order) {
//                model.addAttribute("code", -3015);
//                depositPayLog.info("PARAMFAIL: no such order");
//                return "/common/success";
//            }
//            //缴纳支付密码
//            if (paymentType == Order.Pay_Type_fund) {
//                if (user.getPayPwd().isEmpty()) {
//                    model.addAttribute("code", -3016);
//                    depositPayLog.info("USER: no payPwd");
//                    return "/common/success";
//                }
//                depositPayLog.info(" inputpass: " + paypwd + "  dbpasswords: " + user.getPayPwd());
//                boolean verify = paypwd.equals(user.getPayPwd().trim());
//                depositPayLog.info(" verify: " + verify);
//                if (!verify) {
//                    depositPayLog.info(uid + " wrong password " + paypwd);
//                    model.addAttribute("code", -2004);
//                    return "/common/success";
//                }
//            } else if (Order.Pay_Type_klfund.equals(paymentType)) {
//                String pass = PasswordUtils.encode(paypwd);
//                String passwords = user.getPwd();
//                depositPayLog.info(" inputpass: " + pass + "  dbpasswords: " + passwords);
//                boolean verify = passwords.trim().equals(pass.trim());
//                depositPayLog.info(" verify: " + verify);
//                if (!verify) {
//                    depositPayLog.info(uid + " wrong password " + paypwd);
//                    model.addAttribute("code", -2004);
//                    return "/common/success";
//                }
//            }
//
//            //生成需要更新的数据，利息，罚息，逾期天数，还款总额，还款时间
//            //借款本金、利率
//            BigDecimal dayCount = new BigDecimal("0");
//            BigDecimal overRepay = new BigDecimal("0");
//            BigDecimal totalRepay = new BigDecimal("0");
//            BigDecimal debtCount = new BigDecimal("0");
//            BigDecimal overRate = new BigDecimal("0");
//            BigDecimal repayLine = new BigDecimal("0");
//            BigDecimal rate = new BigDecimal("0");
//            BigDecimal lx = new BigDecimal("0");
//            BigDecimal totalMoney = new BigDecimal("0");
//
//
//            debtCount = debtApply.getDebtCount();
//            overRate = debtApply.getOverRate();
//            rate = debtApply.getRate();
//
//            //获取总借款利息
//            repayLine = new BigDecimal(debtApply.getRepayLine());
//            lx = caculate(debtCount, rate, repayLine);
//            totalRepay = lx.add(debtCount);
//
//            //获取当前逾期时间
//            long debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
//            long time = System.currentTimeMillis() - debtStart;
//            dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//            if (dayCount.doubleValue() < 0) {
//                dayCount = new BigDecimal("0");
//            }
//
//            //获取当前罚息
//            overRepay = caculate(totalRepay, overRate, dayCount);
//
//            //待还总额
//            totalMoney = totalRepay.add(overRepay);
//
//
//            //第一步：通过代销接口还款
//            if (Order.Pay_Type_fund.equals(paymentType)) {
//                depositPayLog.info(" DAIXIAO PAY .. ");
//                AutoDocBailRechargeOut autoDocBailRechargeOut = null;
//                BindingBank bindingBank = null;
//                try {
//                    //一.  机构用户处理逻辑
//                    BindingBankIn bindingBankIn = new BindingBankIn();
//                    bindingBankIn.setUserId(user.getId() + "");
//                    bindingBankIn.setFundAccount(user.getFundAccount());
//                    bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
//                    for (BindingBank bank : bindingBanks) {
//                        if (bank.getBankNo().equals("ZLRT")) {
//                            bindingBank = bank;
//                            break;
//                        }
//                    }
//                    depositPayLog.info(" BANK:  " + bindingBank);
//                    AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
//                    organBindCardIn.setUserId(user.getId() + "");
//                    organBindCardIn.setFundAccount(user.getFundAccount());
//                    organBindCardIn.setPassword(paypwd);
//                    organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
//                    organBindCardIn.setFundAccountG(user.getFundAccount());
//                    organBindCardIn.setOpbusinessFlag("8035");
//                    organBindCardIn.setOccurBalanceG(order.getPriceTot());
//                    organBindCardIn.setTiedCardType("0");
//                    organBindCardIn.setMoneyType("0");
//                    organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
//                    organBindCardIn.setFundCode(990006 + "");
//                    organBindCardIn.setPayType("0");
//                    organBindCardIn.setChannelResource("");
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setBankNoDk("ZLRT");
//                    organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
//                    organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
//                    organBindCardIn.setAutotransNo("");
//                    depositPayLog.info("organBindCardIn : " + organBindCardIn);
//                    autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
//                } catch (Exception e) {
//                    e.printStackTrace(System.out);
//                    depositPayLog.error(e.getMessage());
//                }
//                depositPayLog.info(autoDocBailRechargeOut);
//                model.put("code", autoDocBailRechargeOut.getErrorNo());
//                model.put("message", autoDocBailRechargeOut.getErrorInfo());
//                depositPayLog.info("error code is " + autoDocBailRechargeOut.getErrorNo());
//                depositPayLog.info("error info is " + autoDocBailRechargeOut.getErrorInfo());
//                if (0 == autoDocBailRechargeOut.getErrorNo()) {
//                    depositPayLog.info(" DAI XIAO Success ");
//
//                    //修改借款申请
//                    debtApply = updateDebtApply(debtApply, overRepay, lx, totalMoney, dayCount);
//                    debtApplyService.update(debtApply);
//                    depositPayLog.info(" update debtApply success");
//
////                    result = userAccountRelationService.shexiaoDX(totalMoney.doubleValue(), lx.doubleValue(), overRepay.doubleValue(), Double.parseDouble(dayCount + ""), System.currentTimeMillis(), id, order.getId(), System.currentTimeMillis());
//                    depositPayLog.info("DB result:  " + result);
//                    model.addAttribute("code", result);
//                } else {
//                    depositPayLog.info("DAI XIAO fail");
//                }
//                return "/common/pay";
//            }
//            //第二步：通过开磷账户进行支付
//            else if (Order.Pay_Type_klfund.equals(paymentType)) {
//                depositPayLog.info(" KAILIN  PAY .. ");
//                String accountCode = PayAccountUtil.getRightPayAccount(order.getDepartment());
//                //非常关键，获取要支付的开磷账号
//                Long userAccountId = userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(uid, accountCode);
//                depositPayLog.info(" accountCode: " + accountCode + "  userAccountId: " + userAccountId + " payCount: " + payCount.doubleValue() + " debtCount: " + debtApply.getDebtCount().doubleValue() + " orderId: " + order + " loanApply: " + debtApply.getId());
//                if (null != userAccountId) {
//
//                    //修改借款申请
//                    debtApply = updateDebtApply(debtApply, overRepay, lx, totalMoney, dayCount);
//                    debtApplyService.update(debtApply);
//                    depositPayLog.info(" update debtApply success");
//
//                    UserAccountRelation userAccountRelation = userAccountRelationService.getObjectById(userAccountId);
//                    BigDecimal money = userAccountRelation.getMoney();
//                    userAccountRelation.setMoney(money.subtract(totalMoney));
//                    userAccountRelationService.update(userAccountRelation);
//                    debtLog.info("money : " + money + " >>>>>>>>>> " + userAccountRelation.getMoney());
//
////                    result = userAccountRelationService.shexiaoKL(userAccountId, totalMoney.doubleValue(), lx.doubleValue(), overRepay.doubleValue(), Double.parseDouble(dayCount + ""), System.currentTimeMillis(), id, order.getId(), System.currentTimeMillis());
//                } else {
//                    result = -3022;
//                }
//                depositPayLog.info("DB result: " + result);
//                model.addAttribute("code", result);
//            } else {
//                model.addAttribute("code", -3011);
//            }
//        } catch (Throwable t) {
//            t.printStackTrace(System.out);
//            depositPayLog.error(t.getMessage());
//            depositPayLog.error("update updateDebt deposi , id is  " + id);
//            model.addAttribute("code", -1);
//        }
//        return "/common/success";
//    }
//
//
//    /**
//     * @param
//     * @return
//     * @throws Exception
//     */
//    //33、取消借款
//    @RequestMapping(value = "/a/u/cancel/debt/{id}", method = RequestMethod.PUT)
//    public String cancelDebt(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
//
//        Long uid = cookieUtil.getID(request);
//        User user = userService.getObjectById(uid);
//        debtLog.info("delete debt : " + id);
//
//        if (null == uid) {
//            model.addAttribute("code", -2000);
//            debtLog.info("user not exist");
//            return "/common/success";
//        }
//
//        try {
//            //判断取消借款是否状态在审核通过之前
//            DebtApply debtApply = debtApplyService.getObjectById(id);
//
//            if (null == debtApply) {
//                model.addAttribute("code", -3007);
//                debtLog.info("debt not exist");
//                return "/common/success";
//            }
//
//            if (!uid.equals(debtApply.getUid())) {
//                debtLog.info("is not your debtApply");
//                model.addAttribute("code", -3005);
//                return "/common/success";
//            }
//
//            Integer status = debtApply.getStatus();
//            if (status >= 1) {
//                debtLog.info("debt apply verify pass");
//                model.addAttribute("code", -3003);
//                return "/common/success";
//            }
//
//            //取消借款申请
//            debtApply.setStatus(DebtApply.STATUS_CANCEL);
//            debtApplyService.update(debtApply);
//
//            Order order = orderService.getObjectById(debtApply.getOrderID());
//
//            if (order == null) {
//                log.error(debtApply.getId() + " debt not get any order " + debtApply.getOrderID());
//
//            } else {
//                order.setStatus(Order.STATUS_FAIL);
//                this.orderService.update(order);
//                log.info(debtApply.getId() + " update order status " + debtApply.getOrderID());
//
//            }
//
//            model.addAttribute("code", 0);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("delete debt : " + id + " error");
//            // for test
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }
//
//    /**
//     * @param
//     * @return
//     * @throws Exception
//     */
//    //34、删除已取消、已拒绝借款
//    @RequestMapping(value = "/a/u/debt/{id}", method = RequestMethod.DELETE)
//    public String deleteDebt(HttpServletRequest request, HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
//
//        Long uid = cookieUtil.getID(request);
//        User user = userService.getObjectById(uid);
//        debtLog.info("delete debt : " + id);
//
//        if (null == uid) {
//            model.addAttribute("code", -2000);
//            debtLog.info("user not exist");
//            return "/common/success";
//        }
//
//        try {
//            //判断删除借款是否状态为取消或拒绝
//            DebtApply debtApply = debtApplyService.getObjectById(id);
//
//            if (null == debtApply) {
//                model.addAttribute("code", -3007);
//                debtLog.info("debt not exist");
//                return "/common/success";
//            }
//
//            if (uid.equals(debtApply.getUid())) {
//                debtLog.info("is not your debtApply");
//                model.addAttribute("code", -3006);
//                return "/common/success";
//            }
//
//            Integer status = debtApply.getStatus();
//            if (status != DebtApply.STATUS_REFUSE && status != DebtApply.STATUS_CANCEL) {
//                debtLog.info("debt apply not cancel or refuse");
//                model.addAttribute("code", -3004);
//                return "/common/success";
//            }
//
//            //删除借款申请
//            debtApplyService.delete(id);
//
//            model.addAttribute("code", 0);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("delete debt : " + id + " error");
//            // for test
//            model.addAttribute("code", -1);
//        }
//
//        return "/common/success";
//    }
//
//    //35、各借款数量
//    @RequestMapping(value = "/a/u/debt/count", method = RequestMethod.GET)
//    public String getDebtNum(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("get user : " + uid + " debt list ");
//        User user = userService.getObjectById(uid);
//
//        try {
//            Integer applyCount = debtApplyService.countDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_VERIFYING);
//            Integer repayCount = debtApplyService.countDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_REPAY);
//            Integer overTimeCount = debtApplyService.countDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_OVERTIME);
//            Integer clearCount = debtApplyService.countDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_CLEAR);
//            model.addAttribute("code", 0);
//            model.addAttribute("applyCount", applyCount);
//            model.addAttribute("repayCount", repayCount);
//            model.addAttribute("overCount", overTimeCount);
//            model.addAttribute("clearCount", clearCount);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("et user debt list error, uid is  " + uid);
//            model.addAttribute("code", -1);
//        }
//
//        return "/wealth-finance-service/debt/json/getDebtNum";
//    }
//
//    //36、申请借款列表
//    @RequestMapping(value = "/a/u/apply/debt/list", method = RequestMethod.GET)
//    public String getDebtApply(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
//
//        if (null == page) {
//            page = 1;
//        }
//        if (null == size) {
//            size = 10;
//        }
//        int firstNmuber = (page - 1) * size;
//        Boolean next = false;
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("get user : " + uid + " debt list ");
//        User user = userService.getObjectById(uid);
//
//        try {
//            List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_VERIFYING, firstNmuber, size);
//            List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
//            debtLog.info("get debtApplys data is " + debtApplys.size());
//
//            debtLog.info("   total = " + debtApplieIds.size());
//            Integer totalPage = (((debtApplieIds.size() - 1)) / size) + 1;
//            debtLog.info("   totalPage = " + totalPage);
//
//            if (debtApplieIds != null && debtApplieIds.size() > 0) {
//                if (size.equals(debtApplieIds.size())) {
//                    next = true;
//                    debtApplieIds = debtApplieIds.subList(0, size);
//                }
//            }
//
//            model.addAttribute("code", 0);
//            model.addAttribute("next", next);
//            model.addAttribute("debtApplys", debtApplys);
//
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("et user debt list error, uid is  " + uid);
//            model.addAttribute("code", -1);
//        }
//
//        return "/wealth-finance-service/debt/json/applyDebtList";
//    }
//
//    //37、还款中借款列表
//    @RequestMapping(value = "/a/u/repay/debt/list", method = RequestMethod.GET)
//    public String getDebtRepay(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
//        HashMap<Long, BigDecimal> id_supposeRepay = new HashMap<>();
//        BigDecimal dayCount = new BigDecimal("0");
//        BigDecimal supposeRepay = new BigDecimal("0");
//        BigDecimal debtCount = new BigDecimal("0");
//        BigDecimal rate = new BigDecimal("0");
//        Long debtStart = 0L;
//        Long overTime = 0L;
//        Long time = 0L;
//
//        if (null == page) {
//            page = 1;
//        }
//        if (null == size) {
//            size = 10;
//        }
//        int firstNmuber = (page - 1) * size;
//        Boolean next = false;
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("get user : " + uid + " debt list ");
//        User user = userService.getObjectById(uid);
//
//        try {
//            List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_REPAY, firstNmuber, size);
//            List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
//            debtLog.info("get debt repay data is " + debtApplys.size());
//
//            for (DebtApply debtApply : debtApplys) {
//                //借款本金利率
//                debtCount = debtApply.getDebtCount();
//                rate = debtApply.getRate();
//
//                //获取当前借款时间
//                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getDebtAt()).getTime();
//                time = System.currentTimeMillis() - debtStart;
//                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME));
//
//                //计算当前本息
//                supposeRepay = caculate(debtCount, rate, dayCount).add(debtCount);
//                id_supposeRepay.put(debtApply.getId(), supposeRepay);
//            }
//            debtLog.info("   total = " + debtApplieIds.size());
//            Integer totalPage = (((debtApplieIds.size() - 1)) / size) + 1;
//            debtLog.info("   totalPage = " + totalPage);
//
//            if (debtApplieIds != null && debtApplieIds.size() > 0) {
//                if (size.equals(debtApplieIds.size())) {
//                    next = true;
//                    debtApplieIds = debtApplieIds.subList(0, size);
//                }
//            }
//            model.addAttribute("code", 0);
//            model.addAttribute("next", next);
//            model.addAttribute("debtApplys", debtApplys);
//            model.addAttribute("id_supposeRepay", id_supposeRepay);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("et user debt list error, uid is  " + uid);
//            model.addAttribute("code", -1);
//        }
//        return "/wealth-finance-service/debt/json/repayDebtList";
//    }
//
//    //38、逾期借款列表
//    @RequestMapping(value = "/a/u/over/time/debt/list", method = RequestMethod.GET)
//    public String getOverTimeRepay(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
//        HashMap<Long, BigDecimal> id_totalRepay = new HashMap<>();
//        HashMap<Long, BigDecimal> id_dayCount = new HashMap<>();
//        HashMap<Long, BigDecimal> id_overRepay = new HashMap<>();
//        BigDecimal dayCount = new BigDecimal("0");
//        BigDecimal overRepay = new BigDecimal("0");
//        BigDecimal totalRepay = new BigDecimal("0");
//        BigDecimal debtCount = new BigDecimal("0");
//        BigDecimal overRate = new BigDecimal("0");
//        BigDecimal repayLine = new BigDecimal("0");
//        BigDecimal rate = new BigDecimal("0");
//        Long debtStart = 0L;
//        Long time = 0L;
//        if (null == page) {
//            page = 1;
//        }
//        if (null == size) {
//            size = 10;
//        }
//        int firstNmuber = (page - 1) * size;
//        Boolean next = false;
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("get user : " + uid + " debt list ");
//        User user = userService.getObjectById(uid);
//
//        try {
//            List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_OVERTIME, firstNmuber, size);
//            List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
//            debtLog.info("get debt over time data is " + debtApplys.size());
//
//            for (DebtApply debtApply : debtApplys) {
//                //借款本金、利率
//                debtCount = debtApply.getDebtCount();
//                overRate = debtApply.getOverRate();
//                rate = debtApply.getRate();
//
//                //获取总借款利息
//                repayLine = new BigDecimal(debtApply.getRepayLine());
//                totalRepay = caculate(debtCount, rate, repayLine).add(debtCount);
//                id_totalRepay.put(debtApply.getId(), totalRepay);
//
//                //获取当前逾期时间
//                debtStart = MyTimeUtil.getDateZeroTimeMillions(debtApply.getCreateAt()).getTime();
//                time = System.currentTimeMillis() - debtStart;
//                dayCount = new BigDecimal(ceil(time / DebtConstant.DAILY_TIME)).subtract(repayLine);
//                id_dayCount.put(debtApply.getId(), dayCount);
//
//                //获取当前罚息
//                overRepay = caculate(totalRepay, overRate, dayCount);
//                id_overRepay.put(debtApply.getId(), overRepay);
//            }
//            debtLog.info("   total = " + debtApplieIds.size());
//            Integer totalPage = (((debtApplieIds.size() - 1)) / size) + 1;
//            debtLog.info("   totalPage = " + totalPage);
//            if (debtApplieIds != null && debtApplieIds.size() > 0) {
//                if (size.equals(debtApplieIds.size())) {
//                    next = true;
//                    debtApplieIds = debtApplieIds.subList(0, size);
//                }
//            }
//            model.addAttribute("code", 0);
//            model.addAttribute("next", next);
//            model.addAttribute("debtApplys", debtApplys);
//            model.addAttribute("id_totalRepay", id_totalRepay);
//            model.addAttribute("id_dayCount", id_dayCount);
//            model.addAttribute("id_overRepay", id_overRepay);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("et user debt list error, uid is  " + uid);
//            model.addAttribute("code", -1);
//        }
//        return "/wealth-finance-service/debt/json/overTimeRepayDebtList";
//    }
//
//    //39、还清借款列表
//    @RequestMapping(value = "/a/u/clear/debt/list", method = RequestMethod.GET)
//    public String getClearRepay(HttpServletRequest request, HttpServletResponse response, ModelMap model, Integer page, Integer size) throws Exception {
//
//        if (null == page) {
//            page = 1;
//        }
//        if (null == size) {
//            size = 10;
//        }
//        int firstNmuber = (page - 1) * size;
//        Boolean next = false;
//
//        Long uid = cookieUtil.getID(request);
//        debtLog.info("get user : " + uid + " debt list ");
//        User user = userService.getObjectById(uid);
//
//        try {
//            List<Long> debtApplieIds = debtApplyService.getDebtApplyIdsByUidAndType(uid, DebtApply.TYPE_CLEAR, firstNmuber, size);
//            List<DebtApply> debtApplys = debtApplyService.getObjectsByIds(debtApplieIds);
//            debtLog.info("get debt clear data is " + debtApplys.size());
//
//            debtLog.info("   total = " + debtApplieIds.size());
//            Integer totalPage = (((debtApplieIds.size() - 1)) / size) + 1;
//            debtLog.info("   totalPage = " + totalPage);
//
//            if (debtApplieIds != null && debtApplieIds.size() > 0) {
//                if (size.equals(debtApplieIds.size())) {
//                    next = true;
//                    debtApplieIds = debtApplieIds.subList(0, size);
//                }
//            }
//            model.addAttribute("code", 0);
//            model.addAttribute("next", next);
//            model.addAttribute("debtApplys", debtApplys);
//        } catch (Throwable t) {
//            t.printStackTrace();
//            debtLog.error(t.getMessage());
//            debtLog.error("et user debt list error, uid is  " + uid);
//            model.addAttribute("code", -1);
//        }
//        return "/wealth-finance-service/debt/json/clearDebtList";
//    }
//
//    //计算利息
//    public BigDecimal caculate(BigDecimal debtCount, BigDecimal rate, BigDecimal day) {
//        debtLog.info("caculate : debtCount = " + debtCount + " rate = " + rate + " day = " + day);
//        BigDecimal result = debtCount.multiply(day).multiply(rate).divide(DebtConstant.HUNDRED, 3, BigDecimal.ROUND_HALF_UP).divide(DebtConstant.YEAR, 3, BigDecimal.ROUND_HALF_UP);
//        return result;
//    }
//
//    //清还借款，保存信息
//    public DebtApply updateDebtApply(DebtApply debtApply, BigDecimal overRepay, BigDecimal lx, BigDecimal totalMoney, BigDecimal dayCount) throws Exception{
//        debtLog.info("update DebtApply : debtApply = " + debtApply + " overRepay = " + overRepay + " lx = " + lx + " totalMoney = " + totalMoney + " dayCount = " + dayCount);
//
//        debtApply.setType(DebtApply.TYPE_CLEAR);
//        debtApply.setStatus(DebtApply.STATUS_CLEAR);
//        debtApply.setClearOverInte(overRepay);
//        debtApply.setClearInte(lx);
//        debtApply.setRepayTot(totalMoney);
//        debtApply.setOverDayCount(dayCount);
//        debtApply.setClearAt(System.currentTimeMillis());
//
//        Fund fund = fundService.getObjectById(debtApply.getUid());
//        BigDecimal loanNowTot = fund.getLoanNowTot();
//        fund.setLoanNowTot(fund.getLoanNowTot().subtract(debtApply.getDebtCount()));
//        fundService.update(fund);
//        debtLog.info("loanNowTot : " + loanNowTot + " >>>>>>>>>> " + fund.getLoanNowTot());
//
//        return debtApply;
//    }
//}
//
