package com.ptteng.wealth.finance.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.BaseController;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.Bank;
import com.ptteng.wealth.finance.service.BankService;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.model.work.CardModel;
import com.ptteng.wealth.user.service.PersonService;
import com.ptteng.wealth.user.service.UserOpenidRelationService;
import com.ptteng.wealth.user.service.UserService;
import com.ptteng.wealth.user.util.Constant;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import com.ptteng.wealth.finance.model.ProExt;
import com.ptteng.wealth.finance.service.ProExtService;

/**
 * ProExt  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class CardController extends BaseController {
    private static final Log log = LogFactory.getLog(CardController.class);

    private static final Log register_open_log = LogFactory.getLog("user_open_log");


    @Autowired
    public BankService bankService;

    /**
     */
    //用户银行卡列表
    @RequestMapping(value = "/a/u/card/list", method = RequestMethod.GET)
    public String getUserCardList(HttpServletRequest request, ModelMap model, @RequestParam(required = false, defaultValue = "1") Integer pageNo,
                                  @RequestParam(required = false, defaultValue = "10") Integer pageSize) throws Exception {

        Long uid = cookieUtil.getID(request);
        log.info("user " + uid + " card list");
        User user = userService.getObjectById(uid);
        List<BindingBank> resultBindingLs = new ArrayList<BindingBank>();
        try {
            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setUserId(user.getId().toString());
            bindingBankIn.setFundAccount(user.getFundAccount());
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank : bindingBanks) {
                if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                    continue;
                }
                resultBindingLs.add(bindingBank);
                log.info("Binding : " + bindingBank);
            }
            model.addAttribute("code", 0);
            model.addAttribute("bindingBanks", resultBindingLs);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get person " + uid + " card list error");
            model.addAttribute("code", -100000);
        }
        return "/wealth-user-service/user/json/userCardList";
    }


    //用户银行卡解绑
        @RequestMapping(value = "/a/u/card", method = RequestMethod.DELETE)
    public String deleteUserCard(HttpServletRequest request, HttpServletResponse response, ModelMap model, String payPwd, String bank, String bankNo) throws Exception {

        Long uid = cookieUtil.getID(request);
        log.info("delete card : bank : " + bank + " bankNo : " + bankNo + " payPwd : " + payPwd);
        User user = userService.getObjectById(uid);
        log.info(" user = " + user);
        int code = 0;
        try {
            Person person = personService.getObjectById(uid);
            log.info(" person = " + person);
            int totalCardCnt = 0;
            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setUserId(user.getId().toString());
            bindingBankIn.setFundAccount(user.getFundAccount());
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            boolean isMainCard = false; //判断解绑的卡是否是主卡
            for (BindingBank bindingBank : bindingBanks) {
                if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                    continue;
                }
                totalCardCnt++;
                if (bindingBank.getBankNo().equals(bankNo) && bindingBank.getBankAccount().equals(bank) && bindingBank.getMainFlag().equals("1")) {
                    isMainCard = true;
                }
            }
            if (1 == totalCardCnt) {
                code = -2030; //用户最少需要有一张卡
            } else {
                CancelCardIn cancelCardIn = new CancelCardIn(payPwd, person.getName(), "0", person.getIdNo(), bank, bankNo);
                cancelCardIn.setUserId(uid.toString());
                cancelCardIn.setFundAccount(user.getFundAccount());
                cancelCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                CancelCardOut cancelCardout = consignmentService.cancelCard(cancelCardIn);
                //如果解绑的卡是主卡，随机选择一张主卡，将其设置为主卡，并解绑本卡
                code = cancelCardout.getErrorNo();
                if (code == 0) {
                    if (isMainCard) {
                        BindingBank newMainCard = null;
                        for (BindingBank bindingBank : bindingBanks) {
                            if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT") || bindingBank.getBankNo().equals(bankNo)) {
                                continue;
                            }
                            newMainCard = bindingBank;
                            break;
                        }
                        if (null != newMainCard) {
                            MainCardIn mainCardIn = new MainCardIn();
                            mainCardIn.setUserId(uid.toString());
                            mainCardIn.setFundAccount(user.getFundAccount());
                            mainCardIn.setPassword(user.getPayPwd());
                            mainCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                            mainCardIn.setMainFlag("1");
                            mainCardIn.setBankNo(newMainCard.getBankNo());
                            mainCardIn.setBankAccount(newMainCard.getBankAccount());
                            log.info("mainCardIn : " + mainCardIn);
                            MainCardOut mainCardOut = consignmentService.setMainCard(mainCardIn);
                            log.info("mainCardOut : " + mainCardOut);
                            code = mainCardOut.getErrorNo();
                        }
                    }
                }
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get person " + uid + " card list error");
            code = -1;
        }
        model.addAttribute("code", code);
        return "/wealth-finance-service/card/json/deleteCard";
    }

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    //改设主卡
    @RequestMapping(value = "/a/u/main/card", method = RequestMethod.PUT)
    public String changeMainCard(HttpServletRequest request, HttpServletResponse response, ModelMap model, String mainFlag,
                                 String bank, String bankNo) throws Exception {

        Long uid = cookieUtil.getID(request);
        log.info("get change person " + uid + " master card : " + bank + " : " + bankNo);
        User user = userService.getObjectById(uid);

        try {
            Person person = personService.getObjectById(uid);
            log.info("person is : " + person);
            MainCardIn mainCardIn = new MainCardIn();
            mainCardIn.setUserId(uid.toString());
            mainCardIn.setFundAccount(user.getFundAccount());
            mainCardIn.setPassword(user.getPayPwd());
            mainCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
            mainCardIn.setMainFlag(mainFlag);
            mainCardIn.setBankNo(bank);
            mainCardIn.setBankAccount(bankNo);
            log.info("mainCardIn : " + mainCardIn);
            MainCardOut mainCardOut = consignmentService.setMainCard(mainCardIn);
            log.info("mainCardOut : " + mainCardOut);
            model.addAttribute("code", 0);
            model.addAttribute("mainCardOut", mainCardOut);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get person " + uid + " card list error");
            // for test
            model.addAttribute("code", -100000);
        }
        return "/common/success";
    }


    //28、个人用户开户绑卡
    @RequestMapping(value = "/a/u/person/openAccount")
    public String orgApply(HttpServletRequest request, ModelMap model, @RequestBody CardModel cardModel) throws Exception {
        register_open_log.info("\n\n ========================================================");
        register_open_log.info(" S1:  MODEL:   " + cardModel);
        int code = 0;
        try {
            Long uid = cookieUtil.getID(request);
            register_open_log.info(" S2:  USERID:   " + cardModel);
            if (null != uid) {
                User user = userService.getObjectById(uid);
                if (null != user) {
                    //判断登陆密码和支付密码是否相同
                    register_open_log.info(" password :" + user.getPwd() + " pay password: " + cardModel.getPassword());
                    if (user.getPwd().equals(PasswordUtils.encode(cardModel.getPassword()))) {
                        register_open_log.info(" PASSWORD and PAY  PASSWORD equals   END ============");
                        code = -2018;
                    } else {
                        // 第一步： 判断用户是否已经开户，没有开户则开户
                        Person person = personService.getObjectById(user.getId());
                        register_open_log.info(" S3: PERSON id: " + person.getId());
                        if (null == user.getFundAccount() || 0 == user.getFundAccount()) {
                            try {
                                OpenAccountOut openAccountOut = getOpenAccountOut(cardModel, user);
                                register_open_log.info(" S4 : USER OPENAccount: " + openAccountOut);
                                if (0 == openAccountOut.getErrorNo()) {
                                    user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                                    user.setFundAccount(openAccountOut.getFundAccount());
                                    user.setName(cardModel.getClientName());
                                    userService.update(user);
                                    person = updatePerson(cardModel, person);
                                } else {
                                    code = openAccountOut.getErrorNo();
                                }
                            } catch (Exception e) {
                                e.printStackTrace(System.err);
                                register_open_log.info(e.getMessage());
                                code = -1;
                            }
                            if (code != 0) {
                                register_open_log.info(" S5 : USER OPENAccount FAIL ===============");
                                model.addAttribute("code", code);
                                return "/common/success";
                            }
                        }
                        //兼容第二次绑卡的逻辑处理
                        register_open_log.info("S5: OpenAccount Success  ============");
                        if (StringUtil.isNotEmpty(person.getIdNo()) && !person.getIdNo().equals(cardModel.getIdNo())) {
                            register_open_log.info("身份证信息不一致");
                            model.addAttribute("code", -2027);
                            return "/common/success";
                        }
                        register_open_log.info("S6: CHECK  Binding Card ======");
                        try {
                            BindingBankIn bindingBankIn = new BindingBankIn();
                            bindingBankIn.setFunctionId(9534);
                            bindingBankIn.setUserId(user.getId().toString());
                            bindingBankIn.setFundAccount(user.getFundAccount());
                            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
                            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
                            for (BindingBank bindingBank : bindingBanks) {
                                //同一个银行只能绑定一张银行卡
                                if (bindingBank.getBankNo().equals(cardModel.getBankNo())) {
                                    model.addAttribute("code", -2029);
                                    register_open_log.error("S7: PERSON" + uid + " CARD NO " + bindingBank.getBankNo() + " HAS been BINDED");
                                    return "/common/success";
                                }
                            }
                        } catch (Throwable t) {
                            t.printStackTrace(System.err);
                            register_open_log.error(t.getMessage());
                            register_open_log.error("S7: get person " + uid + " card list error");
                            model.addAttribute("code", -1);
                            return "/common/success";
                        }
                        register_open_log.info("S4: BEGIN  Binding Card ======");
                        try {
                            //第四步： 绑卡
                            CardBindingOut cardBindingOut = getCardBindingOut(cardModel, user, person);
                            register_open_log.info("S8 card binding result : " + cardBindingOut);
                            if (0 == cardBindingOut.getErrorNo()) {
                                register_open_log.info("S8  set user card binding status : 1");
                                user.setCardStatus(User.CARD_HAVE);
                                user.setVerifyStatus(User.VERIFY_YES);  //绑卡以后才能执行上账操作
                                user.setPayPwd(cardModel.getPassword());  //绑卡成功以后才会有交易密码
                                userService.update(user);
                                //第一次绑卡的时候设定用户身份证号
                                if(StringUtil.isEmpty(person.getIdNo())){
                                    person.setIdNo(cardModel.getIdNo());
                                    personService.update(person);
                                }
                                boolean hasMainCard = hasMainCard(user);  //判断是否已经绑定了主卡
                                //没有主卡的情况下，默认将绑定的卡设置为主卡
                                if (!hasMainCard) {
                                    MainCardOut mainCardOut = bindMainCard(cardModel, user);
                                    register_open_log.info("S9  BIND MAIN CARD : " + mainCardOut);
                                }

                            } else {
                                code = cardBindingOut.getErrorNo();
                            }

                        } catch (Exception e) {
                            e.printStackTrace(System.err);
                            code = -1;
                            register_open_log.info(e.getMessage());
                        }
                        register_open_log.info("S4: END  Binding Card ======");
                    }
                } else {
                    register_open_log.info(" user  is null ==============");
                    code = -2005;
                }
            } else {
                register_open_log.info(" USERID  is null  ===============");
                code = -2005;
            }

        } catch (Exception e) {
            register_open_log.error("get captchaVerify error", e);
            code = -1;
        }
        model.addAttribute("code", code);
        return "/common/success";
    }

    /**
     * 重要逻辑： 只有绑卡成功才会绑定用户身份证号
     */
    private Person updatePerson(@RequestBody CardModel cardModel, Person person) throws ServiceException, ServiceDaoException {
        if (null != person) {
            person.setName(cardModel.getClientName());
            personService.update(person);
        } else {
            person = new Person();
            person.setName(cardModel.getClientName());
            personService.insert(person);
        }
        return person;
    }

    private OpenAccountOut getOpenAccountOut(@RequestBody CardModel cardModel, User user) throws Exception {
        OpenAccountIn openAccountIn = new OpenAccountIn();
        openAccountIn.setFunctionId(FunctionConstants.OPENAccount);
        openAccountIn.setUserId(user.getId() + "");
        openAccountIn.setMobiletelephone(user.getMobile());
        openAccountIn.setPassword(cardModel.getPassword());    //交易密码
//                                openAccountIn.setCityNo(cardModel.getCityNo());
//                                openAccountIn.setProvinceNo(cardModel.getProvinceNo());
        openAccountIn.setClientName(cardModel.getClientName());
        openAccountIn.setIdNo(cardModel.getIdNo());   //身份证号
        openAccountIn.setIdKind("0");  //0 表示身份证
        openAccountIn.setClientName(cardModel.getClientName());
        openAccountIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        openAccountIn.setActionIn(0);
        return consignmentService.openAccount(openAccountIn);
    }

    private CardBindingOut getCardBindingOut(@RequestBody CardModel cardModel, User user, Person person) throws Exception {
        CardBindingIn cardBindingIn = new CardBindingIn();
        cardBindingIn.setFunctionId(FunctionConstants.cardBinding);
        cardBindingIn.setIdNo(cardModel.getIdNo());
        cardBindingIn.setClientName(person.getName());
        cardBindingIn.setBankAccount(cardModel.getBankAccount());
        cardBindingIn.setBankNo(cardModel.getBankNo());
        cardBindingIn.setPassword(cardModel.getPassword());
        cardBindingIn.setFundAccount(user.getFundAccount());
        cardBindingIn.setBranchNo(GlobalConstant.BRANCH_NO);
        cardBindingIn.setUseType(GlobalConstant.USER_TYPE);
//                            cardBindingIn.setProvinceNo(cardModel.getProvinceNo());
//                            cardBindingIn.setCityNo(cardModel.getCityNo());
        cardBindingIn.setPhoneNo(user.getMobile());
        cardBindingIn.setActionIn(0);
        cardBindingIn.setIdKind(0 + "");
        cardBindingIn.setIdentifyingCode(cardModel.getIdentifyingCode());
        cardBindingIn.setUserId(user.getId() + "");
        cardBindingIn.setTiedCardType(GlobalConstant.TIEDCARDTYPE);
        cardBindingIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        return consignmentService.cardBinding(cardBindingIn);
    }

    private MainCardOut bindMainCard(@RequestBody CardModel cardModel, User user) throws Exception {
        MainCardIn mainCardIn = new MainCardIn();
        mainCardIn.setUserId(user.getId() + "");
        mainCardIn.setFundAccount(user.getFundAccount());
        mainCardIn.setPassword(user.getPayPwd());
        mainCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        mainCardIn.setMainFlag("1");
        mainCardIn.setBankNo(cardModel.getBankNo());
        mainCardIn.setBankAccount(cardModel.getBankAccount());
        log.info("mainCardIn : " + mainCardIn);
        MainCardOut mainCardOut = consignmentService.setMainCard(mainCardIn);
        return mainCardOut;
    }

    private boolean hasMainCard(User user) throws Exception {
        boolean hasMainCard = false;
        BindingBankIn bindingBankIn = new BindingBankIn();
        bindingBankIn.setUserId(user.getId().toString());
        bindingBankIn.setFundAccount(user.getFundAccount());
        bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
        List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
        for (BindingBank bindingBank : bindingBanks) {
            if (bindingBank.getBankNo().equals("JHB") || bindingBank.getBankNo().equals("XJY") || bindingBank.getBankNo().equals("ZLRT")) {
                continue;
            }
            register_open_log.info("BANK : " + bindingBank.getBankNo() + " BANK Account: " + bindingBank.getBankAccount() + " MainFlag: " + bindingBank.getMainFlag());
            if (bindingBank.getMainFlag().equals("1")) {
                hasMainCard = true;
            }
        }
        register_open_log.info("USER : " + user.getId() + " HAS  MAIN CARD:  " + hasMainCard);
        return hasMainCard;
    }


    //银行卡限额
    @RequestMapping(value = "/a/u/bank/detail", method = RequestMethod.GET)
    public String getBankQuota(HttpServletRequest request, ModelMap model, String bankCode) throws Exception {

        Long uid = cookieUtil.getID(request);
        log.info("user " + uid + " get bank detail");
        User user = userService.getObjectById(uid);

        if(DataUtils.isNullOrEmpty(bankCode)){
            log.info("params is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {

            Long bid = bankService.getBankIdByCode(bankCode);
            Bank bank = bankService.getObjectById(bid);
            if(bank == null){
                log.info("bank not exist");
                model.addAttribute("code", -3039);
                return "/common/success";
            }else {
                log.info("bank : " + bank);
            }

            model.addAttribute("code", 0);
            model.addAttribute("bank", bank);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get " + uid + " bank detail error");
            model.addAttribute("code", -100000);
        }
        return "/wealth-finance-service/bank/json/bankDetailJson";
    }

}

