package com.ptteng.wealth;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.PasswordUtils;
import com.ptteng.wealth.admin.service.ConstantService;
import com.ptteng.wealth.common.service.SmsService;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.service.*;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.OrgApply;
import com.ptteng.wealth.user.model.PersonApply;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.service.*;
import com.ptteng.wealth.user.util.Constant;
import com.ptteng.wealth.util.*;
import com.qding.common.util.http.cookie.CookieUtil;
import com.qding.common.util.http.cookie.UserCryptUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.ser.StdSerializerProvider;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.*;

public abstract class BaseController {
    public static final String WriterKey = "writer";
    public static final String UserKey = "user";
    public static final String Img_Module_Common = "common";
    public static final String USER_ID = "userId";
    private static final byte[] x = new byte[]{0x01};
    public static final String SPLITER_X = new String(x);
    public static Long adminUserId = null;
    public static String SPLITTER_REGEX = "\\|";
    private static ThreadLocal<ObjectMapper> templateThreadLocal = new ThreadLocal<ObjectMapper>();
    @Autowired
    public ProductService productService;

    @Autowired
    public ConsignmentService consignmentService;

    @Autowired
    public UserOpenidRelationService userOpenidRelationService;


    @Autowired
    public SmsService smsService;

    @Autowired
    public OrganizationService organizationService;

    @Autowired
    public OrgApplyService orgApplyService;

    @Autowired
    public PersonApplyService personApplyService;

    @Autowired
    public CookieUtil cookieUtil;

    @Autowired
    public PersonService personService;

    @Autowired
    public UserService userService;

    @Autowired
    public AccountService accountService;

    @Autowired
    public Environment environment;

    @Autowired
    public OrderService orderService;
    @Autowired
    public UserAccountRelationService userAccountRelationService;

    @Autowired
    public LoanProductService loanProductService;

    @Autowired
    public LoanApplyService loanApplyService;

    @Autowired
    public ConstantService constantService;


    @Autowired
    public FundService fundService;

    @Autowired
    public DebtApplyService debtApplyService;




    protected Log log = LogFactory.getLog(this.getClass());

    public static ObjectMapper getJsonCallBackTemplate() {
        if (templateThreadLocal.get() == null) {
            ObjectMapper objmap = new ObjectMapper();
            // First: need a custom serializer provider
            StdSerializerProvider sp = new StdSerializerProvider();
            sp.setNullValueSerializer(new EmptySerializer());
            objmap.setSerializerProvider(sp);
            templateThreadLocal.set(objmap);
            return objmap;
        } else {
            return templateThreadLocal.get();
        }
    }

    public static Map getUserIdentity(String userName, Long userId) {
        Map map = new HashMap();
        map.put(CookieUtil.USER_NAME, userName);
        map.put(CookieUtil.USER_ID, userId);
        return map;
    }

    public Map<String, Object> checkAndGetWriter(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> infoMap = null;
        PrintWriter writer = null;
        HashMap<String, String> errorMap = new HashMap<String, String>();
        try {
            writer = response.getWriter();
        } catch (IOException e) {
            e.printStackTrace(System.out);  //To change body of catch statement use File | Settings | File Templates.
        }
        if (null == writer) {
            errorMap.put(ResultPropertyes.ERROR_CODE, ErrCode.ERROR_NULL_RESULT);
            errorMap.put(ResultPropertyes.ERROR_INFO, ErrCode.ERROR_NULL_RESULT_INFO);
            writeConent(writer, response, false, 500, null, null, null, errorMap);
            return null;
        }
        infoMap = new HashMap<String, Object>();
        infoMap.put(WriterKey, writer);
        return infoMap;
    }

    public String handleResult(Boolean bSucess, int statusCode, PrintWriter writer, HttpServletResponse httpServletResponse) {
        return handleResult(writer, httpServletResponse, bSucess, statusCode, null, null, null);
    }

    public String handleResult(PrintWriter writer, HttpServletResponse httpServletResponse, boolean bSuccess, int statusCode, Map<String, String> stringInfoMap, Map<String, Long> numberInfoMap, Map<String, Object> objInfoMap) {
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (!bSuccess) {
            errorMap.put(ResultPropertyes.ERROR_CODE, ErrCode.ERROR_BY_DB);
            errorMap.put(ResultPropertyes.ERROR_INFO, ErrCode.ERROR_BY_DB_INFO);
        }
        return writeConent(writer, httpServletResponse, bSuccess, statusCode, stringInfoMap, numberInfoMap, objInfoMap, errorMap);
    }

    public String writeConent(PrintWriter writer, HttpServletResponse httpServletResponse, boolean bSuccess, int statusCode, Map<String, String> stringInfoMap, Map<String, Long> numberInfoMap, Map<String, Object> objInfoMap, Map<String, String> errorMap) {
        JsonGenerator generator = null;
        try {
            httpServletResponse.setStatus(statusCode);
            httpServletResponse.setContentType("text/html;charset=utf-8");
            JsonFactory factory = new JsonFactory();
            generator = factory.createJsonGenerator(writer);
            ObjectMapper objmap = getJsonCallBackTemplate(); //get from localthread
            SerializationConfig serializationConfig = objmap.getSerializationConfig();
            generator.setCodec(objmap);
            generator.writeStartObject();

            if (bSuccess) {
                switch (statusCode) {
                    case HttpServletResponse.SC_NO_CONTENT:
                        break;
                    case HttpServletResponse.SC_CREATED:
                    case HttpServletResponse.SC_OK:
                        if (null != stringInfoMap) {
                            Iterator<String> strIter = stringInfoMap.keySet().iterator();
                            while (strIter.hasNext()) {
                                String key = strIter.next();
                                generator.writeStringField(key, ObjectUtils.toString(stringInfoMap.get(key), ""));
                            }
                        }
                        if (null != numberInfoMap) {
                            Iterator<String> numIter = numberInfoMap.keySet().iterator();
                            while (numIter.hasNext()) {
                                String key = numIter.next();
                                generator.writeNumberField(key, numberInfoMap.get(key));
                            }
                        }
                        if (null != objInfoMap) {
                            Iterator<String> objIter = objInfoMap.keySet().iterator();
                            while (objIter.hasNext()) {
                                String key = objIter.next();
                                generator.writeObjectField(key, objInfoMap.get(key));
                            }
                        }
                        break;
                }
            } else {
                generator.writeStringField(ResultPropertyes.ERROR_CODE, (String) errorMap.get(ResultPropertyes.ERROR_CODE));
                generator.writeStringField(ResultPropertyes.ERROR_INFO, (String) errorMap.get(ResultPropertyes.ERROR_INFO));
            }

            generator.writeEndObject();
            generator.close();
        } catch (IOException e) {
            e.printStackTrace(System.out);
        }
        return null;
    }

    public Long getUserId(HttpServletRequest request) {
        Long uid = cookieUtil.getID(request);
        return uid;
    }

    public User getUser(HttpServletRequest request) {
        User user = null;
        Long userId = getUserId(request);
        try {
            if (null != userId) {
                user = userService.getObjectById(userId);
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return user;
    }

    private Map decodeCookie(String value) {
        if (org.apache.commons.lang.StringUtils.isBlank(value))
            return null;
        try {
            String[] p = value.split(SPLITTER_REGEX);
            Long userId = new Long(p[0]);
            String crypt = p[1];
            String plainUserInfo = UserCryptUtil.userDecrypt(crypt);
            String userName = UserCryptUtil.getUserNameFromPlain(plainUserInfo);
            Long uid = UserCryptUtil.getUserIdFromPlain(plainUserInfo);
            if (userId.equals(uid)) {
                return getUserIdentity(userName, userId);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("Wrong cookie format: [" + value + "] message is:" + e.getMessage());
            return null;
        }
        return null;
    }

    public String getErrorCode(Long errorId) {
        String errorCode = "";
        return errorCode;
    }

    public String getErrorInfo(Long errorId) {
        String errorCode = "";
        return errorCode;
    }

    /**
     * 机构用户注册时，更新机构申请表
     *
     * @param orgApply
     * @param oldOrgApplyId
     * @param oldOrgApply
     * @param orgLog
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void updateOrgApplyInfo(OrgApply orgApply, Long oldOrgApplyId, OrgApply oldOrgApply, Log orgLog) throws ServiceException, ServiceDaoException {
        if ((OrgApply.STATUS_3).equals(oldOrgApply.getStatus())) {
            orgLog.info(orgApply.getMobile() + " already fail apply " + oldOrgApplyId);
            orgApply.setStatus(PersonApply.STATUS_1);
            orgApply.setId(oldOrgApplyId);
            orgApply.setUpdateAt(System.currentTimeMillis());
            this.orgApplyService.update(orgApply);

        } else if ((OrgApply.STATUS_2).equals(oldOrgApply.getStatus())) {
            orgLog.info(orgApply.getMobile() + " already success " + oldOrgApplyId);
        } else if ((OrgApply.STATUS_1).equals(oldOrgApply.getStatus())) {
            orgLog.info(orgApply.getMobile() + " waiting apply,so can update  " + oldOrgApplyId);
            orgApply.setId(oldOrgApplyId);
            orgApply.setUpdateAt(System.currentTimeMillis());
            orgApplyService.update(orgApply);
        } else {
            orgLog.info(orgApply.getMobile() + " other status " + oldOrgApplyId);
            orgApply.setId(oldOrgApplyId);
            orgApply.setUpdateAt(System.currentTimeMillis());
            orgApplyService.update(orgApply);
        }
        orgLog.error("SUCCESS: mobile: " + orgApply.getMobile() + "  update db info");
        orgLog.info("===================================================================================================");
    }


    /**
     * 机构用户注册时创建用户账号
     *
     * @param orgApply
     * @param userId
     * @param orgLog
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public User createUserInfo(OrgApply orgApply, Long userId, String name, Log orgLog,String kailinCode,boolean fromCRM) throws ServiceException, ServiceDaoException {
        User user = userService.getObjectById(userId);
        if(null == user){
            user = new User();
            user.setMobile(orgApply.getMobile());
            user.setType(User.TYPE_ORG);
            user.setPwd(PasswordUtils.encode(orgApply.getPassword()));
            user.setAccStatus(Constant.NO_OPEN_ACCOUNT);
            user.setName(name);
            user.setVerifyStatus(User.VERIFY_NO);
            user.setPayPwd(orgApply.getPayPwd());
            if(fromCRM){
                user.setKailinCode(kailinCode);
                user.setStatus(User.USER_UNACTIVIATE);
            }
            userId = userService.insert(user);
            user.setId(userId);
            orgLog.info("saved userid: " + userId);
        }

        Long uoId2 = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(orgApply.getMobile(), UserOpenidRelation.Type_Org_Mobile);
        if (null != uoId2) {
            UserOpenidRelation userOpenidRelation2 = userOpenidRelationService.getObjectById(uoId2);
            userOpenidRelation2.setTypeId(userId);
            Boolean update = userOpenidRelationService.update(userOpenidRelation2);
            orgLog.info(" update org_code relation: id " + userOpenidRelation2 + " result: " + update);
        } else {
            UserOpenidRelation userOpenidRelation = new UserOpenidRelation();
            userOpenidRelation.setTypeId(userId);
            userOpenidRelation.setOpenId(orgApply.getMobile());
            userOpenidRelation.setStatus(UserOpenidRelation.Type_Org_Mobile);
            uoId2 = userOpenidRelationService.insert(userOpenidRelation);
            orgLog.info(" insert org_code relation: openid  " + uoId2);
        }

        orgLog.info(" orgApply crm start ... ");
        return user;
    }


}