package com.ptteng.wealth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

import com.ptteng.wealth.admin.model.Article;
import com.ptteng.wealth.admin.service.ArticleService;
import com.ptteng.wealth.finance.service.OrderService;

/**
 * Article  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class ArticleController {
    private static final Log log = LogFactory.getLog("article");

    private final String Img_Module_Common = "common";
    @Autowired
    private ArticleService articleService;
    @Autowired
    private OrderService orderService;


    @Autowired
    private com.qding.common.util.http.cookie.CookieUtil cookieUtil;


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */

//	@RequestMapping(value = "/index", method = RequestMethod.GET)
//	public String index(HttpServletRequest request,
//						HttpServletResponse response, ModelMap model) throws Exception {
//
//		log.info("welcome !");
//		List<Article> articleList1 =  this.getArticleListByType(0,3,3);
//
//		log.info("list1 :"+articleList1);
//
//		model.addAttribute("articleList1", articleList1);
//
//
//		model.addAttribute("index", "active");
//		return "/web/index";
//
//
//	}




	/**
	 * 查询所有内容
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/article/{type}/list/", method = RequestMethod.GET)
	public String getArticleIdsJsonList(HttpServletRequest request,
											HttpServletResponse response, ModelMap model, Integer page,
											Integer size,@PathVariable Integer type) throws Exception {
        log.info(" type = "+type);

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

            List<Long> ids= articleService.getArticleIdsByTypeAndStatus(type, Article.Status_Published,start,size);


			log.info("get countarticleIdsList size is " + ids.size());
            if(ids.size()>0){
                List<Article> articleList = articleService.getObjectsByIds(ids);

                if(articleList != null&& articleList.size()>0 ) {
                    Integer total = articleList.size();
                    log.info("get article count is " + total);
                    model.addAttribute("total", total);
                }else{

                    model.addAttribute("total", 0);
                }

                Integer totalSize = (articleService.getArticleIdsByTypeAndStatus
                        (type, Article.Status_Published, 0, Integer.MAX_VALUE)).size();
                Integer totalPage = (((totalSize - 1)) / (size)) + 1;
                model.addAttribute("totalPage", totalPage);
                model.addAttribute("articleList", articleList);
            }
            model.addAttribute("code", 0);
            model.addAttribute("type",type);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/wealth-public-service/article/json/articleListJson";
	}


    /**
     * 单个查询展示内容
     *
     * @param request
     * @param response
     * @param model
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/article/{aid}", method = RequestMethod.GET)
    public String getArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("get data : id= " + aid);
        try {
            if (aid == null) {
                model.addAttribute("code", -1004);
                return "/data/json";
            } else {

                Article article = articleService.getObjectById(aid);
                if (article == null) {
                    model.addAttribute("code", -9003);
                    return "/data/json";
                } else {
                    log.info("get article data is " + article);
                    model.addAttribute("code", 0);
                    model.addAttribute("article", article);
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get article error,id is  " + aid);
            model.addAttribute("code", -1);
        }

        return "/wealth-public-service/article/json/articleDetailJson";
    }

    /**
     * 修改内容
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.PUT)
    public String updateArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Article article, @PathVariable Long aid) throws Exception {

        log.info("update article : article= " + article);

        try {
            //	if("-1".equals(article.getStatus())){
            //	article.setStatus(-1L);//保存草稿，不发布
            //}else{
            //		article.setStatus(System.currentTimeMillis());//发布
            //	}
            if (article == null) {
                model.addAttribute("code", -1004);
                return "/data/json";
            }
            if (article.getType() == null || article.getImg() == null || article.getImg().equals("") || article.getTitle() == null || article.getTitle().equals("")
                    || article.getContent() == null || article.getContent().equals("") || article.getSummary() == null || article.getSummary().equals("")
                    ) {
                model.addAttribute("code", -1004);
                return "/data/json";
            }

            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));

            article.setUpdateBy(uid);
            articleService.update(article);

            model.addAttribute("code", 0);

            model.addAttribute("article", article);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + article.getId());
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }

    /**
     * 发布或取消内容
     *
     * @param request
     * @param response
     * @param model
     * @param status
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}/status", method = RequestMethod.PUT)
    public String updateArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Integer status, @PathVariable Long aid) throws Exception {

        log.info("update article status : article id ,status = " + aid + " , " + status);

        try {
            Article article = articleService.getObjectById(aid);
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));

            article.setUpdateBy(uid);
            log.info("article is  " + article);
            if (Article.Status_Unpublished == status) {
                article.setStatus(Article.Status_Unpublished);//取消发布
            } else {
                Long time = System.currentTimeMillis();
                article.setStatus(Article.Status_Published);//发布内容
                article.setPublishat(time);
            }


            articleService.update(article);

            model.addAttribute("code", 0);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update article error,id is  " + aid);
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }

    /**
     * 添加内容
     *
     * @param request
     * @param response
     * @param model
     * @param article
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
    public String addArticleJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Article article) throws Exception {

        log.info("update article : article= " + article);

        try {
            if (article == null) {
                model.addAttribute("code", -1004);
                return "/data/json";
            }
            if (article.getType() == null || article.getImg() == null || article.getImg().equals("") || article.getTitle() == null || article.getTitle().equals("")
                    ) {
                model.addAttribute("code", -1004);
                return "/data/json";
            }


            if (Article.Status_Unpublished == article.getStatus()) {
                article.setStatus(Article.Status_Unpublished);//保存草稿，不发布
            } else if (Article.Status_Published == article.getStatus()) {
                Long time = System.currentTimeMillis();
                article.setStatus(Article.Status_Published);//发布
                article.setPublishat(time);
            } else {
                article.setStatus(Article.Status_Unpublished);
            }
            Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                    com.qding.common.util.http.cookie.CookieUtil.USER_ID));
            article.setCreateBy(uid);
            article.setUpdateBy(uid);

            article.setId(null);

            articleService.insert(article);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add article error ");
            model.addAttribute("code", -100000);
        }

        return "/data/json";
    }

    /**
     * 删除内容
     *
     * @param request
     * @param response
     * @param model
     * @param aid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.DELETE)
    public String deleteArticleJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long aid)
            throws Exception {

        log.info("delete article : id= " + aid);
        try {
            articleService.delete(aid);

            log.info("add article success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete article error,id is  " + aid);
            model.addAttribute("code", -100000);

        }

        return "/data/json";
    }

    /**
     * 批量获取文章详细信息
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/multi/article", method = RequestMethod.GET)
    public String getMultiArticleJson(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null || ids.length <= 0) {

            model.addAttribute("code", 0);
            model.addAttribute("size", 10);
            model.addAttribute("total", 0);


        } else {
            idList = Arrays.asList(ids);
        }
        try {
            if (idList == null || idList.size() <= 0) {
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
            } else {


                List<Article> articleList = articleService.getObjectsByIds(idList);
                log.info("get  article data is " + articleList);

                if (articleList != null && articleList.size() <= 0) {
                    model.addAttribute("code", 0);
                    model.addAttribute("size", 10);
                    model.addAttribute("total", 0);

                    model.addAttribute("articleList", articleList);
                } else {

                    model.addAttribute("code", 0);
                    model.addAttribute("size", 10);
                    model.addAttribute("total", articleList.size());

                    model.addAttribute("articleList", articleList);
                }
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get article error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/admin/article/json/articleMultiJson";
    }

    /**
     * 条件查询内容
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param startAt
     * @param endAt
     * @param type
     * @param createBy
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/article/", method = RequestMethod.GET)
    public String getArticleList(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Integer page, Integer size,
                                 Long startAt, Long endAt, String type, String source, String createBy, String status)
            throws Exception {
        log.info("/web/a/article/list ,page is:" + page + ",size is" + size + ",startAt is" + startAt + ",endAt is" + endAt + ", type is " +
                "" + type + " , source is " + source + " createBy is " +
                createBy + " status is " + status);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        try {
            Boolean next = false;
            size += 1;

            List<Long> ids = new ArrayList<Long>();

            if (startAt == null && endAt == null && type == null && source == null && createBy == null && status == null) {

                ids = articleService.getArticleIds(start, size);
//			if(ids!=null && ids.size()>0){
//
//					if (size.equals(ids.size())) {
//						next = true;
//						log.info("ss  "+ids.subList(0,size-1));
//					}else{
//						log.info("ss  "+ids.subList(0,ids.size()));
//					}
//				}
            } else {
//                Map<String, Object> param = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, false);
//                log.info("        param is    " + param);
//                Map<String, Object> countparam = DynamicUtil.getListParam(startAt, endAt, type, createBy, source, status, true);
//                log.info("pageList : page= " + start + " , size=" + size);
//                ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);
//

            }


            if (ids != null && ids.size() > 0) {

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  " + ids.subList(0, size - 1));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                } else {
                    log.info("ss  " + ids.subList(0, ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
            } else {
                model.addAttribute("ids", ids);
            }

            model.addAttribute("code", 0);
            model.addAttribute("size", size - 1);
            model.addAttribute("page", page);
            model.addAttribute("next", next);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get articleList error,qfrom is" + startAt + ",qto is" + endAt + ", type is " +
                    "" + type + " , source is " + source + " createBy is " +
                    createBy + " status is " + status);
            model.addAttribute("code", -100000);
        }

        return "/admin/article/json/articleListJson";
    }

    /**
     * 根据type查找已发布内容
     *
     * @param page
     * @param size
     * @param type
     * @return
     * @throws Exception
     */
    public List<Article> getArticleListByType(Integer page, Integer size, Integer type) throws Exception {

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        List<Long> ids = articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, size);
        log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids);


        List<Article> articleList = articleService.getObjectsByIds(ids);
        log.info("get article data is " + articleList);


        return articleList;
    }
}

