package com.ptteng.wealth.finance.service.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AccountRecordService extends BaseDaoService {

	



   		   
		
		public Long insert(AccountRecord accountRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AccountRecord> insertList(List<AccountRecord> accountRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(AccountRecord accountRecord)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<AccountRecord> accountRecordList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public AccountRecord getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AccountRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAccountRecordIdsByUserIdOrderByUpdateAt(Long userId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountRecordIdsByUserIdOrderByUpdateAt(Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAccountRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAccountRecordIds() throws ServiceException, ServiceDaoException;
	

}

