package com.ptteng.wealth.finance.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.RepayHistory;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface RepayHistoryService extends BaseDaoService {

	



   		   
		
		public Long insert(RepayHistory repayHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<RepayHistory> insertList(List<RepayHistory> repayHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(RepayHistory repayHistory)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<RepayHistory> repayHistoryList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public RepayHistory getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<RepayHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countRepayHistoryIdsByName(String name)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countRepayHistoryIdsByMobile(String mobile)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getRepayHistoryIdsByName(String name, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getRepayHistoryIdsByMobile(String mobile, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getRepayHistoryIdByOrderNo(String orderNo)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getRepayHistoryIdByNumber(String number)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getRepayHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countRepayHistoryIds() throws ServiceException, ServiceDaoException;
	

}

