package com.ptteng.wealth.finance.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.finance.model.Fund;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface FundService extends BaseDaoService {


    public Long insert(Fund fund) throws ServiceException, ServiceDaoException;


    public List<Fund> insertList(List<Fund> fundList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Fund fund) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Fund> fundList) throws ServiceException, ServiceDaoException;


    public Fund getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Fund> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getFundIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countFundIds() throws ServiceException, ServiceDaoException;


}

