package com.ptteng.wealth.finance.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.wealth.finance.model.AnnualYield;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AnnualYieldService extends BaseDaoService {

	



   		   
		
		public Long insert(AnnualYield annualYield)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AnnualYield> insertList(List<AnnualYield> annualYieldList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(AnnualYield annualYield)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<AnnualYield> annualYieldList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public AnnualYield getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<AnnualYield> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAnnualYieldIdsByProductId(Long productId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAnnualYieldIdsByProductId(Long productId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAnnualYieldIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAnnualYieldIds() throws ServiceException, ServiceDaoException;
	

}

