package com.ptteng.wealth.finance.model.account;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user_account_relation")
public class UserAccountRelation implements Serializable {

    public static final Integer SWAP_SUCCESS = 0;
    public static final Integer SWAP_NO_MONEY = 1;
    //贵州开磷化肥有限责任公司
    public static final String Account_CODE_1 = "kailinhechengan";
    //贵州开磷息烽合成氨有限责任公司
    public static final String Account_CODE_2 = "huafeigongsi";
    //其他账户
    public static final String Account_CODE_3 = "otherzhanghu";
    /**
     *
     */
    private static final long serialVersionUID = 9133952851178456064L;
    private Long id;

    private Long userId;
    private Long accountId;
    private String accountCode;


    private BigDecimal money = new BigDecimal("0");


    private Long createBy;


    private Long updateBy;


    private Long updateAt;


    private Long createAt;

    private String accountName;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return userId;
    }


    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "account_id")
    public Long getAccountId() {
        return accountId;
    }


    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    @Column(name = "money")
    public BigDecimal getMoney() {
        return money;
    }


    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "account_code")
    public String getAccountCode() {
        return accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    @Transient
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

