/**
 *
 */
package com.ptteng.wealth.finance.client.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;

import java.util.List;
import java.util.Map;

public class UserAccountRelationSCAClient implements UserAccountRelationService {

    private UserAccountRelationService userAccountRelationService;

    public UserAccountRelationService getUserAccountRelationService() {
        return userAccountRelationService;
    }


    public void setUserAccountRelationService(UserAccountRelationService userAccountRelationService) {
        this.userAccountRelationService = userAccountRelationService;
    }


    @Override
    public Long insert(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.insert(userAccountRelation);


    }


    @Override
    public List<UserAccountRelation> insertList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.insertList(userAccountRelationList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.delete(id);


    }


    @Override
    public boolean update(UserAccountRelation userAccountRelation) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.update(userAccountRelation);


    }


    @Override
    public boolean updateList(List<UserAccountRelation> userAccountRelationList) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.updateList(userAccountRelationList);


    }


    @Override
    public UserAccountRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.getObjectById(id);


    }


    @Override
    public List<UserAccountRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserAccountRelationIdByUserIdAndAccountId(Long userId, Long accountId) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountId(userId, accountId);


    }

    @Override
    public Long getUserAccountRelationIdByUserIdAndAccountCode(Long userId, String accountCode) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.getUserAccountRelationIdByUserIdAndAccountCode(userId, accountCode);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserAccountRelationIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.getUserAccountRelationIdsByUserId(userId, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserAccountRelationIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {

        return userAccountRelationService.countUserAccountRelationIdsByUserId(userId);


    }


    @Override
    public List<Long> getUserAccountRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userAccountRelationService.getUserAccountRelationIds(start, limit);
    }

    @Override
    public Integer countUserAccountRelationIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return userAccountRelationService.countUserAccountRelationIds();
    }

    @Override
    public int swapMoney(Long fromId, Long toId, Double money, String serialNo, Long mid, String comments) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.swapMoney(fromId, toId, money, serialNo, mid, comments);
    }

    @Override
    public int execMoney(Long recordId, Long userId) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.execMoney(recordId, userId);
    }

    @Override
    public int addResult(Long acountid, Double amount, String serialNo, Integer mtype, Long mid, Long postLine, Integer needCheck,
                         Integer receiveCheck, String fromParty, String fromBank, String fromAt, String comment) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.addResult(acountid, amount, serialNo, mtype, mid, postLine, needCheck, receiveCheck,
                fromParty, fromBank, fromAt, comment);
    }

    @Override
    public int addExec(Long recordId, Long mid) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.addExec(recordId, mid);
    }

    @Override
    public int payOrder(Long orderId, Long userAccountId, Integer payType) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.payOrder(orderId, userAccountId,payType);
    }

    @Override
    public int payDeposit(Long userAccountId, Double paymoney,Double debtCount, Long debtApplyId, Long uid, Long orderId,Long overAt)  {
        return  userAccountRelationService.payDeposit(userAccountId, paymoney, debtCount, debtApplyId, uid, orderId,overAt);
    }

    @Override
    public int payDepositdaixiao(Double debtCount, Long debtApplyId, Long uid, Long orderId,Long overAt)  {
        return userAccountRelationService.payDepositdaixiao(debtCount, debtApplyId, uid, orderId,overAt);
    }

    @Override
    public int shexiaoKL(Long userAccountId, Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        return userAccountRelationService.shexiaoKL(userAccountId, repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
    }

    @Override
    public int shexiaoDX(Double repayTot, Double clearInte, Double clearOverInte, Double overDayCount, Long clearAt, Long loanApplyId, Long orderId, Long currenttime) {
        return userAccountRelationService.shexiaoDX(repayTot, clearInte, clearOverInte, overDayCount, clearAt, loanApplyId, orderId, currenttime);
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return this.userAccountRelationService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        return userAccountRelationService.fakeDelete(clz, id);
    }

    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        userAccountRelationService.deleteList(clz, ids);

    }

}

