/**
 *
 */
package com.ptteng.wealth.finance.client;

import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.OrderService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class OrderSCAClient implements OrderService {

    private OrderService orderService;

    public OrderService getOrderService() {
        return orderService;
    }

    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    @Override
    public Long insert(Order order) throws ServiceException, ServiceDaoException {
        return orderService.insert(order);
    }


    @Override
    public List<Order> insertList(List<Order> orderList) throws ServiceException, ServiceDaoException {
        return orderService.insertList(orderList);
    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        return orderService.delete(id);
    }


    @Override
    public boolean update(Order order) throws ServiceException, ServiceDaoException {
        return orderService.update(order);
    }


    @Override
    public boolean updateList(List<Order> orderList) throws ServiceException, ServiceDaoException {

        return orderService.updateList(orderList);


    }


    @Override
    public Order getObjectById(Long id) throws ServiceException, ServiceDaoException {
        return orderService.getObjectById(id);
    }

    @Override
    public List<Order> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        return orderService.getObjectsByIds(ids);
    }

    @Override
    public List<Long> getOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return orderService.getOrderIdsByUid(uid, start, limit);
    }

    @Override
    public Long getOrderIdByOrderNo(String orderNo) throws ServiceException, ServiceDaoException {
        return orderService.getOrderIdByOrderNo(orderNo);
    }

    @Override
    public Long getOrderIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {
        return orderService.getOrderIdByOrderNoAndAdditional(orderNo, additional);
    }


    @Override
    public List<Long> getOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return orderService.getOrderIds(start, limit);
    }

    @Override
    public Integer countOrderIds() throws ServiceException, ServiceDaoException {
        return orderService.countOrderIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        return orderService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return this.orderService.getObjectByDynamicCondition(aClass, map, integer, integer1);

    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        return orderService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        orderService.deleteList(clz, ids);

    }


}

