/**
 *
 */
package com.ptteng.wealth.finance.client;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.ptteng.wealth.finance.model.DebtApply;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.service.DebtApplyService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.wealth.user.model.User;

public class DebtApplySCAClient implements DebtApplyService {

    private DebtApplyService debtApplyService;

    public DebtApplyService getDebtApplyService() {
        return debtApplyService;
    }


    public void setDebtApplyService(DebtApplyService debtApplyService) {
        this.debtApplyService = debtApplyService;
    }


    @Override
    public Long insert(DebtApply debtApply) throws ServiceException, ServiceDaoException {

        return debtApplyService.insert(debtApply);


    }


    @Override
    public List<DebtApply> insertList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {

        return debtApplyService.insertList(debtApplyList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return debtApplyService.delete(id);


    }


    @Override
    public boolean update(DebtApply debtApply) throws ServiceException, ServiceDaoException {

        return debtApplyService.update(debtApply);


    }


    @Override
    public boolean updateList(List<DebtApply> debtApplyList) throws ServiceException, ServiceDaoException {

        return debtApplyService.updateList(debtApplyList);


    }


    @Override
    public DebtApply getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return debtApplyService.getObjectById(id);


    }


    @Override
    public List<DebtApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return debtApplyService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getDebtApplyIdByOrderNoAndAdditional(String orderNo, String additional) throws ServiceException, ServiceDaoException {

        return debtApplyService.getDebtApplyIdByOrderNoAndAdditional(orderNo, additional);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDebtApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return debtApplyService.getDebtApplyIdsByUid(uid, start, limit);


    }

    @Override
    public List<Long> getDebtApplyIdsByStatus(Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return debtApplyService.getDebtApplyIdsByStatus(status, start, limit);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getDebtApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return debtApplyService.getDebtApplyIdsByUidAndStatus(uid, status, start, limit);


    }

    @Override
    public List<Long> getDebtApplyIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return debtApplyService.getDebtApplyIdsByUidAndType(uid, type, start, limit);
    }

    @Override
    public Integer countDebtApplyIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {
        return debtApplyService.countDebtApplyIdsByUidAndType(uid, type);
    }

    @Override
    public List<DebtApply> getObjectsBySql(Class clz, String sql) throws ServiceException, ServiceDaoException {
        return debtApplyService.getObjectsBySql(clz, sql);
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDebtApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        return debtApplyService.countDebtApplyIdsByUid(uid);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countDebtApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {

        return debtApplyService.countDebtApplyIdsByUidAndStatus(uid, status);


    }


    @Override
    public List<Long> getDebtApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return debtApplyService.getDebtApplyIds(start, limit);
    }

    @Override
    public Integer countDebtApplyIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return debtApplyService.countDebtApplyIds();
    }

    @Override
    public Boolean addDebtApply(Order order, Long loanProductId, User user) throws ServiceException, ServiceDaoException {
        return debtApplyService.addDebtApply(order, loanProductId, user);
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return debtApplyService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return this.debtApplyService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return debtApplyService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        debtApplyService.deleteList(clz, ids);

    }


}

