/**
 * 
 */
package com.ptteng.wealth.finance.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.wealth.finance.model.Bank;
import com.ptteng.wealth.finance.service.BankService;

import java.util.List;
import java.util.Map;

public class BankSCAClient implements BankService {

    private BankService bankService;

	public BankService getBankService() {
		return bankService;
	}
	
	
	public void setBankService(BankService bankService) {
		this.bankService =bankService;
	}
	
	
			   
		@Override
		public Long insert(Bank bank)throws ServiceException, ServiceDaoException{
		
		return bankService.insert(bank);
		          
		
		}	
		  
    	   
		@Override
		public List<Bank> insertList(List<Bank> bankList)throws ServiceException, ServiceDaoException{
		
		return bankService.insertList(bankList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return bankService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Bank bank)throws ServiceException, ServiceDaoException{
		
		return bankService.update(bank);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Bank> bankList)throws ServiceException, ServiceDaoException{
		
		return bankService.updateList(bankList);
		          
		
		}	
		  
    	   
		@Override
		public Bank getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return bankService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Bank> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return bankService.getObjectsByIds(ids);
		          
		
		}

	@Override
	public Long getBankIdByCode(String bankCode) throws ServiceException, ServiceDaoException {
		return bankService.getBankIdByCode(bankCode);
	}


	@Override
	public List<Long> getBankIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		return bankService.getBankIds(start, limit);
	}

	@Override
	public Integer countBankIds() throws ServiceException, ServiceDaoException {
		return bankService.countBankIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		return bankService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		return bankService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   bankService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.bankService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}


 
}

