package com.ptteng.wealth.admin.controller.account;

import com.ptteng.wealth.admin.controller.BaseController;
import com.ptteng.wealth.admin.model.Manager;
import com.ptteng.wealth.admin.util.AccountRecordUtil;
import com.ptteng.wealth.admin.util.orgApplyUtil.OrgApplyUtil;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.AccountRecord;
import com.ptteng.wealth.finance.service.account.AccountRecordService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.user.model.OrgApply;
import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.OrganizationService;
import com.ptteng.wealth.user.service.UserService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by liangxj on 2016/6/27.
 */
@Controller
public class AccountRecordController extends BaseController {
    private static final Log log = LogFactory.getLog(AccountRecordController.class);


    /**
     * 查询上账记录列
     *
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/account/record/{swapstatus}", method = RequestMethod.GET)
    public String getAccountRecordList(@PathVariable Integer swapstatus, ModelMap model, Integer page,
                                                            Integer size, String mobile,
                                                            String orgName, Integer type, Long startAt, Integer status,
                                                            Long endAt) throws Exception {
        log.info(" page = " + page + " size = " + size);
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        Long total = 0l;
        log.info("pageList : page" + page + " , start= " + start + " , size=" + size);
        try {
            List<Long> ids = null;
            if (swapstatus == 1) {
                Map<String, Object> map = AccountRecordUtil.getListParam(orgName, mobile, startAt, endAt, status, type, false, true);
                ids = accountRecordService.getIdsByDynamicCondition(AccountRecord.class, map, start, size);
                map = AccountRecordUtil.getListParam(orgName, mobile, startAt, endAt, status, type, true, true);
                total = accountRecordService.getIdsByDynamicCondition(AccountRecord.class, map, 0, size).get(0);
            } else {
                Map<String, Object> map = AccountRecordUtil.getListParam(orgName, mobile, startAt, endAt, status, type, false, false);
                ids = accountRecordService.getIdsByDynamicCondition(AccountRecord.class, map, start, size);
                map = AccountRecordUtil.getListParam(orgName, mobile, startAt, endAt, status, type, true, false);
                total = accountRecordService.getIdsByDynamicCondition(AccountRecord.class, map, 0, size).get(0);
            }
            if (ids.size() > 0) {
//                if (size.equals(ids.size())) {
//                    log.info("ids size : " + ids.size());
//                    ids = ids.subList(0, size - 1);
//                }
//                List<Long> newIds = new ArrayList<>();
//                for (Long id : ids) {
//                    newIds.add(id);
//                }

                List<AccountRecord> accountList = accountRecordService.getObjectsByIds(ids);
                List<Long> managerIds = new ArrayList<Long>();
                List<Long> uids = new ArrayList<>();
                Map<Long, Integer> uid_userType = new HashMap<>();
                Map<Long, String> mobileMap = new HashMap<>();
                Map<Long, String> managerMap = new HashMap<Long, String>();
                for (AccountRecord accountRecord : accountList) {
                    managerIds.add(accountRecord.getUpdateBy());
                    uids.add(accountRecord.getUserId());
                }

                List<User> users = userService.getObjectsByIds(uids);
                for(User user : users){
                    Integer userType = user.getType();
                    uid_userType.put(user.getId(), userType);
                }

                List<Long> accountIds = accountService.getAccountIds(0, 100);
                List<Account> accounts = accountService.getObjectsByIds(accountIds);
                List<Manager> managers = managerService.getObjectsByIds(managerIds);
                for (Manager manager : managers) {
                    for (AccountRecord accountRecord : accountList) {
                        if (manager.getId().equals(accountRecord.getUpdateBy())) {
                            managerMap.put(accountRecord.getId(), manager.getNick());
                        }
                    }
                }
                for (AccountRecord accountRecord : accountList) {
                    for (Account account : accounts) {
                        if (accountRecord.getAccountCode().equals(account.getAccCode())) {
                            accountRecord.setAccountCode(account.getName());
                        }
                        if (null != accountRecord.getToAccountCode() && accountRecord.getToAccountCode().equals(account.getAccCode())) {
                            accountRecord.setToAccountCode(account.getName());
                        }
                    }
                }
                log.info("get accountList data is " + accountList.size());
                model.addAttribute("list", accountList);
                model.addAttribute("mobileMap", mobileMap);
                model.addAttribute("managerMap", managerMap);
                model.addAttribute("uid_userType", uid_userType);

            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", total);
            model.addAttribute("totalPage", totalPage(size, Integer.parseInt(total + "")));
        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("get userAccountRelation list error,page is  " + start + " , size " + size);
            model.addAttribute("code", -1);
        }
        return "/admin/accountRecord/jsp/accountRecordListJson";
    }


    /**
     * 查询上账详情
     *
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/account/record/{id}/detail", method = RequestMethod.GET)
    public String getUserAccountRecordDetail(HttpServletRequest request, HttpServletResponse response,@PathVariable Long id, ModelMap model) throws Exception {

        log.info("get account record : " + id + " detail");

        //第一步： 获取登陆账号
        Long mid = getUserId(request);
        log.info(" manager id =  " + mid);

        try {

            AccountRecord accountRecord = accountRecordService.getObjectById(id);

            if(null == accountRecord){
                log.info("account record : " + id + " not exist");
                model.addAttribute("code", -9003);
                return "/common/success";
            }


            User user = userService.getObjectById(accountRecord.getUserId());
            if(null == user){
                log.info("account record : " + id + " user : " + accountRecord.getUserId() + " not exist");
                model.addAttribute("code", -9000);
                return "/common/success";
            }

            Integer userType = user.getType();

            List<Long> accountIds = accountService.getAccountIds(0, 100);
            List<Account> accounts = accountService.getObjectsByIds(accountIds);

            Long managerId = accountRecord.getUpdateBy();

            String nick = "";
            if(null == managerId){
                log.info("no verify manager");
            }else {
                Manager manager = managerService.getObjectById(managerId);
                if(null == manager){
                    log.info("manager : " + mid + " not exist");
                    model.addAttribute("code", -1007);
                    return "/common/success";
                }else {
                    log.info("manager : " + manager);
                    nick = manager.getNick();
                }
            }

//            for (Account account : accounts) {
//                if (accountRecord.getAccountCode().equals(account.getAccCode())) {
//                    accountRecord.setAccountCode(account.getName());
//                }
//                if (null != accountRecord.getToAccountCode() && accountRecord.getToAccountCode().equals(account.getAccCode())) {
//                    accountRecord.setToAccountCode(account.getName());
//                }
//            }

            model.addAttribute("record", accountRecord);
            model.addAttribute("userType", userType);
            model.addAttribute("nick", nick);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("get account record : " + id + " detail error");
            model.addAttribute("code", -1);
        }
        return "/admin/accountRecord/jsp/accountRecordJson";
    }


    /**
     * 修改汇款挂账确认函是否已到
     *
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/account/record/{id}/detail", method = RequestMethod.PUT)
    public String updateAccountRecord(HttpServletRequest request, HttpServletResponse response,
                                                            @PathVariable Long id, Integer receiveCheck, ModelMap model) throws Exception {

        log.info("update account record : " + id + " set receiveCheck : " + receiveCheck);

        //第一步： 获取登陆账号
        Long mid = getUserId(request);
        log.info(" manager id =  " + mid);

        try {
//            if(!AccountRecord.receive_check_n.equals(receiveCheck) && !AccountRecord.recevie_check_y.equals(receiveCheck)){
//                log.info("account record : " + id + " not exist");
//                model.addAttribute("code", -9003);
//                return "/common/success";
//            }

            AccountRecord accountRecord = accountRecordService.getObjectById(id);

            if(null == accountRecord){
                log.info("account record : " + id + " not exist");
                model.addAttribute("code", -9003);
                return "/common/success";
            }

            accountRecord.setReceiveCheck(receiveCheck);
            accountRecordService.update(accountRecord);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace(System.out);
            log.error(t.getMessage());
            log.error("get account record : " + id + " detail error");
            model.addAttribute("code", -1);
        }
        return "/admin/accountRecord/jsp/accountRecordJson";
    }

}
