package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.RecordLog;
import com.ptteng.common.skill.service.RecordLogService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class RecordLogServiceImpl extends BaseDaoServiceImpl implements RecordLogService {

 

	private static final Log log = LogFactory.getLog(RecordLogServiceImpl.class);



		   
		@Override
		public Long insert(RecordLog recordLog)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + recordLog);

		if (recordLog == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		recordLog.setCreateAt(currentTimeMillis);
		recordLog.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(recordLog);
		} catch (DaoException e) {
			log.error(" insert wrong : " + recordLog);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<RecordLog> insertList(List<RecordLog> recordLogList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (recordLogList == null ? "null" : recordLogList.size()));
      
		List<RecordLog> resultList = null;

		if (CollectionUtils.isEmpty(recordLogList)) {
			return new ArrayList<RecordLog>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RecordLog recordLog : recordLogList) {
			recordLog.setCreateAt(currentTimeMillis);
			recordLog.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<RecordLog>) dao.batchSave(recordLogList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + recordLogList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(RecordLog.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(RecordLog recordLog)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (recordLog == null ? "null" : recordLog.getId()));

		boolean result = false;

		if (recordLog == null) {
			return true;
		}

		recordLog.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(recordLog);
		} catch (DaoException e) {
			log.error(" update wrong : " + recordLog);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + recordLog);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<RecordLog> recordLogList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (recordLogList == null ? "null" : recordLogList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(recordLogList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (RecordLog recordLog : recordLogList) {
			recordLog.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(recordLogList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + recordLogList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + recordLogList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public RecordLog getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		RecordLog recordLog = null;

		if (id == null) {
			return recordLog;
		}

		try {
			recordLog = (RecordLog) dao.get(RecordLog.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return recordLog;		
		}	
		  
    	   
		@Override
		public List<RecordLog> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<RecordLog> recordLog = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<RecordLog>();
		}

		try {
			recordLog = (List<RecordLog>) dao.getList(RecordLog.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (recordLog == null ? "null" : recordLog.size()));
    
		return recordLog;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getRecordLogIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getRecordLogIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countRecordLogIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getRecordLogIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getRecordLogIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getRecordLogIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countRecordLogIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getRecordLogIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getRecordLogIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

