package com.ptteng.common.skill.controller;

import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Successor;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.SuccessorService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.common.skill.util.DynamicUtil;
import com.ptteng.common.skill.util.ObjectConvertUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * BranchInstitute  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class BranchController {
    private static final Log log = LogFactory.getLog(BranchController.class);

    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private UserService userService;
    @Autowired
    SuccessorService successorService;

    /**
     * show 分院列表
     *
     * @param name 分院名
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author weijiang
     * @date 2017
     */
    @RequestMapping(value = "/a/branch/search/query", method = RequestMethod.GET)
    public String searchDaily(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, String name, Long uid,
                              String qq, Integer period, String phone, String url, String address, Integer status,
                              Integer page, Integer size, String nick, Integer orderBy, Integer sort) throws Exception {

        /* 1 初始化参数 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int limit = size + 1;
        boolean next = false;

        List<Long> idList = null;
        List<Long> totalList = null;
        List<Long> userIdList = null;
        List<User> userList = null;
        List<User> users = new ArrayList<>();
        Integer total = null;
        List<BranchInstitute> branchInstituteList = new ArrayList<>();
        BranchInstitute branchInstitute = new BranchInstitute();
        try {

            if (StringUtil.isEmpty(nick)) {
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status, null);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                log.info("====== idlist is " + idList);
                totalList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, 0, Integer.MAX_VALUE);

                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                total = totalList.size();

                Set<Long> uids = new HashSet();
                for (BranchInstitute branchInstitute1 : branchInstituteList) {
                    uids.add(branchInstitute1.getUid());
                }

                if (!CollectionUtils.isEmpty(uids)) {
                    users = userService.getObjectsByIds(new ArrayList(uids));
                }
            } else {

                Map<String, Object> param2 = DynamicUtil.getUserListParam2(nick);
                userIdList = userService.getIdsByDynamicCondition(User.class, param2, start, size);
                users = this.userService.getObjectsByIds(userIdList);
                log.info("============= users : " + users.size());
                List<Long> uids = new ArrayList<Long>();
                for (User user : users) {
                    uids.add(user.getId());
                }
                log.info("========uids : is " + uids);
                uid = uids.get(0);
                Map<String, Object> param = DynamicUtil.getQueryBranchList(name, uid, qq, period, phone, url, address, status, null);
                idList = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, param, start, size);
                uids.add(uid);
                branchInstituteList = branchInstituteService.getObjectsByIds(idList);
                log.info("branchInstituteList is " + branchInstituteList.size());


            }
            next = page * size < total;
            model.addAttribute("users", users);
            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("page", page);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t);
            log.error(t.getMessage());
            log.error("get classesDailyList error,oid is ");
            model.addAttribute("code", -100000);
        }

        return "/common-skill-service/branch/json/branchListJson";

    }

    /**
     * show 获取各分院在学、结业学员统计信息
     *
     * @param branchId 分院id（可选，传了就查一个分院的信息）
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/4
     */
    @RequestMapping(value = "/a/branch/count", method = RequestMethod.GET)
    public String getBranchCount(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Long branchId) throws Exception {
        log.info("getBranchCount: branchId is " + branchId);
        try {
            //获取分院信息
            Map<String, Object> branchParam = DynamicUtil.getQueryBranchList(null, null, null, null, null, null, null, BranchInstitute.STATUS_ENBLE, branchId);
            List<Long> branchIds = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, branchParam, 0, Integer.MAX_VALUE);
            List<BranchInstitute> branchInstituteList = branchInstituteService.getObjectsByIds(branchIds);
            log.info("branch ids is " + branchIds);
            //获取分院在学信息
            Map<String, Object> studyCountParam = DynamicUtil.getUserStatisticsByStatusAndBranch(User.Status_Student, branchId, false, false, true);
            List<Long> studyCount = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, studyCountParam, 0, Integer.MAX_VALUE);
            log.info("studyCount is " + studyCount);

            //获取分院结业信息
            Map<String, Object> completeCountParam = DynamicUtil.getUserStatisticsByStatusAndBranch(User.STATUS_3, branchId, false, false, true);
            List<Long> completeCount = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, completeCountParam, 0, Integer.MAX_VALUE);
            log.info("completeCount is " + completeCount);

            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("studyCount", studyCount);
            model.addAttribute("completeCount", completeCount);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get branch user count error");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/branch/json/branchCount";
    }

    /**
     * show 所有分院概况
     *
     * @param branchId 分院id（可选，传了就查一个分院的信息,暂不用）
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/4
     */
    @RequestMapping(value = "/a/branch/overall", method = RequestMethod.GET)
    public String getBranchOverall(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long branchId) throws Exception {
        log.info("getBranchOverall: branchId is " + branchId);
        Object studyCount = 0;
        Object successorCount = 0;
        Object completeCount = 0;
        Object salaryAverage = 0;
        Object employRate = 0;
        try {
            //获取分院信息
            Map<String, Object> branchParam = DynamicUtil.getQueryBranchList(null, null, null, null, null, null, null, BranchInstitute.STATUS_ENBLE, branchId);
            List<Long> branchIds = branchInstituteService.getIdsByDynamicCondition(BranchInstitute.class, branchParam, 0, Integer.MAX_VALUE);
            List<BranchInstitute> branchInstituteList = branchInstituteService.getObjectsByIds(branchIds);
            log.info("branch ids is " + branchIds);
            //获取在学信息
            Map<String, Object> studyCountParam = DynamicUtil.getUserStatisticsByStatusAndBranch(User.Status_Student, branchId, false, false, false);
            studyCount = branchInstituteService.getObjectByDynamicCondition(BranchInstitute.class, studyCountParam, 0, Integer.MAX_VALUE);
            log.info("studyCount is " + studyCount);


            //获取结业信息/平均薪资/就业率
            Map<String, Object> completeCountParam = DynamicUtil.getUserStatisticsByStatusAndBranch(User.STATUS_3, branchId, true, true, false);
            Object[] result = (Object[]) branchInstituteService.getObjectByDynamicCondition(BranchInstitute.class, completeCountParam, 0, Integer.MAX_VALUE);

            completeCount = DataUtils.isNotNullOrEmpty(result[0]) ? result[0] : 0;
            log.info("completeCount is " + completeCount);
            salaryAverage = DataUtils.isNotNullOrEmpty(result[1]) ? result[1] : 0;
            log.info("salaryAverage is " + salaryAverage);
            employRate = DataUtils.isNotNullOrEmpty(result[2]) ? result[2] : 0;
            log.info("employRate is " + employRate);

            //获取真传信息
            Map<String, Object> successorSQLMap = DynamicUtil.getSuccessorListByBranchIdAndOidAndUid(branchId, null, null, true);
            successorCount = successorService.getObjectByDynamicCondition(Successor.class, successorSQLMap, 0, Integer.MAX_VALUE);
            log.info("successCount is " + successorCount);


            model.addAttribute("code", 0);
            model.addAttribute("branchInstituteList", branchInstituteList);
            model.addAttribute("teacherCount", successorCount);
            model.addAttribute("studyCount", studyCount);
            model.addAttribute("completeCount", completeCount);
            model.addAttribute("salaryAverage", salaryAverage);
            model.addAttribute("employRate", employRate);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get branch overall error");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/branch/json/branchOverall";
    }

    /**
     * show 分院详情
     *
     * @param id 分院id
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/4
     */
    @RequestMapping(value = "/a/branch/{id}/detail", method = RequestMethod.GET)
    public String getBranchDetail(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {
        log.info("getBranchDetail:id is " + id);
        if (DataUtils.isNullOrEmpty(id)) {
            log.info("id is null");
            {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
        }
        try {
            //获取分院信息
            BranchInstitute branch = branchInstituteService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(branch)) {
                log.warn("this branch is not found");
                model.addAttribute("code", -10);
                return "/common/success";
            }
            Long uid = branch.getUid();
            log.info("this branch uid is " + uid);

            //获取分院负责人信息
            User user = userService.getObjectById(uid);
            if (DataUtils.isNullOrEmpty(user)) {
                log.warn("this user is not found");
                model.addAttribute("code", -15000);
                return "/common/success";
            }

            model.addAttribute("code", 0);
            model.addAttribute("branchInstitute", branch);
            model.addAttribute("user", user);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get branch detail error");
            model.addAttribute("code", -1);
        }
        return "/common-skill-service/branch/json/branchDetailJson";
    }


    /**
     * show 分院学员统计
     *
     * @param branchId 分院id
     * @param type     统计类型 1总 2月
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/4
     */
    @RequestMapping(value = "/a/branch/statistics", method = RequestMethod.GET)
    public String getBranchStatistics(HttpServletRequest request,
                                      HttpServletResponse response, ModelMap model, Long branchId, Integer type) throws Exception {
        log.info("getBranchStatistics: branchId is " + branchId + " ,type is " + type);
        if (DataUtils.isNullOrEmpty(branchId) || DataUtils.isNullOrEmpty(type)) {
            log.info("branchId is null");
            model.addAttribute("code", -1000);
            return "/common/success";
        }
        try {
            Map<String, Object> map = DynamicUtil.getBranchStatisticsByBranchIdAndType(branchId);

            Object resultObject = branchInstituteService.getObjectByDynamicCondition(BranchInstitute.class, map, 0, Integer.MAX_VALUE);
            List<Object[]> result = (List<Object[]>) ObjectConvertUtil.objectToArrayList(resultObject);
            log.info("db result size is " + result.size());
            result = fillDate(result);
            log.info("new result size is " + result.size());
            //若是总绩进行数据累加
            if (BranchInstitute.STATISTICS_YEAR == type) {
                for (int i = 0, len = result.size(); i < len; i++) {
                    if (i > 0) {
                        result.get(i)[1] = Integer.parseInt(result.get(i)[1].toString()) + Integer.parseInt(result.get(i - 1)[1].toString());
                        result.get(i)[2] = Integer.parseInt(result.get(i)[2].toString()) + Integer.parseInt(result.get(i - 1)[2].toString());
                    }
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("dateList", result);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get branch statistics error");
            model.addAttribute("code", -100000);
        }
        return "/common-skill-service/branch/json/branchStatistics";
    }


    private static List<Object[]> fillDate(List<Object[]> list) {
        log.info("fill date start ");
        if(list.size() == 0){
            log.info("data is null");
            return list;
        }
        for (Object[] ave : list) {
            log.info(ave[0]);
        }
        //1.获取当前年月
        SimpleDateFormat time = new SimpleDateFormat("yyyy-MM");
        String nowDate = time.format(new Date());
        Object[] test = nowDate.split("-");
        //TreeMap key值排序
        Map<Object, Object[]> map = new TreeMap<Object, Object[]>(new Comparator<Object>() {
            @Override
            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });


        //生成空数据填充
        Object first = list.get(0)[0];
        String firstDate = String.valueOf(first);
        Object[] test1 = firstDate.split("-");

        int num = (Integer.parseInt(test[0].toString()) - Integer.parseInt(test1[0].toString())) * 12;

        log.info(test1[0]);
        if (Integer.parseInt(test[1].toString()) >= Integer.parseInt(test1[1].toString())) {
            num += (Integer.parseInt(test[1].toString()) - Integer.parseInt(test1[1].toString()));
        } else {
            num -= (Integer.parseInt(test1[1].toString()) - Integer.parseInt(test[1].toString()));
        }
        log.info(num);
        int nowYear = Integer.valueOf(test[0].toString());
        int nowMonth = Integer.valueOf(test[1].toString());
        for (int i = 1,j = 12; i <= num; i++) {
            String yearMonth = "";
            if(nowMonth>0){
                yearMonth = (nowYear + "") + "-" + (nowMonth < 10 ? "0" + nowMonth : nowMonth + "");
                log.info(yearMonth);
                --nowMonth;
            }
            else{
                if(nowMonth == 0){
                    nowMonth = 12;
                    yearMonth = ((--nowYear) + "") + "-" + ( nowMonth + "");
                    --nowMonth;
                    log.info(yearMonth);
                }
            }
            //i为月份，如果i小于当月，则算为当年的数据
            /*if (i <= Integer.parseInt(test[1].toString())) {
                yearMonth = ((test[0]) + "") + "-" + (i < 10 ? "0" + i : i + "");
                log.info(yearMonth);
            } else {
                //每12个月往前减一年
                if (i % 12 == 0) {
                    yearMonth = ((--nowYear) + "") + "-" + (12 + "");
                    log.info(yearMonth);
                } else {
                    if (i % 12 <= Integer.parseInt(test[1].toString())) {
                        yearMonth = ((nowYear) + "") + "-" + (i % 12 < 10 ? "0" + i % 12 : i % 12 + "");
                        log.info(yearMonth);
                    } else {
                        //最初一年倒序排列
                        if (nowYear - 1 == Integer.parseInt(test1[0].toString())) {
                            yearMonth = ((nowYear - 1) + "") + "-" + ((13 - (num - i)) < 10 ? "0" + (13 - (num - i)) : 13 - (num - i) + "");
                            log.info(yearMonth);
                        } else {
                            yearMonth = ((nowYear - 1) + "") + "-" + (i % 12 < 10 ? "0" + i % 12 : i % 12 + "");
                            log.info(yearMonth);
                        }
                    }
                }

            }*/

            Object[] dateData = {yearMonth, 0, 0};
            map.put(yearMonth, dateData);
        }
        //真实数据覆盖填充的数据
        log.info("fill date");
        for (Object[] os : list) {
            String item = String.valueOf(os[0]);
            Object[] itemdate = item.split("-");
            int year = Integer.parseInt(test[0].toString());
            log.info(year);
            int itemYear = Integer.parseInt(itemdate[0].toString());
            log.info(itemYear);
            int month = Integer.parseInt(test[1].toString());
            log.info(month);
            int itemMonth = Integer.parseInt(itemdate[1].toString());
            log.info(itemMonth);
            if(itemYear > year || itemYear == year && itemMonth > month){
                log.info(os[0]);
            }
            else{
                map.put(os[0], os);
            }
        }
        list.clear();
        list.addAll(map.values());
        log.info("fill date end");
        return list;
    }


}