package com.ptteng.common.skill.util;

import java.util.*;

import com.gemantic.common.util.StringUtil;
import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.common.skill.model.*;
import com.ptteng.skill.service.model.UserTaskRelation;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.ptteng.common.dao.util.SQLUtil;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;

/**
 * Created by liangxj on 2015/9/7.
 */
public class DynamicUtil {
    private static final Log log = LogFactory.getLog(DynamicUtil.class);
    public static List<Document> getSkillMastLoveDocument(Long[] sids,Integer type ) {

        StringBuilder sidStr = new StringBuilder("");
        int i = 0;
        for(Long sid : sids){
            i+=1;
            if(i==sids.length){
                sidStr.append(sid);
            }else {
                sidStr.append(sid+",");
            }

        }


        log.info("Test 111 ");
        List<Document> indentParmList = new ArrayList<Document>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT  GROUP_CONCAT(DISTINCT a.sid) sid  ,b.id id, b.love love ,b.document_name document_name ,b.url url from " +
                    "(select   sid,MAX(love) love  from document where sid in("+sidStr.toString()+") and type = "+type+" GROUP BY sid) a," +
                    "document b " +
                    "where a.sid = b.sid and b.love = a.love and b.sid in ("+sidStr.toString()+")  and b.type = "+type+" GROUP BY a.sid");


            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(Document.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }



    public static List<User> getUserVideo(Integer start,Integer limit) {


        log.info("Test 111 ");
        List<User> indentParmList = new ArrayList<User>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append("select id from user where  graduated_video is not null and graduated_video !=''");
            sql.append("  order by start_at desc ");

            sql.append(" limit  " + start + "," + limit);
            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(User.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static Map<String, Object> getUserListByParams(Long oid, Long tid, Integer branch, Integer identity, Integer level,
                                                          Long studyStartAt, Long studyEndAt, Long graduatedStartAt, Long graduatedEndAt,
                                                          String nick, String type, Integer studyNumber,Integer status,  boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user");
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("user.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(oid)) {
            params.put("user.oid", oid);
        }
        if (DataUtils.isNotNullOrEmpty(branch)) {
            params.put("user.branch", branch);
        }
        if (DataUtils.isNotNullOrEmpty(identity)) {
            params.put("user.identity", identity);
        }
        if (DataUtils.isNotNullOrEmpty(level)) {
            params.put("user.level", level);
        }
        if (DataUtils.isNotNullOrEmpty(studyStartAt)) {
            params.put("user.start_at & >= ", studyStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(studyEndAt)) {
            params.put("user.start_at & <= ", studyEndAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedStartAt)) {
            params.put("user.graduate_at & >= ", graduatedStartAt);
        }
        if (DataUtils.isNotNullOrEmpty(graduatedEndAt)) {
            params.put("user.graduate_at & <= ", graduatedEndAt);

        }
        if (StringUtil.isNotEmpty(nick)) {
            params.put("user.nick & like ", "'%" + nick + "%'");
        }
        if (StringUtil.isNotEmpty(type)) {
            params.put("user.type", "'" + type + "'");
        }
        if (DataUtils.isNotNullOrEmpty(studyNumber)) {
            params.put("user.study_number", studyNumber);
        }

        if (DataUtils.isNotNullOrEmpty(tid)) {
            tables.add("user_task_relation");
            params.put("user.id", "user_task_relation.uid");
            params.put("user_task_relation.tid & <= ", tid);

        }

        if (count) {
            params.put("@query", " count(user.id) ");
        } else {
            params.put("@query", " user.id ");
            params.put("@order", "user.start_at desc");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static void checkUserGraduateStatus(List<User> users) {
        Long now = System.currentTimeMillis();
        for (User user : users) {
            Long graduateAt = user.getGraduateAt();
            if (DataUtils.isNullOrEmpty(graduateAt)) {
                log.info(" user graduateAt is null ,so he dosen't graduate ");
                user.setGraduated(false);
            } else {
                if (graduateAt <= now) {
                    log.info(" user graduateAt<=now ,so he has graduated ");
                    user.setGraduated(true);
                } else {
                    log.info(" user graduateAt>now , so he dosen't graduate ");
                    user.setGraduated(false);
                }
            }

        }
    }


    public static void checkUserGraduateStatus(User user) {
        Long now = System.currentTimeMillis();
        Long graduateAt = user.getGraduateAt();
        if (DataUtils.isNullOrEmpty(graduateAt)) {
            log.info(" user graduateAt is null ,so he dosen't graduate ");
            user.setGraduated(false);
        } else {
            if (graduateAt <= now) {
                log.info(" user graduateAt<=now ,so he has graduated ");
                user.setGraduated(true);
            } else {
                log.info(" user graduateAt>now , so he dosen't graduate ");
                user.setGraduated(false);
            }
        }


    }

    public static Map<String, Object> getMessageListParam(Integer status, String type, Long uid,Integer unread,
                                                          boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put(" receive_id ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put(" status ", status);
        }
        if (DataUtils.isNotNullOrEmpty(unread)) {
            params.put(" unread ", unread);
        }
        if (StringUtils.isNotEmpty(type)) {
            if (Message.CLASS_TYPE.equals(type)) {
                params.put(" type & in ", "('" + Message.CLASS_TYPE + "','" + Message.TEACHER_TYPE + "')");
            } else {
                params.put(" type ", "'" + type + "'");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  create_at desc ");

            params.put("@query", " id ");
        }
        params.put("@table", "message");

        return params;

    }

    public static List<DocumentAndSkill> getDocumentIdByMaxLove(Set<Long> skillIDS) {
        log.info("skillIDS: " + skillIDS);
        List<DocumentAndSkill> documentAndSkills = new ArrayList<>();
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_skill");
            log.info("getBeforeNextArticleId datasource: " + dataSource);

            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);

            StringBuilder sql = new StringBuilder("");
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
            }


            sql.append("select MAX(love) as love,sid ,id from document where sid in (" + sbuf + ") GROUP BY sid");
            documentAndSkills = simpleJdbcTemplate.query(sql.toString(),
                    ParameterizedBeanPropertyRowMapper.newInstance(DocumentAndSkill.class));
            log.info("ids: " + documentAndSkills.size());
        } catch (Exception e) {
            log.error("getDocumentIdByMaxLove error ", e);
        }
        return documentAndSkills;
    }


    public static Map<String, Object> getUserLoveArticleList(Integer type, Integer orderBy, Integer sort, Long uid,
                                                             boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_article_relation");
        tables.add("article");
        params.put(" user_article_relation.aid ", " article.id ");
        params.put(" user_article_relation.whether  ", UserArticleRelation.WHETHER_VALID);
        params.put("user_article_relation.uid", uid);
        if (UserArticleRelation.STATUS_LOVE == type) {
            //点赞
            params.put(" user_article_relation.type ", UserArticleRelation.STATUS_LOVE);
        } else if (UserArticleRelation.STATUS_COLLECTION == type) {
            //收藏
            params.put(" user_article_relation.type  ", UserArticleRelation.STATUS_COLLECTION);
        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getUserTaskListByTeacherId(Long teacherId,
                                                                 Integer type,
                                                                 boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_task_relation");
        tables.add("user");
        params.put(" user_task_relation.uid ", " user.id ");
        params.put(" user.teacher_id ", teacherId);

        if (UserTaskRelation.UNJUDGE == type) {
            params.put(" user_task_relation.progress ", UserTaskRelation.PROGRESS_SUBMITED);

        } else if (UserTaskRelation.JUDGE_FAILD == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_FAIL);

        } else if (UserTaskRelation.JUDGE_PASS == type) {
            params.put(" user_task_relation.progress  ", UserTaskRelation.PROGRESS_PASSED);

        }

        if (count) {
            params.put("@query", " count(user_task_relation.id) ");
        } else {
            if (UserTaskRelation.UNJUDGE == type) {
                params.put("@order", "  user_task_relation.submit_at desc ");
            } else {
                params.put("@order", "  user_task_relation.judge_at desc ");

            }

            params.put("@query", " user_task_relation.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getDocumentListParam(Set<Long> skillIDS,
                                                           boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("document");

        if (skillIDS.size() > 0) {
            StringBuffer sbuf = new StringBuffer();
            for (Long skillID : skillIDS) {
                sbuf.append(skillID);
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("sid & in ", "(" + sbuf + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@order", "  love desc ");

            params.put("@query", " id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getUserDocumentRelationListParam(Long uid, List<Long> dids,
                                                                       Integer type, Integer status, Integer whether, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("user_document_relation");

        if (type != null) {
            params.put("type", type);
        }

        if (status != null) {
            params.put("status", status);
        }

        if (whether != null) {
            params.put("whether", whether);
        }

        if (uid != null) {
            params.put("uid", uid);
        }

        if (dids != null) {
            if (dids.size() > 0) {
                StringBuffer sbuf = new StringBuffer();
                for (Long did : dids) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document_id & in ", "(" + sbuf.toString() + ")");
                }
            }
        }

        if (count) {
            params.put("@query", " count(document_id) ");
        } else {
            params.put("@query", " distinct(document_id) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getArticleAuthorListParam(Long uid, Long tid, Long cid, Long oid,
                                                                Long createAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);

        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);

        }

        if (count) {
            params.put("@query", " count(article.uid) ");
        } else {

            params.put("@order", "  article.create_at desc ");

            params.put("@query", " distinct(article.uid) ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getStudentsArticleParam(List<Long> uidList, Long oid, Integer orderBy, Integer sort,
                                                              Integer stuEvaluation, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (oid != null) {
            params.put("oid", oid);
        }

        if (DataUtils.isNotNullOrEmpty(stuEvaluation)) {
            if(stuEvaluation ==1){
                params.put("evaluation & is  null ", "");
            }else if(stuEvaluation==2){
                params.put("evaluation & is not null ", "");
            }else {
                params.put("evaluation & is  null ", "");
            }
        }


        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }

            params.put("@order", a.toString());

            params.put("@query", " id ");
        }

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getNearStudentsArticleParam(List<Long> uidList, Long startAt, Long endAt) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uidList)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uidList) {
                if (uid != null) {
                    sbuf.append(uid.toString());
                    sbuf.append(",");
                }
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (null != startAt) {

            params.put(" create_at & > ", startAt);

            params.put("@order", " create_at ");
        }

        if (null != endAt) {

            params.put(" create_at & < ", endAt);

            params.put("@order", " create_at DESC ");
        }


        params.put("@query", " id ");

        params.put("@table", "article");

        return params;

    }

    public static Map<String, Object> getArticleListByDirectionParam(Long uid, Long tid, Long cid, Long oid,
                                                                     Long createAt, Long endAt, boolean direction, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            params.put("@query", " article.id ");

            if (direction && createAt != null) {
                params.put("@order", "  article.create_at ");
            } else {
                params.put("@order", "  article.create_at desc ");
            }
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    public static Map<String, Object> getArticleListParam(Long uid, Long tid, Long cid, Long oid,
                                                          Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & > ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & < ", endAt);


        }

        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ").toString();
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ").toString();
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }

    public static Map<String, Object> getArticleListByParam(Long uid, Long tid, Long cid, Long oid,
                                                            Long createAt, Long endAt, boolean direction, Integer orderBy, Integer sort,
                                                            Integer evaluation, String userType, Long userOid, Integer studyNumber,
                                                            boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("article");


        if (uid != null) {

            params.put("article.uid", uid);

        }


        if (tid != null) {

            params.put("article_task_relation.tid", tid);
            params.put("article.id", "article_task_relation.did");
            tables.add("article_task_relation");

        }

        if (cid != null) {

            params.put("article.cid", cid);

        }


        if (oid != null) {

            params.put("article.oid", oid);

        }


        if (createAt != null) {
            params.put("article.create_at & >= ", createAt);
        }


        if (endAt != null) {
            params.put("article.create_at & <= ", endAt);


        }

        if (DataUtils.isNotNullOrEmpty(evaluation)) {
            params.put(" article.evaluation", "'" + evaluation + "'");
        }
        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(userOid)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("article.uid ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(userOid)) {
                params.put(" user.oid ", userOid);
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (count) {
            params.put("@query", " count(article.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  article.love ");
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  article.collection ");
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  article.create_at ");
            } else if (UserArticleRelation.COMMENT == orderBy) {
                a.append("  article.reply ");
            } else if (UserArticleRelation.READ == orderBy) {
                a.append("  article.read_count ");
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " article.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;

    }


    

    public static Map<String, Object> getTaskListParam(Long id, Long oid,
                                                       boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("task");

        if (id != null) {

            params.put("task.id", id);

        }
        if (id != oid) {

            params.put("task.oid", oid);

        }


        if (count) {
            params.put("@query", " count(task.id) ");
        } else {

            params.put("@order", "  task.num ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    public static Map<String, Object> getCommentListParam(Long did,
                                                          Long startAt, Long endAt, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();
        tables.add("comment");

        if (did != null) {

            params.put("comment.did", did);

        }


        if (count) {
            params.put("@query", " count(comment.id) ");
        } else {

            params.put("@order", "  comment.create_at ");

        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }

    //有uid则依据uid、oid、status查询，否则依据oid、type、status查询
    public static Map<String, Object> getClassesListParam(Long oid, Long uid,
                                                          String type, Long status, Integer branch, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();



        if (uid != null) {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("user_class_relation.status", status);
            }
            params.put("user_class_relation.uid", uid);

            if (count) {
                params.put("@query", " count(user_class_relation.cid) ");
            } else {
                params.put("user_class_relation.cid", "classes.id");
                params.put("@query", " distinct(user_class_relation.cid) ");
                params.put("@order", "  user_class_relation.create_at desc ");
            }

            tables.add("user_class_relation");
            tables.add("classes");
        } else {
            if (oid != null) {
                params.put("oid", oid);
            }

            if (status != null) {
                params.put("status", status);
            }
            if (StringUtils.isNotBlank(type)) {
                params.put("type", "'" + type + "'");
            }
            if (DataUtils.isNotNullOrEmpty(branch)) {
                params.put("branch", branch);
            }

            if (count) {
                params.put("@query", " count(id) ");
            } else {
                params.put("@query", " id ");
                params.put("@order", "  name+0 desc ");
            }

            tables.add("classes");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;
    }


    public static Map<String, Object> getHisStudentRelationListParam(Long teacherId, String type, boolean count) {
        Map<String, Object> params = new HashMap<String, Object>();

        if (StringUtils.isNotBlank(type)) {
            params.put("type", "'" + type + "'");
        }

        if (CheckDataUtil.isNotNull(teacherId)) {
            params.put("teacher_id", teacherId);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", "  id ");
        }

        params.put("@table", "user");

        return params;
    }


    public static Map<String, Object> getAllUserClassRelationIdsByUids(List<Long> uids, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CollectionUtils.isNotEmpty(uids)) {
            StringBuffer sbuf = new StringBuffer();
            for (Long uid : uids) {
                sbuf.append(uid.toString());
                sbuf.append(",");
            }
            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put(" uid & in ", "(" + sbuf.toString() + ")");
            }
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");

        }

        params.put("@table", " user_class_relation ");

        return params;
    }


    public static Map<String, Object> getTeacherInfoListParam(Long oid, Integer identify, String orderBy, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        Set<String> tables = new HashSet();

        tables.add("user");
        tables.add("teacher");

        if (CheckDataUtil.isNotNull(oid)) {
            if(Occupation.CSS_ID.equals(oid)){
                params.put("user.oid & in ", "("+Occupation.CSS_ID+","+Occupation.JS_ID+")");

            }else {
                params.put("user.oid",oid);
            }
        }
        //只有为结业的可作为师兄，已结业不可
        params.put("(user.graduate_at & > ",System.currentTimeMillis()+" or user.graduate_at is null )");
        //只有正常状态的用户可以作为师兄，退学用户不可
        params.put("user.status",User.Status_Student);
        if (count) {
            params.put("@query", " count(user.id) ");

        } else {
            params.put("@query", " user.id ");
        }


        params.put("user.id", "teacher.id");
        params.put("user.identity", identify);
        params.put("@order", " teacher." + orderBy);

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);

        return params;


    }

    public static Map<String, Object> getMyCreateDocumentList(Integer type, Long uid,
                                                              Integer orderBy, Integer sort,
                                                              boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("document.author ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }


        if (count) {
            params.put("@query", " count(document.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " document.id ");
        }

        params.put("@table", "document");

        return params;
    }

    public static Map<String, Object> getMyCollectionDocumentList(Integer type, Long uid, Integer status, Integer weather,
                                                                  Integer orderBy, Integer sort,
                                                                  boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        tables.add("user_document_relation");
        params.put("document.id", " user_document_relation.document_id");
        if (DataUtils.isNotNullOrEmpty(uid)) {
            params.put("user_document_relation.uid ", uid);
        }
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put(" document.type", type);
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("user_document_relation.status", status);
        }
        if (DataUtils.isNotNullOrEmpty(weather)) {
            params.put(" user_document_relation.whether", weather);
        }

        if (count) {
            params.put("@query", " count(user_document_relation.id) ");
        } else {
            StringBuilder a = new StringBuilder("");
            if (UserArticleRelation.LOVE == orderBy) {
                a.append("  document.love ").toString();
            } else if (UserArticleRelation.COLLECTION == orderBy) {
                a.append("  document.collection ").toString();
            } else if (UserArticleRelation.ARTICLE_CREATE_AT == orderBy) {
                a.append("  document.create_at ").toString();
            }

            if (UserArticleRelation.DESC == sort) {
                a.append("desc");
            } else if (UserArticleRelation.ASC == sort) {
                a.append("asc");
            }
            params.put("@order", a.toString());
            params.put("@query", " user_document_relation.id ");
        }
        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;
    }


    public static Map<String, Object> getDocumentQueryListParam(Integer type, Integer rating, Long oid, Long[] sids,
                                                                String name, Integer orderBy, Integer sort,
                                                                String userType, Integer studyNumber,
                                                                boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();
        Set<String> tables = new HashSet();
        tables.add("document");
        if (DataUtils.isNotNullOrEmpty(type)) {
            params.put("document.type", type);
        }

        StringBuffer sbuf = new StringBuffer();

        if (DataUtils.isNotNullOrEmpty(sids)) {

            if (sids.length > 0) {
                for (Long sid : sids) {
                    if (null != sid) {
                        sbuf.append(sid.toString());
                        sbuf.append(",");
                    }
                }

                if (sbuf.length() > 0) {
                    sbuf.deleteCharAt(sbuf.length() - 1);
                    params.put("document.sid & in ", "(" + sbuf.toString() + ")");
                }

                sbuf.setLength(0);
            }

        } else if (null != oid) {

            params.put("document.oid", oid);

        } else {

        }

        if (StringUtils.isNotBlank(name)) {

            params.put("document.document_name & like ", "'%" + name + "%'");
        }

        if (DataUtils.isNotNullOrEmpty(userType)
                || DataUtils.isNotNullOrEmpty(studyNumber)) {
            tables.add("user");
            params.put("document.author ", "user.id");
            if (DataUtils.isNotNullOrEmpty(userType)) {
                params.put("user.type ", "'" + userType + "'");
            }
            if (DataUtils.isNotNullOrEmpty(studyNumber)) {
                params.put("user.study_number ", studyNumber);
            }
        }


        if (DataUtils.isNotNullOrEmpty(rating)) {
            switch (rating) {
                case Document.LOW:
                    params.put(" document.love & > ", Document.NORMAL_UP_LIMIT);
                    break;
                case Document.NORMAL:
                    params.put(" document.love & BETWEEN " + Document.NORMAL_DOWN_LIMIT + " AND " + Document.NORMAL_UP_LIMIT + " ", "");
                    break;
                case Document.BEST:
                    params.put(" document.love & < ", Document.NORMAL_DOWN_LIMIT);
                    break;
                default:
                    break;
            }
        }

		/* 正序的情况 */
        if (CheckDataUtil.equal(sort, 1)) {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love ");
                    break;
                case 2:
                    params.put("@order", " document.collection ");
                    break;
                default:
                    params.put("@order", " document.create_at ");
                    break;
            }

		/* 逆序的情况 */
        } else {
            switch (orderBy) {
                case 1:
                    params.put("@order", " document.love desc ");
                    break;
                case 2:
                    params.put("@order", " document.collection desc ");
                    break;
                default:
                    params.put("@order", " document.create_at desc ");
                    break;
            }
        }

        if (count) {

            params.put("@query", " count(document.id) ");
        } else {


            params.put("@query", " document.id ");
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }

    public static Map<String, Object> getDocumentParamByType(Integer type, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(type)) {
            params.put("type", type);
        }

        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", " love desc ");
            params.put("@query", " id ");
        }

        params.put("@table", "document");

        return params;

    }

    public static Map<String, Object> getDocumentRelationListParam(List<Long> dids, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(dids)) {

            for (Long did : dids) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("document_id & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }

		/* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_document_relation");

        return params;

    }

    public static Map<String, Object> getArticleRelationListParam(List<Long> aIds, Long uid, boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();

        StringBuffer sbuf = new StringBuffer();

        if (CollectionUtils.isNotEmpty(aIds)) {

            for (Long did : aIds) {
                if (null != did) {
                    sbuf.append(did.toString());
                    sbuf.append(",");
                }
            }

            if (sbuf.length() > 0) {
                sbuf.deleteCharAt(sbuf.length() - 1);
                params.put("aid  & in ", "(" + sbuf.toString() + ")");
            }

            sbuf.setLength(0);
        }

        if (null != uid) {

            params.put("uid", uid);
        }

        if (count) {

            params.put("@query", " count(id) ");
        } else {

            params.put("@query", " id ");
        }


		/* 只获取有效记录 */
        params.put("whether", UserArticleRelation.WHETHER_VALID);

        params.put("@table", "user_article_relation");

        return params;

    }
    
    
    /**
     * 第一种方法：根据评级查询该评级下每个任务的日报的id（不使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndEvaluationAndOid(Long uid,Integer evaluation,Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(evaluation)) {
            params.put("evaluation", evaluation);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid", oid);
        }
        params.put("@query", " id ");

        params.put("@table", "article");
        
        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));

        return params;

    }

    
    /**第二种方法：每个任务下日报的id（使用）
     * 用户任务统计接口调用动态查询
     * 用户每个任务下上、中、下的数量
     */
    public static Map<String, Object> getArticleIdsByUidAndTid(Long uid,Long tid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "article");
        
        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(tid)) {
            params.put("(tids", "'[" + tid + "]'" + " or "  +  " tids  like " + "'%," + tid + "]%')");
        }

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }

    /**
     * 查询用户已完成的任务id
     * @param uid
     * @param oid
     * @return
     */
    public static Map<String, Object> getUserTaskRelationIdsIdsByUidAndOid(Long uid,Long oid) {

        Map<String, Object> params = new HashMap<String, Object>();
        params.put("@query", " id ");
        params.put("@table", "user_task_relation");

        if (CheckDataUtil.isNotNull(uid)) {
            params.put("uid", uid);
        }
        if (CheckDataUtil.isNotNull(oid)) {
            params.put("oid",oid);
        }
        params.put("progress",UserTaskRelation.PROGRESS_PASSED);

        log.info("getArticleIdsByUidAndEvaluationAndOid sql is " + SQLUtil.convert2Sql(params, 0, 0));
        return params;

    }


    public static void main(String[] args) {
    	//getArticleIdsByUidAndTid(6030l,5l);
        getUserTaskRelationIdsIdsByUidAndOid(6030l,5l);
    }
    
}
