package com.ptteng.common.skill.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Account;
import com.ptteng.common.skill.model.Goods;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.AccountService;
import com.ptteng.common.skill.service.GoodsService;
import com.ptteng.sca.common.skill.client.AccountSCAClient;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Goods  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class GoodsController {
	private static final Log log = LogFactory.getLog(GoodsController.class);

	@Autowired
	private GoodsService goodsService;


	@Autowired
	private CookieUtil cookieUtil;


	@Autowired
	private AccountService accountService;


			
    /**
	 * 获取购物车的产品列表
	 * 加入购物车
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/u/goods", method = RequestMethod.GET)
	public String getGoodsIdsByBuyerAndIsConfirmJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long buyer,Integer isConfirm) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			User user = (User) request.getAttribute("user");
			Long uid = user.getId();


			List<Long> ids= goodsService.getGoodsByBuyerAndOrderid(uid, "0", start, size);
		log.info("get countGoodsIdsByBuyerAndIsConfirm size is " + ids.size());

			List<Goods> goodsList = goodsService.getObjectsByIds(ids);

			log.info("get goods data is " + goodsList.size());


			Integer total = goodsService.countGoodsIdBybuyerAndorderId(uid,0L);

			log.info("get goods count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("total", total);
			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}


	/**
	 * 3.获取订单的产品列表
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/a/u/goods/order/{oid} ", method = RequestMethod.GET)
	public String getGoodsForOrder(HttpServletRequest request,
														 HttpServletResponse response, ModelMap model, Integer page,
														 Integer size,Long buyer,Integer isConfirm,@PathVariable String oid) throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

			List<Long> ids = goodsService.getGoodsByBuyerAndOrderid(uid, oid, start, size);
			log.info("get countGoodsIdsByBuyerAndIsConfirm size is " + ids.size());

			List<Goods> goodsList = goodsService.getObjectsByIds(ids);

			log.info("get goods data is " + goodsList.size());

			Integer total = goodsService.countGoodsIdsByBuyerAndIsConfirm(uid,1);
			log.info("get goods count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}



	@RequestMapping(value = "/web/a/goods/{id}", method = RequestMethod.GET)
	public String getGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Goods goods = goodsService.getObjectById(id);
			log.info("get goods data is " + goods);

			model.addAttribute("code", 0);

			model.addAttribute("goods", goods);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get goods error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/goods/json/goodsDetailJson";
	}


	/**
	 * @param request
	 * @param response
	 * @param model
	 * @param goods
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/goods/{id}", method = RequestMethod.PUT)
	public String updateGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Goods goods) throws Exception {

		log.info("update goods : goods= " + goods);

		try {

			goodsService.update(goods);

			model.addAttribute("code", 0);

			model.addAttribute("goods", goods);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update goods error,id is  " + goods.getId());
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}

	/**
	 * 1.将商品加入购物车
	 * @param request
	 * @param response
	 * @param model
	 * @param goods
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/goods", method = RequestMethod.POST)
	public String addGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Goods goods) throws Exception {

		log.info("insert goods : goods= " + goods);

		try {
			goods.setId(null);

			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

            goods.setOrderId("0"); // 将新加入购物车的商品orderId默认设置为0
			log.info("the uid is " + uid);
			goods.setBuyer(uid);
			goods.setCreateBy(uid);
            goods.setUpdateBy(uid);

			goodsService.insert(goods);

//			List<Long> ids = accountService.getAccountByStatus(2, 0, goods.getGoodCount());
//			List<Long> ids = accountService.getAccountByStatusAndType(2,1L,0,goods.getGoodCount());
//
//
//			log.info("加入购物车"+ids);
//            if (ids.size() > 0&&goods.getType()==1){
//
//				List<Account> accountList = accountService.getObjectsByIds(ids);
//
//				for (Account account:accountList){
//					account.setStatus(4);
//					boolean bool = accountService.update(account);
//					log.info("the update account status is" + bool);
//
//				}
//			}

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add goods error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	/**
	 * 成批更新商品信息
	 * @param request
	 * @param response
	 * @param model
	 * @param
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/goods/list", method = RequestMethod.POST)
	public String updateGoodList(@RequestBody List<Goods> goodsList,  HttpServletRequest request,
							   HttpServletResponse response, ModelMap model) throws Exception {

		log.info("update goods : goods= " + goodsList);

		try {
			User user = (User) request.getAttribute("user");
			Long uid = user.getId();

			model.addAttribute("code", 0);
		} catch (Throwable t) {

			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add goods error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}


	// 删除购物车商品
	@RequestMapping(value = "/a/u/goods", method = RequestMethod.DELETE)
	public String deleteGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,  Long[] ids)
			throws Exception {

		try {

			log.info("ids  is " + ids);

			List<Long> list =Arrays.asList(ids);
			List<Goods> goodsList = goodsService.getObjectsByIds(list);

			for (Goods goods: goodsList){

                if (goods.getType() == 1){
					List<Long> acountids = accountService.getAccountByStatus(4, 0, goods.getGoodCount());
					List<Account> accountList = accountService.getObjectsByIds(acountids);
					for (Account account :accountList) {
						account.setStatus(2);
					}
					boolean bool = accountService.updateList(accountList);
					log.info("the update accountList status is" + bool);

				}
			}
			goodsService.deleteList(Goods.class,list);

			log.info("delete goods success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete goods error,id is  " + ids);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/goods", method = RequestMethod.GET)
	public String getMultiGoodsJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			List<Goods> goodsList = goodsService.getObjectsByIds(idList);
			log.info("get  goods data is " + goodsList);
			model.addAttribute("code", 0);			
			model.addAttribute("total",goodsList.size());
			model.addAttribute("goodsList", goodsList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get goods error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/goods/json/goodsListJson";
	}
	
}

