package com.ptteng.common.skill.util;

import com.ptteng.common.dao.util.SQLUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class SymptomUtil {


    /**
     *
     * @param uid      用户ID
     * @param wids     周会ID（in）
     * @param tid      症状类别ID
     * @param tname    症状类别名字
     * @param sid      症状ID
     * @param sname    症状名字
     * @param orderBy  排序字段 currentCount|totalCount
     * @param sort     排序方式 aesc,desc
     * @param count
     * @return
     */
    public static Map<String, Object> getDynamicParam(Long uid,String uname,String uphone, List<Long> wids,Long tid
                                                      ,String tname,Long sid,String sname,String orderBy,
                                                      String sort,boolean count){


        //症状本身有一个查询，数据从症状里来。 用户症状周会表还有一个关联关系，数据也可以从用户症状表里来。

        Map<String, Object> params = new HashMap<>();
        String query="symptom.id";

        Set<String> tables = new HashSet();
        tables.add("symptom");

        if (uid!=null) {
            tables.add("user_symptom_relation");
            params.put("user_symptom_relation.uid", uid);
            query="DISTINCT(user_symptom_relation.sid)";

        }
        if (StringUtils.isNotBlank(uname)) {
            tables.add("user_symptom_relation");
            tables.add("user");
            params.put("user.nick & like ", "'%" + uname + "%'");
            params.put("user_symptom_relation.uid", "user.id");

        }

        if (StringUtils.isNotBlank(uphone)) {
            tables.add("user_symptom_relation");
            tables.add("user");
            params.put("user.mobile", uphone);
            params.put("user_symptom_relation.uid", "user.id");

        }


        if (wids!=null&&wids.size()>0) {
            tables.add("user_symptom_relation");
            query="DISTINCT(user_symptom_relation.sid)";
            StringBuffer sb=new StringBuffer();
            sb.append( "(");

            int i=0;
            for(Long wid:wids){
                i++;
                sb.append(wid);
                if(i>=wids.size()){
                    sb.append(")");
                }else{
                    sb.append(",");
                }

            }

            params.put("user_symptom_relation.wid & in", sb.toString());
        }

        // 症状类别
        if (tid!=null) {

            tables.add("stype");
            params.put("stype.id", tid);
            params.put("symptom.tid", "stype.id");

        }

        if (StringUtils.isNotBlank(tname)) {
            tables.add("stype");
            params.put("stype.name & like ", "'%" + tname + "%'");
            params.put("symptom.tid", "stype.id");

        }

        //symptom
        if (sid!=null) {
            params.put("symptom.id", sid);
        }
        if (StringUtils.isNotBlank(sname)) {
            tables.add("symptom");
            params.put("symptom.name & like ", "'%" + sname + "%'");

        }

        String order="symptom.";
        // 排序字段
       if(StringUtils.isBlank(orderBy)){
           order=order+"create_at";
       }else{
           order=order+orderBy;
       }

       //排序方向

        if(StringUtils.isBlank(sort)){
           order=order+" desc";
        }else{
            order=order+" "+sort;
        }


        if (count) {
            params.put("@query", "count("+query+")");
        } else {
            params.put("@query", query);
            params.put("@order", order);
        }

        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }


    /**
     *
     * @param sid
     * @return
     */
    public static Map<String, Object>  countUser(Long sid,Long queryAt){


        //症状本身有一个查询，数据从症状里来。 用户症状周会表还有一个关联关系，数据也可以从用户症状表里来。

        Map<String, Object> params = new HashMap<>();


        Set<String> tables = new HashSet();
        tables.add("user_symptom_relation");




        if (sid!=null) {
            params.put("user_symptom_relation.sid", sid);
            params.put("@query", "count(distinct(uid))");
        }else{
            params.put("@query", "count(*)");
        }

        if (queryAt!=null) {
            tables.add("week");
            params.put("week.startAt & < ", queryAt);
            params.put("week.endAt & > ", queryAt);
            params.put("user_symptom_relation.wid", "week.id");

        }else{

        }



        String table = SQLUtil.convertTable(tables);
        params.put("@table", table);
        return params;

    }

}
