package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.SymptomService;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import com.ptteng.common.skill.service.WeekService;
import com.ptteng.common.skill.util.SymptomUtil;
import com.ptteng.common.skill.util.WeekUtil;
import com.ptteng.util.ComputeUtil;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Week  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class WeekController {
	private static final Log log = LogFactory.getLog(WeekController.class);

	@Autowired
	private WeekService weekService;

	@Autowired
	private UserSymptomRelationService userSymptomRelationService;

	@Autowired
	private SymptomService symptomService;








	/**
	 * 
	 * @param 
	 * @return 

	 */
	
		@RequestMapping(value = "/a/u/week/search", method = RequestMethod.GET)
	public String getWeekIdsByUidJsonList(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model, Integer page,
                                          Integer size, Long wid, Long branchID, String branchName,
										  Long uid, String unick, String uphone, Long occouptionID,
										  Long minWeekStartAt, Long maxWeekStartAt, Long minWeekEndAt,
										  Long maxWeekEndAt, Long seniorID, String seniorNick,
										  String seniorPhone, Long headID, String headPhone, String headNick,
										  Long sid, String sname, Long tid, String tname) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Week> weekList = new ArrayList<>();

			Long total = 0L,
					totalPage = 1L;


			Map<String, Object> paramList = WeekUtil.getDynamicParam( wid,  branchID,  branchName,  uid,
					unick,  uphone,  occouptionID,  minWeekStartAt,  maxWeekStartAt,  minWeekEndAt,  maxWeekEndAt,  seniorID,
					seniorNick,  seniorPhone,  headID,  headPhone,  headNick,  sid,  sname,  tid,  tname, false);
			log.info("get param:" + paramList);

			List<Long> wids = weekService.getIdsByDynamicCondition(Week.class, paramList, start, size);
			log.info("get wids:" + wids);

			Map<String, Object> paramCount =WeekUtil.getDynamicParam( wid,  branchID,  branchName,  uid,
					unick,  uphone,  occouptionID,  minWeekStartAt,  maxWeekStartAt,  minWeekEndAt,  maxWeekEndAt,  seniorID,
					seniorNick,  seniorPhone,  headID,  headPhone,  headNick,  sid,  sname,  tid,  tname, true);

			log.info("get param:" + paramList);
			List<Long> count = weekService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get wids:" + count);
             /* 获取total、totalPage */
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(count)) {
				total = count.get(0);
				totalPage = ComputeUtil.myDivideiCeil(total, size);
			}


			weekList = weekService.getObjectsByIds(wids);
			log.info("get week data is " + weekList.size());



			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("weekList", weekList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get week list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/week/{id}", method = RequestMethod.GET)
	public String getWeekJson(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Week week = weekService.getObjectById(id);
			log.info("get week data is " + week);

			model.addAttribute("code", 0);

			model.addAttribute("week", week);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get week error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekDetailJson";
	}

	@RequestMapping(value = "/a/u/week/{wid}", method = RequestMethod.PUT)
	public String updateWeekJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Week week , Long[] sids) throws Exception {

		log.info("update week : week= " + week+" relation is "+sids);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			week.setUpdateBy(manager.getId());
			Week oldWeek=this.weekService.getObjectById(week.getId());
			week.setCreateBy(oldWeek.getCreateBy());
			week.setCreateAt(oldWeek.getCreateAt());
			weekService.update(week);

			// 更新周会后，需要把周会和症状的关系表全删全查，多对多的维护就是这样的
			List<Long> usRelationIDS=this.userSymptomRelationService.getUserSymptomRelationIdsByWid(week.getId(),0,Integer.MAX_VALUE);
			log.info(week.getId()+" will delete all relation data "+usRelationIDS);
            this.userSymptomRelationService.deleteList(UserSymptomRelation.class,usRelationIDS);


			List<UserSymptomRelation> usRelations=new ArrayList();
			for(Long sid:sids){
				UserSymptomRelation usRelation=new UserSymptomRelation();
				usRelation.setSid(sid);
				usRelation.setWid(week.getId());
				usRelation.setUid(week.getUid());
				usRelation.setCreateBy(manager.getId());
				usRelation.setUpdateBy(manager.getId());
				usRelations.add(usRelation);


			}
			log.info(week.getId()+" will insrt all relation data "+ usRelations);
			userSymptomRelationService.insertList(usRelations);

			for(Long sid:sids){
				//重新计算每一个症状的人数
				calculateSymptomCount(sid);

			}


			model.addAttribute("code", 0);

			model.addAttribute("week", week);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update week error,id is  " + week.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/week", method = RequestMethod.POST)
	public String addWeekJson(HttpServletRequest request,
							  HttpServletResponse response, ModelMap model, Week week, Long[] sids) throws Exception {
		
		log.info("update week : week= " + week+" relation is "+sids);
		Long id=null;
		Manager manager = (Manager) request.getAttribute("manager");
		try { 
			week.setId(null);
			week.setCreateBy(manager.getId());
			week.setUpdateBy(manager.getId());
			if(week!=null){
				id=weekService.insert(week);
				log.info( " insert new stype id is "+id);
				if(sids==null||sids.length==0){

					log.info(week.getUid()+" not get any symptom");

				}else{

					List<UserSymptomRelation> usRelations=new ArrayList();
					for(Long sid:sids){
						UserSymptomRelation usRelation=new UserSymptomRelation();
						usRelation.setSid(sid);
						usRelation.setWid(id);
						usRelation.setUid(week.getUid());
						usRelation.setCreateBy(manager.getId());
						usRelation.setUpdateBy(manager.getId());
						usRelations.add(usRelation);
						//重新计算每一个症状的人数
						calculateSymptomCount(sid);


					}
					userSymptomRelationService.insertList(usRelations);
				}

			}else {

				log.info(" week is null ");
			}

			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add week error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	private void calculateSymptomCount(Long sid) throws ServiceException, ServiceDaoException {
		//计算症状的总人数
		Map<String, Object> paramCount = SymptomUtil.countUser( sid,null);

		log.info("get param:" + paramCount);
		List<Long> countResult = weekService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
		int count=countResult.get(0).intValue();


		//计算当前周的人数

		Map<String, Object> currentParamCount = SymptomUtil.countUser( sid,System.currentTimeMillis());

		log.info("get param:" + paramCount);
		List<Long> currentCountResult = weekService.getIdsByDynamicCondition(User.class, currentParamCount, 0, Integer.MAX_VALUE);
		int currentCount=currentCountResult.get(0).intValue();


        Symptom symptom=this.symptomService.getObjectById(sid);
        if(symptom!=null){
        	log.info(sid+" has new total count user is "+count);
        	symptom.setTotalCount(count);
			symptom.setCurrentCount(currentCount);
        	this.symptomService.update(symptom);
		}

	}

	@RequestMapping(value = "/a/week/{id}", method = RequestMethod.DELETE)
	public String deleteWeekJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete week : id= " + id);
		try {

			//删除周会之前会先删掉周会和用户的关系表
			List<Long> usRelationIDS=this.userSymptomRelationService.getUserSymptomRelationIdsByWid(id,0,Integer.MAX_VALUE);
			if(CollectionUtils.isEmpty(usRelationIDS)){
				log.info(id+" has no symptoms ");
			}else{

				List<UserSymptomRelation> usRelations=this.userSymptomRelationService.getObjectsByIds(usRelationIDS);
				this.userSymptomRelationService.deleteList(UserSymptomRelation.class,usRelationIDS);
				for(UserSymptomRelation usRelation:usRelations){
					//重新计算每一个症状的人数
					calculateSymptomCount(usRelation.getSid());
				}

			}
			weekService.delete(id);



			log.info("delete week success : id= " + id);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete week error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/week", method = RequestMethod.GET)
	public String getMultiWeekJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Week> weekList = weekService.getObjectsByIds(idList);
			log.info("get  week data is " + weekList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",weekList.size());

			model.addAttribute("weekList", weekList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get week error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/week/json/weekListJson";
	}
	
	
	
	
	
}

