package com.ptteng.controller;

import com.ptteng.common.skill.model.UserSymptomRelation;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * UserSymptomRelation  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UserSymptomRelationController {
	private static final Log log = LogFactory.getLog(UserSymptomRelationController.class);

	@Autowired
	private UserSymptomRelationService userSymptomRelationService;






    /**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

	@RequestMapping(value = "/c/userSymptomRelation", method = RequestMethod.GET)
	public String getuserSymptomRelationList(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/userSymptomRelation  to /userSymptomRelation/view/userSymptomRelationList");

		return "/common-skill-service/userSymptomRelation/view/userSymptomRelationList";
	}
    
    

    		
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userSymptomRelation1 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsByUidList1(HttpServletRequest request,
                                                      HttpServletResponse response, ModelMap model, Long uid) throws Exception {

		log.info("/userSymptomRelation  to /userSymptomRelation/view/userSymptomRelationList");

		return "/common-skill-service/userSymptomRelation/view/userSymptomRelationList";
	}

	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userSymptomRelation2 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsByWidList2(HttpServletRequest request,
                                                      HttpServletResponse response, ModelMap model, Long wid) throws Exception {

		log.info("/userSymptomRelation  to /userSymptomRelation/view/userSymptomRelationList");

		return "/common-skill-service/userSymptomRelation/view/userSymptomRelationList";
	}

	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 
	
		 @RequestMapping(value = "/c/userSymptomRelation3 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsBySidList3(HttpServletRequest request,
                                                      HttpServletResponse response, ModelMap model, Long sid) throws Exception {

		log.info("/userSymptomRelation  to /userSymptomRelation/view/userSymptomRelationList");

		return "/common-skill-service/userSymptomRelation/view/userSymptomRelationList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/c/userSymptomRelation/{id}", method = RequestMethod.GET)
	public String getUserSymptomRelation(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/userSymptomRelation/" + id + "  to /userSymptomRelation/view/userSymptomRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-skill-service/userSymptomRelation/view/userSymptomRelationDetail";
	}
	
	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userSymptomRelation1 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsByUidJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Long uid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userSymptomRelationService.getUserSymptomRelationIdsByUid(uid,start,size);
		log.info("get countUserSymptomRelationIdsByUid size is " + ids.size());

			List<UserSymptomRelation> userSymptomRelationList = userSymptomRelationService.getObjectsByIds(ids);
			log.info("get userSymptomRelation data is " + userSymptomRelationList.size());

			Integer total = userSymptomRelationService. countUserSymptomRelationIdsByUid(uid);
			log.info("get userSymptomRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userSymptomRelationList", userSymptomRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userSymptomRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userSymptomRelation/json/userSymptomRelationListJson";
	}

	
	
		
			
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userSymptomRelation2 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsByWidJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Long wid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userSymptomRelationService.getUserSymptomRelationIdsByWid(wid,start,size);
		log.info("get countUserSymptomRelationIdsByWid size is " + ids.size());

			List<UserSymptomRelation> userSymptomRelationList = userSymptomRelationService.getObjectsByIds(ids);
			log.info("get userSymptomRelation data is " + userSymptomRelationList.size());

			Integer total = userSymptomRelationService. countUserSymptomRelationIdsByWid(wid);
			log.info("get userSymptomRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userSymptomRelationList", userSymptomRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userSymptomRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userSymptomRelation/json/userSymptomRelationListJson";
	}

	
	
		
			
			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	
		@RequestMapping(value = "/a/userSymptomRelation3 ", method = RequestMethod.GET)
	public String getUserSymptomRelationIdsBySidJsonList(HttpServletRequest request,
                                                         HttpServletResponse response, ModelMap model, Integer page,
                                                         Integer size, Long sid) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= userSymptomRelationService.getUserSymptomRelationIdsBySid(sid,start,size);
		log.info("get countUserSymptomRelationIdsBySid size is " + ids.size());

			List<UserSymptomRelation> userSymptomRelationList = userSymptomRelationService.getObjectsByIds(ids);
			log.info("get userSymptomRelation data is " + userSymptomRelationList.size());

			Integer total = userSymptomRelationService. countUserSymptomRelationIdsBySid(sid);
			log.info("get userSymptomRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("userSymptomRelationList", userSymptomRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userSymptomRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userSymptomRelation/json/userSymptomRelationListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/userSymptomRelation/{id}", method = RequestMethod.GET)
	public String getUserSymptomRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			UserSymptomRelation userSymptomRelation = userSymptomRelationService.getObjectById(id);
			log.info("get userSymptomRelation data is " + userSymptomRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userSymptomRelation", userSymptomRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get userSymptomRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userSymptomRelation/json/userSymptomRelationDetailJson";
	}

	@RequestMapping(value = "/a/userSymptomRelation/{id}", method = RequestMethod.PUT)
	public String updateUserSymptomRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, UserSymptomRelation userSymptomRelation) throws Exception {
		
		log.info("update userSymptomRelation : userSymptomRelation= " + userSymptomRelation);
		
		try {
			
			userSymptomRelationService.update(userSymptomRelation);

			model.addAttribute("code", 0);

			model.addAttribute("userSymptomRelation", userSymptomRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update userSymptomRelation error,id is  " + userSymptomRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userSymptomRelation", method = RequestMethod.POST)
	public String addUserSymptomRelationJson(HttpServletRequest request,
                                             HttpServletResponse response, ModelMap model, UserSymptomRelation userSymptomRelation) throws Exception {
		
		log.info("update userSymptomRelation : userSymptomRelation= " + userSymptomRelation);
		
		try { 
			userSymptomRelation.setId(null);

			userSymptomRelationService.insert(userSymptomRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add userSymptomRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/userSymptomRelation/{id}", method = RequestMethod.DELETE)
	public String deleteUserSymptomRelationJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete userSymptomRelation : id= " + id);
		try {
			userSymptomRelationService.delete(id);

			log.info("add userSymptomRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete userSymptomRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/userSymptomRelation", method = RequestMethod.GET)
	public String getMultiUserSymptomRelationJson(HttpServletRequest request,
                                                  HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<UserSymptomRelation> userSymptomRelationList = userSymptomRelationService.getObjectsByIds(idList);
			log.info("get  userSymptomRelation data is " + userSymptomRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",userSymptomRelationList.size());

			model.addAttribute("userSymptomRelationList", userSymptomRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get userSymptomRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/userSymptomRelation/json/userSymptomRelationListJson";
	}
	
	
	
	
	
}

