package com.ptteng.controller;

import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Uevent;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.model.Week;
import com.ptteng.common.skill.service.UeventService;
import com.ptteng.common.skill.util.UEventUtil;
import com.ptteng.common.skill.util.WeekUtil;
import com.ptteng.util.ComputeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Uevent  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class UeventController {
	private static final Log log = LogFactory.getLog(UeventController.class);

	@Autowired
	private UeventService ueventService;





	
	
	    		
			
    /**
	 * 
	 * @param 
	 * @return 

	 */
	
		@RequestMapping(value = "/a/u/uevent/search", method = RequestMethod.GET)
	public String getUeventIdsByUidJsonList(HttpServletRequest request,
                                            HttpServletResponse response, ModelMap model, Integer page,
                                            Integer size, String ename, Long uid, String uname,
											String uphone, Long eid, Long minHappenAt, Long maxHappenAt) throws Exception {



			if (page == null) {
				page = 1;
			}
			if (size == null) {
				size = 10;
			}
			int start = (page - 1) * size;
			if (start < 0) {
				start = 0;
			}

			log.info("pageList : page= " + start + " , size=" + size);

			try {

				List<Uevent> ueventList = new ArrayList<>();

				Long total = 0L,
						totalPage = 1L;


				Map<String, Object> paramList = UEventUtil.getDynamicParam(  ename,  uid,  uname,
						 uphone,  eid,  minHappenAt,  maxHappenAt, false);
				log.info("get param:" + paramList);

				List<Long> eids = this.ueventService.getIdsByDynamicCondition(Week.class, paramList, start, size);
				log.info("get wids:" + eids);

				Map<String, Object> paramCount = UEventUtil.getDynamicParam(  ename,  uid,  uname,
						uphone,  eid,  minHappenAt,  maxHappenAt, true);

				log.info("get param:" + paramList);
				List<Long> count = ueventService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
				log.info("get wids:" + count);
             /* 获取total、totalPage */
				if (org.apache.commons.collections.CollectionUtils.isNotEmpty(count)) {
					total = count.get(0);
					totalPage = ComputeUtil.myDivideiCeil(total, size);
				}
			 ueventList = ueventService.getObjectsByIds(eids);
			log.info("get uevent data is " + ueventList.size());


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("ueventList", ueventList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get uevent list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/uevent/json/ueventListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/a/u/uevent/{id}", method = RequestMethod.GET)
	public String getUeventJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Uevent uevent = ueventService.getObjectById(id);
			log.info("get uevent data is " + uevent);

			model.addAttribute("code", 0);

			model.addAttribute("uevent", uevent);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get uevent error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/uevent/json/ueventDetailJson";
	}

	@RequestMapping(value = "/a/u/uevent/{id}", method = RequestMethod.PUT)
	public String updateUeventJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Uevent uevent) throws Exception {
		
		log.info("update uevent : uevent= " + uevent);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			uevent.setUpdateBy(manager.getId());
			Uevent oldUevent=this.ueventService.getObjectById(uevent.getId());
			uevent.setCreateBy(oldUevent.getCreateBy());
			uevent.setCreateAt(oldUevent.getCreateAt());
			ueventService.update(uevent);

			model.addAttribute("code", 0);

			model.addAttribute("uevent", uevent);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update uevent error,id is  " + uevent.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/uevent", method = RequestMethod.POST)
	public String addUeventJson(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Uevent uevent) throws Exception {
		
		log.info("update uevent : uevent= " + uevent);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			uevent.setId(null);
			uevent.setCreateBy(manager.getId());
			uevent.setUpdateBy(manager.getId());
			uevent.setId(null);

			Long id=ueventService.insert(uevent);

			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add uevent error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/uevent/{id}", method = RequestMethod.DELETE)
	public String deleteUeventJson(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete uevent : id= " + id);
		try {
			ueventService.delete(id);

			log.info("add uevent success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete uevent error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/a/multi/uevent", method = RequestMethod.GET)
	public String getMultiUeventJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Uevent> ueventList = ueventService.getObjectsByIds(idList);
			log.info("get  uevent data is " + ueventList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",ueventList.size());

			model.addAttribute("ueventList", ueventList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get uevent error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/uevent/json/ueventListJson";
	}
	
	
	
	
	
}

