package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.StypeService;
import com.ptteng.common.skill.service.SymptomService;
import com.ptteng.common.skill.service.UserSymptomRelationService;
import com.ptteng.common.skill.util.STypeUtil;
import com.ptteng.util.ComputeUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Stype  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class StypeController {
	private static final Log log = LogFactory.getLog(StypeController.class);

	@Autowired
	private StypeService stypeService;

	@Autowired
	private UserSymptomRelationService userSymptomRelationService;

	@Autowired
	private SymptomService symptomService;



	@RequestMapping(value = "/a/u/stype/search", method = RequestMethod.GET)
	public String getStypeJson(HttpServletRequest request,
							   HttpServletResponse response, ModelMap model,Integer page,
							   Integer size,   Long tid,String tname)
			throws Exception {

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);


		try {

			List<Stype> typeList = new ArrayList<>();

			Long total = 0L,
					totalPage = 1L;


			Map<String, Object> paramList = STypeUtil.getDynamicParam(   tid,  tname, false);
			log.info("get param:" + paramList);

			List<Long> tids = this.stypeService.getIdsByDynamicCondition(Week.class, paramList, start, size);
			log.info("get tids:" + tids);

			Map<String, Object> paramCount =STypeUtil.getDynamicParam( tid,  tname, true);

			log.info("get param:" + paramList);
			List<Long> count = this.stypeService.getIdsByDynamicCondition(User.class, paramCount, 0, Integer.MAX_VALUE);
			log.info("get tids:" + count);
             /* 获取total、totalPage */
			if (org.apache.commons.collections.CollectionUtils.isNotEmpty(count)) {
				total = count.get(0);
				totalPage = ComputeUtil.myDivideiCeil(total, size);
			}


			typeList=this.stypeService.getObjectsByIds(tids);


			log.info("get stype data is " + typeList);




			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);
			model.addAttribute("totalPage", totalPage);
			model.addAttribute("typeList", typeList);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get stype error,id is  " + tid);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/stype/json/stypeListJson";
	}




	@RequestMapping(value = "/a/u/stype/{id}/detail", method = RequestMethod.GET)
	public String getStypeJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Stype stype = stypeService.getObjectById(id);
			log.info("get stype data is " + stype);

			model.addAttribute("code", 0);

			model.addAttribute("stype", stype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get stype error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/stype/json/stypeDetailJson";
	}

	@RequestMapping(value = "/a/u/stype/{id}", method = RequestMethod.PUT)
	public String updateStypeJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Stype stype) throws Exception {
		
		log.info("update stype : stype= " + stype);
		Manager manager = (Manager) request.getAttribute("manager");
		try {
			stype.setUpdateBy(manager.getId());
			Stype oldSType=this.stypeService.getObjectById(stype.getId());
			stype.setCreateBy(oldSType.getCreateBy());
			stype.setCreateAt(oldSType.getCreateAt());
			stypeService.update(stype);

			model.addAttribute("code", 0);

			model.addAttribute("stype", stype);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update stype error,id is  " + stype.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/stype", method = RequestMethod.POST)
	public String addStypeJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, Stype stype) throws Exception {
		
		log.info("update stype : stype= " + stype);
		Manager manager = (Manager) request.getAttribute("manager");
		try { 
			stype.setId(null);
			stype.setCreateBy(manager.getId());
			stype.setUpdateBy(manager.getId());
			Long id=stypeService.insert(stype);

			log.info( " insert new stype id is "+id);
			model.addAttribute("id", id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add stype error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/stype/{id}", method = RequestMethod.DELETE)
	public String deleteStypeJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete stype : id= " + id);
		int code=0;
		try {
			//删除症状类型之前，先判断下面是否有症状，有就不能删

			boolean result=this.isPermitDeleteSType(id);

			if(result){
				stypeService.delete(id);
				log.info("delete stype success: id= " + id);
			}else{
				log.info("delete stype not success,still have symptom: id= " + id);
				code=-81000;
			}


			log.info("add stype success");
			model.addAttribute("code", code);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete stype error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}

	/**
	 * 如果症状类型下已经有症状了,不允许删除
	 * @param id
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	private boolean isPermitDeleteSType(Long id) throws ServiceException, ServiceDaoException {

		List<Long> ids=symptomService.getSymptomIdsByTid(id,0,Integer.MAX_VALUE);
		if(CollectionUtils.isEmpty(ids)){
			return true;
		}else{
			log.info(id+" cannot delete,because already has symptom datas "+ids);
			return false;
		}

	}


	@RequestMapping(value = "/a/multi/stype", method = RequestMethod.GET)
	public String getMultiStypeJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Stype> stypeList = stypeService.getObjectsByIds(idList);
			log.info("get  stype data is " + stypeList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",stypeList.size());

			model.addAttribute("stypeList", stypeList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get stype error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/stype/json/stypeListJson";
	}
	
	
	
	
	
}

