package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Product;
import com.ptteng.common.skill.model.Project;
import com.ptteng.common.skill.service.ManagerService;
import com.ptteng.common.skill.service.ProductService;
import com.ptteng.common.skill.service.ProjectService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.skill.model.Iteration;
import com.ptteng.common.skill.service.IterationService;

/**
 * Iteration  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class IterationController {
	private static final Log log = LogFactory.getLog(IterationController.class);

	@Autowired
	private IterationService iterationService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private ProductService productService;
	@Autowired
	private ProjectService projectService;
	@Autowired
	private ManagerService managerService;



			
    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	


	//迭代拖动排序
	@RequestMapping(value = "/a/u/pruduct/{pid}/iteration/sort", method = RequestMethod.POST)
	public String sortIteration(HttpServletRequest request,
							HttpServletResponse response, ModelMap model,@RequestBody List<Long> ids)
			throws Exception{
		log.info("sort iteration:ids="+ids);
		try {
			List<Iteration> iterations = this.iterationService.getObjectsByIds(ids);
			int index = 0;
			for (Iteration iteration:iterations){
				iteration.setSort(index);
				index = index +10;
			}
			this.iterationService.updateList(iterations);
			model.addAttribute("code",0);
		}catch (Throwable t){
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("order products error ");
			model.addAttribute("code", -1);
		}
		return "/common/success";
	}
	
	//迭代详情
	@RequestMapping(value = "/a/u/iteration/{id}", method = RequestMethod.GET)
	public String getIterationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("iteration id cannot be null");
			model.addAttribute("code", -22002);
		}
		try {
			Iteration iteration = iterationService.getObjectById(id);
//			log.info("get iteration data is " + iteration);

			model.addAttribute("code", 0);

			model.addAttribute("iteration", iteration);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get iteration error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/iteration/json/iterationDetailJson";
	}

	//编辑迭代
	@RequestMapping(value = "/a/u/iteration/{id}", method = RequestMethod.PUT)
	public String updateIterationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, Iteration iteration) throws Exception {

		log.info("------------------------:"+iteration);
		//判空
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		Iteration oldIteration = iterationService.getObjectById(id);
		if (oldIteration == null) {
			model.addAttribute("code", -22011);
			log.info("this iteration does not exist");
			return "/common/success";
		}
		if (iteration.getName() == null|| iteration.getProductId()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}


		
		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			iteration.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录进数据库
			iteration.setCreateAt(oldIteration.getCreateAt());
			iteration.setCreateBy(oldIteration.getCreateBy());

			Product product = productService.getObjectById(iteration.getProductId());

//			log.info("oldStatus:"+oldIteration.getStatus()+"newStatus:"+iteration.getStatus());
			//如果status的值没有发生改变，不进行上下架数据统计变动
			if (oldIteration.getStatus().intValue()==iteration.getStatus().intValue()){
				log.info("status has not change");
			}else {
				//上架前判断产品是否上架
				if (iteration.getStatus() == 1) {
					if (product.getStatus() == 0) {
						model.addAttribute("code", -22013);
						return "/common/success";
					}
				}
				//下架前判断是否有关联项目
				if (iteration.getStatus() == 0) {
					List<Long> projects = projectService.getProjectIdsByIterationIdOrderByCreateAt(iteration.getId(), 0, Integer.MAX_VALUE);
					if (CollectionUtils.isEmpty(projects)) {

					} else {
						model.addAttribute("code", -22015);
						return "/common/success";
					}
				}
				//产品的迭代数更新

				if (iteration.getStatus()==1){
					product.setNums(product.getNums()+1);
				}
				if (iteration.getStatus()==0){
					product.setNums(product.getNums()-1);
				}
			}

			iterationService.update(iteration);
			log.info("update: " + iteration);

			productService.update(product);


			model.addAttribute("code", 0);

			model.addAttribute("iteration", iteration);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update iteration error,id is  " + iteration.getId());
			model.addAttribute("code", -6003);
		}

		return "/data/json";
	}
	//获取迭代列表数据长度
	private Integer getIterationSize() throws ServiceException, ServiceDaoException {
		Map<String, Object> param = DynamicUtil.getSingleFieldParam(
				"sort desc", "iteration");
		List<Long> sizes = this.iterationService.getIdsByDynamicCondition(
				Iteration.class, param, 0, Integer.MAX_VALUE);
		int size = 0;
		if (CollectionUtils.isEmpty(sizes)) {
			log.info("first order ");
		} else {
			Long sizeId = sizes.get(0);
			Iteration iteration= this.iterationService.getObjectById(sizeId);
			size =iteration.getSort().intValue();
		}
		return size+3;
	}

	//新增迭代
	@RequestMapping(value = "/a/u/iteration", method = RequestMethod.POST)
	public String addIterationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Iteration iteration) throws Exception {

		if (iteration.getName() == null|| iteration.getProductId()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}
		//验证名称是否重复
		List<Long> alreadyIteration=iterationService.getIterationIdsByNameOrderBySort(iteration.getName(),0,Integer.MAX_VALUE);
		if (alreadyIteration.size()==0){
			log.info("this name is new");
		}else {
			model.addAttribute("code", -22021);
			log.info("this name is already exist");
			return "/common/success";
		}
		
		try {
			int size =this.getIterationSize();
			iteration.setSort(size);
			//新增产品默认下架
			iteration.setStatus(0);
			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			iteration.setCreateBy(Long.parseLong(userId));
			iteration.setUpdateBy(Long.parseLong(userId));

			Long iterationId=iterationService.insert(iteration);

			model.addAttribute("code", 0);
			model.addAttribute("iterationId",iterationId);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add iteration error ");
			model.addAttribute("code", -6002);
		}
		return "/common-skill-service/iteration/json/addIteration";
	}

	@RequestMapping(value = "/a/iteration/{id}", method = RequestMethod.DELETE)
	public String deleteIterationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete iteration : id= " + id);
		try {
			iterationService.delete(id);

			log.info("add iteration success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete iteration error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	//迭代列表
	@RequestMapping(value = "/a/u/iteration/search", method = RequestMethod.GET)
	public String getMultiIterationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,
										Long productId,String name,Long period,Integer status)
			throws Exception {
		log.info("name"+name+"status"+status+"page"+page+"size"+size+"productId"+productId+"time" +
				period);
		/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getIterationListParam(productId,name,period,status,false);
			log.info("paramList size =" + paramList.size());
			//获取迭代Id列表
			List<Long> iterationsIdList = iterationService.getIdsByDynamicCondition(Iteration.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getIterationListParam(productId,name,period,status,true);
			List<Long> iterationsIdCount = iterationService.getIdsByDynamicCondition(Iteration.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(iterationsIdCount)) {
				total = iterationsIdCount.get(0);
			}

			//获取迭代列表
			List<Iteration> iterationList = iterationService.getObjectsByIds(iterationsIdList);
			log.info("get  iteration data is " + iterationList);

			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("iterationList", iterationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get iteration list error");
			model.addAttribute("code", -1);
		}

		return "/common-skill-service/iteration/json/iterationListJson";
	}
	

}

