package com.ptteng.util;


import com.ptteng.common.skill.model.BranchInstitute;
import com.ptteng.common.skill.model.Occupation;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.UserService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CommonUtil {

    @Autowired
    private static UserService userService;


    @Autowired
    private static OccupationService occupationService;


    @Autowired
    private static BranchInstituteService branchInstituteService;

    private static final Log log = LogFactory.getLog(CommonUtil.class);

    public static String setUserShowName(Long uid) {
        String userNick = null;
        try {

            //无名、散修和外门展示学号，只有内门及内门以上的用户展示昵称
            //有分院展示分院，有职业展示职业
            String branch = null;
            User user=userService.getObjectById(uid);
            if (DataUtils.isNotNullOrEmpty(user.getBranch())) {
                Long userBranch = user.getBranch().longValue();
                BranchInstitute branchDetail = branchInstituteService.getObjectById(userBranch);
                branch = branchDetail.getName() + "分院|";
            }
            log.info("user branch is:" + branch);
            String userOccupationName = null;
            long userNumber = user.getStudyNumber();
            int identity = user.getIdentity();
            log.info("identity is :" + identity);
            if (!user.getOid().equals(User.Occupation_None)) {
                Long userOid = user.getOid();
                Occupation userOccupation = occupationService.getObjectById(userOid);
                userOccupationName = userOccupation.getName().toUpperCase();
            }

            //10、无名弟子 20、散修弟子 30、外门弟子 40、内门弟子  50、首席弟子  55 荣耀师兄 60、真传弟子  70、修真长老

            if (identity == User.IDENTIFY_10) {
                userNick = "["+ User.IDENTIFY_10_str+"] " + user.getNick();
            } else if (identity == User.IDENTIFY_20) {
                userNick = "["+User.IDENTIFY_20_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_30) {
                userNick = "["+User.IDENTIFY_30_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + String.valueOf(userNumber);
            } else if (identity == User.IDENTIFY_40) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_40_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_50) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_50_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_55) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_55_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            }else if (identity == User.IDENTIFY_60) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_60_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            } else if (identity == User.IDENTIFY_70) {
                userNick = "[" + (branch != null ? branch : "") + User.IDENTIFY_70_str+"] " + (userOccupationName != null ? userOccupationName : "") + "-" + user.getNick();
            }
        }catch (Throwable t) {
            log.error("error is " , t);
        }
        log.info("userNick  is:" + userNick);
        return  userNick;
    }
}
