package com.ptteng.util;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.lang.Long;
import java.lang.String;


/**
 * @ClassName: CardIdUtil
 * @CreateTime 2017年7月5日
 * @author : qinxiu
 * @Description: 卡券编号生成工具，生成规则：类型(2)+年月日时(8)+自增流水号(3)+随机码(3)
 *
 */

public class CardIdUtil {

    private static final Log log = LogFactory.getLog(DynamicUtil.class);

    /*
    * 日期8位
    * */
    private static String formateDate() {
        Long now = Long.parseLong(new SimpleDateFormat("yyMMddHH").format(new Date()));
        return Long.toString(now);
    }

    /*
    * 随机码3位
    * */
    private static String getRandom() {
        int num = (int)(Math.random() * 900) + 100;
        return Integer.toString(num);
    }

    public static String[] generateCode(Long tid, Integer count) {

        String[] codeList = new String[count];

        String type = String.format("%02d", tid);
        log.info("type id: "+ type);

        // 流水号
        for (int i = 0; i < count; i++) {
            String time = formateDate();
            String serial = String.format("%03d", i);
            String randoms = getRandom();
            codeList[i] = type + time + serial + randoms;
            log.info(codeList[i]);
        }


        return codeList;
    }


//    public static void main(String[] args) {
//        generateCode(1L, 2);
//    }

}
