package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.ptteng.util.LogUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.HttpClientUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Question  crud
 *
 * @author guchen
 * @Date 2018-01-19
 */
@Controller
public class QuestionController {
    private static final Log log = LogFactory.getLog(QuestionController.class);

    @Autowired
    private QuestionService questionService;

    @Autowired
    private LabelService labelService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private QuestionLabelRelationService questionLabelRelationService;

    @Autowired
    private AnswerService answerService;


    @Autowired
    private UserService userService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private MessageService messageService;


    /**
     * 1 新增问题
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question", method = RequestMethod.POST)
    public String addQuestionJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Question question,
                                  String labelIds) throws Exception {

        log.info("update question : question= " + question);

        if (question.getOid() == null) {
            model.addAttribute("code", -28001);
            log.info("oid is null");
            return "/common/failure";
        }

        if (question.getTid() == null) {
            model.addAttribute("code", -28002);
            log.info("tid is null");
            return "/common/failure";
        }
        if (question.getType() == null) {
            model.addAttribute("code", -28003);
            log.info("type is null");
            return "/common/failure";
        }
        if (question.getTitle() == null) {
            model.addAttribute("code", -28004);
            log.info("title is null");
            return "/common/failure";
        }
        if (question.getDescription() == null) {
            model.addAttribute("code", -28005);
            log.info("description is null");
            return "/common/failure";
        }


        try {
            question.setId(null);
            question.setStatus(Constants.STATUS_SHOW);
            question.setAdopt(Question.ADOPT_OUT);
            question.setAgreeNum(0);
            question.setIsAgree(0);
            question.setAnswerNum(0);

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            question.setCreateBy(Long.parseLong(userId));
            question.setUpdateBy(Long.parseLong(userId));

            Long id = questionService.insert(question);
            if (DataUtils.isNullOrEmpty(id)) {
                log.info("add question error ");
                model.addAttribute("code", -1);
                return "/common/failure";
            }


            List<Long> labelIdList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();

            //建立新问题标签关系
            if (StringUtils.isNotBlank(labelIds)) {
                String[] ids = labelIds.split(",");
                for (String labelId : ids) {
                    labelIdList.add(Long.valueOf(labelId));

                    QuestionLabelRelation questionLabelRelation = new QuestionLabelRelation();
                    questionLabelRelation.setQuestionId(id);
                    questionLabelRelation.setLabelId(Long.valueOf(labelId));
                    questionLabelRelation.setCreateBy(Long.parseLong(userId));
                    questionLabelRelation.setUpdateBy(Long.parseLong(userId));
                    questionLabelRelationList.add(questionLabelRelation);
                }
                labelList = labelService.getObjectsByIds(labelIdList);
                for (Label label : labelList) {
                    label.setQuestionNum(label.getQuestionNum() + 1);
                }
                labelService.updateList(labelList);
                log.info("labelList size = " + labelList.size());
                questionLabelRelationService.insertList(questionLabelRelationList);
                log.info("questionLabelRelationList size is " + questionLabelRelationList.size());
            }

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add question error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 2 获取问题详情
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question/{id}", method = RequestMethod.GET)
    public String getQuestionJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }


        try {
            Question question = questionService.getObjectById(id);
            log.info("get question data is " + question);
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error :question == null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            }


            List<Long> answerIdList = new ArrayList<>();
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();
            List<Long> questionLabelRelationIdList = new ArrayList<>();


            List<Answer> answerList = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<User> userList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();


            //获取回答列表
            Map<String, Object> answerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, null, id.toString(), Constants.STATUS_SHOW, null, null, null, null, null);
            log.info(" answerParamList size =  " + answerParamList.size());
            answerIdList = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is null ");
            } else {
                log.info(" answerIdList size =  " + answerIdList.size());
            }

            answerList = answerService.getObjectsByIds(answerIdList);

            //获取问题标签关系
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, id.toString());
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);
            }


            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelList = labelService.getObjectsByIds(labelIdList);
            }


            //更新一波answerNum
            question.setAnswerNum(answerList.size());
            boolean isUpdate = questionService.update(question);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            for (Answer answer : answerList) {
                if (answer.getCreateBy() != null) {
                    uidList.add(answer.getCreateBy());
                }
            }

            oidList.add(question.getOid());
            tidList.add(question.getTid());
            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("answerList", answerList);
            model.addAttribute("question", question);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("userList", userList);
            model.addAttribute("labelList", labelList);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get question error,id is  " + id);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/question/json/questionDetailJson";
    }

    /**
     * 3  修改问题
     *
     * @param request
     * @param response
     * @param model
     * @param question
     * @param labelIds
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question/{id}", method = RequestMethod.PUT)
    public String updateQuestionJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Question question,
                                     String labelIds, @PathVariable Long id) throws Exception {

        log.info("update question : question= " + question);

        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }

        if (question.getOid() == null) {
            model.addAttribute("code", -28001);
            log.info("oid is null");
            return "/common/failure";
        }

        if (question.getTid() == null) {
            model.addAttribute("code", -28002);
            log.info("tid is null");
            return "/common/failure";
        }
        if (question.getType() == null) {
            model.addAttribute("code", -28003);
            log.info("type is null");
            return "/common/failure";
        }
        if (question.getTitle() == null) {
            model.addAttribute("code", -28004);
            log.info("title is null");
            return "/common/failure";
        }
        if (question.getDescription() == null) {
            model.addAttribute("code", -28004);
            log.info("description is null");
            return "/common/failure";
        }


        try {
            Question oldQuestion = questionService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(oldQuestion)) {
                log.info("get oldQuestion error :oldQuestion == null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            } else {
                log.info("get oldQuestion data is " + oldQuestion);
            }

            oldQuestion.setOid(question.getOid());
            oldQuestion.setTid(question.getTid());
            oldQuestion.setType(question.getType());
            oldQuestion.setTitle(question.getTitle());
            oldQuestion.setDescription(question.getDescription());
            oldQuestion.setModules(question.getModules());


            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            oldQuestion.setUpdateBy(Long.parseLong(userId));

            boolean isUpdate = questionService.update(oldQuestion);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            List<Long> oldQuestionLabelRelationIdList = new ArrayList<>();
            List<Long> oldLabelIdList = new ArrayList<>();
            List<Long> newLabelIdList = new ArrayList<>();

            List<QuestionLabelRelation> oldQuestionLabelRelationList = new ArrayList<>();
            List<QuestionLabelRelation> newQuestionLabelRelationList = new ArrayList<>();
            List<Label> oldLabelList = new ArrayList<>();
            List<Label> newLabelList = new ArrayList<>();

            //解除旧问题标签关系
            Map<String, Object> paramList = DynamicUtil.getQuestionLabelRelationListParam(null, id.toString());
            log.info(" paramList size =  " + paramList.size());

            oldQuestionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(oldQuestionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + oldQuestionLabelRelationIdList.size());
                oldQuestionLabelRelationList = questionLabelRelationService.getObjectsByIds(oldQuestionLabelRelationIdList);

                //解除关系时更新标签下的问题数
                for (QuestionLabelRelation questionLabelRelation : oldQuestionLabelRelationList) {
                    oldLabelIdList.add(questionLabelRelation.getLabelId());
                }
                questionLabelRelationService.deleteList(QuestionLabelRelation.class, oldQuestionLabelRelationIdList);
                //通过labelIdList得到一个labelList
                oldLabelList = labelService.getObjectsByIds(oldLabelIdList);
                //更新各个标签对应的问题数
                for (Label label : oldLabelList) {
                    label.setQuestionNum(label.getQuestionNum() - 1);
                }
                boolean isUpdateOldLabel = labelService.updateList(oldLabelList);
                if (isUpdateOldLabel) {
                    log.info(" update label success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }

            }

            //建立新问题标签关系
            if (StringUtils.isNotBlank(labelIds)) {
                String[] ids = labelIds.split(",");
                for (String labelId : ids) {
                    newLabelIdList.add(Long.valueOf(labelId));
                    QuestionLabelRelation questionLabelRelation = new QuestionLabelRelation();
                    questionLabelRelation.setQuestionId(id);
                    questionLabelRelation.setLabelId(Long.valueOf(labelId));
                    questionLabelRelation.setUpdateBy(Long.parseLong(userId));
                    questionLabelRelation.setCreateBy(Long.parseLong(userId));
                    newQuestionLabelRelationList.add(questionLabelRelation);
                }
                questionLabelRelationService.insertList(newQuestionLabelRelationList);
                log.info("questionLabelRelationList size is " + newQuestionLabelRelationList.size());
                newLabelList = labelService.getObjectsByIds(newLabelIdList);
                for (Label label : newLabelList) {
                    label.setQuestionNum(label.getQuestionNum() + 1);
                }
                boolean isUpdateNewLabel = labelService.updateList(newLabelList);
                if (isUpdateNewLabel) {
                    log.info(" update label success.");
                } else {
                    model.addAttribute("code", -1);
                    return "/common/failure";
                }
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update question error,id is  " + question.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 4 隐藏/展示问题
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question/{id}/status/{status}", method = RequestMethod.PUT)
    public String updateQuestionStatusJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model,
                                           @PathVariable Long id, @PathVariable Integer status
    ) throws Exception {

        log.info("question id is: " + id + ". status is: " + status);

        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }

        if (status == null) {
            model.addAttribute("code", -28008);
            log.info("status is null");
            return "/common/failure";
        }

        try {

            Question question = questionService.getObjectById(id);
            log.info("get question data is " + question);
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error , question is null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            }

            if (status.equals(question.getStatus())) {
                model.addAttribute("code", -28009);
                return "/common/failure";
            } else {
                log.info(" question  status is different from database");
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            if (StringUtils.isEmpty(userId)) {
                log.info("get user error ");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            Manager manager = managerService.getObjectById(Long.valueOf(userId));
            log.info("get manager data is " + manager);
            if (DataUtils.isNullOrEmpty(manager)) {
                log.info("get manager error :manager == null");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            question.setStatus(status);
            Boolean isUpdate = questionService.update(question);
            if (isUpdate) {
                log.info("update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            User user = userService.getObjectById(question.getCreateBy());
            log.info("get user data is " + user);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("get user error :user == null");
                model.addAttribute("code", -5003);
                return "/common/failure";
            }

            if (status.equals(Constants.STATUS_HIDE)) {
                //发送消息给问题创建者
                sendMessageToUser(manager, user, question, Message.TEMPLATE_5);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update question error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 5 收录/取消收录问题
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param adopt
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question/{id}/adoption/{adopt}", method = RequestMethod.PUT)
    public String updateQuestionAdoptJson(HttpServletRequest request,
                                          HttpServletResponse response, ModelMap model,
                                          @PathVariable Long id, @PathVariable Integer adopt
    ) throws Exception {

        log.info("question id is: " + id + ". adopt is: " + adopt);

        if (id == null) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }

        if (adopt == null) {
            model.addAttribute("code", -28008);
            log.info("adopt is null");
            return "/common/failure";
        }

        try {

            Question question = questionService.getObjectById(id);
            log.info("get question data is " + question);
            if (DataUtils.isNullOrEmpty(question)) {
                log.info("get question error, question is null");
                model.addAttribute("code", -28006);
                return "/common/failure";
            }

            if (adopt.equals(question.getAdopt())) {
                model.addAttribute("code", -28009);
                return "/common/failure";
            } else {
                log.info(" question  adopt is different from database");
            }

            question.setAdopt(adopt);
            Boolean isUpdate = questionService.update(question);
            if (isUpdate) {
                log.info(" update success.");
            } else {
                model.addAttribute("code", -1);
                return "/common/failure";
            }

            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            if (null == userId) {
                log.info("get user error ");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            Manager manager = managerService.getObjectById(Long.valueOf(userId));
            log.info("get manager data is " + manager);
            if (DataUtils.isNullOrEmpty(manager)) {
                log.info("get manager error :manager == null");
                model.addAttribute("code", -3);
                return "/common/failure";
            }

            User user = userService.getObjectById(question.getCreateBy());
            log.info("get user data is " + user);
            if (DataUtils.isNullOrEmpty(user)) {
                log.info("get user error :user == null");
                model.addAttribute("code", -5003);
                return "/common/failure";
            }

            if (adopt.equals(Question.ADOPT_IN)) {
                //发送消息给问题创建者
                sendMessageToUser(manager, user, question, Message.TEMPLATE_4);
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update question error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    /**
     * 6 删除问题
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question", method = RequestMethod.DELETE)
    public String deleteQuestionJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Long[] id)
            throws Exception {

        if (DataUtils.isNullOrEmpty(id)) {
            model.addAttribute("code", -28007);
            log.info("id is null");
            return "/common/failure";
        }
        List<Long> list = Arrays.asList(id);
        String ids = StringUtils.join(list, ",");
        log.info("delete  : list= " + list);


        try {

            questionService.deleteList(Question.class, list);
            log.info("delete  success");

            List<Long> questionLabelRelationIdList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();
            List<Long> answerIdList = new ArrayList<>();

            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();
            List<Question> questionList = new ArrayList<>();


            //解除旧问题标签关系
            Map<String, Object> paramList = DynamicUtil.getQuestionLabelRelationListParam(null, ids);
            log.info(" paramList size =  " + paramList.size());

            questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, paramList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);
                questionLabelRelationService.deleteList(QuestionLabelRelation.class, questionLabelRelationIdList);
            }


            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelList = labelService.getObjectsByIds(labelIdList);
            }

            //更新标签问题数
            for (Label label : labelList) {
                if (label.getQuestionNum() > 0) {
                    label.setQuestionNum(label.getQuestionNum() - 1);
                }
            }
            labelService.updateList(labelList);


            //问题下的回答一并删除
            Map<String, Object> answerParamList = DynamicUtil.getAnswerListParam(null, null, null, null, null, ids, null, null, null, null, null, null);
            log.info(" answerParamList size =  " + paramList.size());
            //获取list
            answerIdList = answerService.getIdsByDynamicCondition(Answer.class, answerParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(answerIdList)) {
                log.info(" answerIdList is null ");
            } else {
                log.info(" answerIdList size =  " + answerIdList.size());
                answerService.deleteList(Answer.class, answerIdList);
                log.info("delete  success");
            }

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete  error,list is  " + list);
            model.addAttribute("code", -1);

        }
        return "/common/success";
    }


    /**
     * 7 搜索问题列表
     *
     * @param request
     * @param response
     * @param model
     * @param id
     * @param oid
     * @param tid
     * @param uid
     * @param type     type 1-用户点赞(配合参数uid) 2-用户创建(配合参数createBy)
     * @param status
     * @param adopt
     * @param createBy
     * @param title
     * @param labelIds
     * @param orderBy
     * @param sort
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/question/search", method = RequestMethod.GET)
    public String searchQuestionList(
            HttpServletRequest request, HttpServletResponse response, ModelMap model,
            Long id, Long oid, Long tid, Long uid, Integer type,
            Integer status, Integer adopt, Long createBy, String title, String labelIds,
            Integer orderBy, Integer sort,
            Integer page, Integer size)
            throws Exception {

        //打印入参
        log.info("============================================");
        String paramStr = LogUtil.convertParam("/a/u/question/search  by==id", id, "oid", oid, "tid", tid, "uid", uid, "type", type,
                "status", status, "adopt", adopt, "createBy", createBy, "title", title, "labelIds", labelIds,
                "orderBy", orderBy, "sort", sort, "page", page, "size", size);
        log.info(paramStr);

        //初始化page size start
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        String pageStr = LogUtil.convertParam("page", page, "start", start, "size", size);
        log.info(pageStr);

        try {
            //初始值
            List<Long> oidList = new ArrayList<>();
            List<Long> tidList = new ArrayList<>();
            List<Long> questionIdList = new ArrayList<>();
            List<Long> labelIdList = new ArrayList<>();
            List<Long> questionLabelRelationIdList = new ArrayList<>();
            List<Long> uidList = new ArrayList<>();

            List<Occupation> occupationList = new ArrayList<>();
            List<Task> taskList = new ArrayList<>();
            List<Question> questionList = new ArrayList<>();
            List<QuestionLabelRelation> questionLabelRelationList = new ArrayList<>();
            List<Label> labelList = new ArrayList<>();
            Map<Long, QuestionLabelRelation> questionId_questionLabelRelation = new HashMap();
            List<User> userList = new ArrayList<>();

            //获取问题列表
            Map<String, Object> paramList = DynamicUtil.getQuestionListParam(id, oid, tid, uid, type, status, adopt, createBy, title, labelIds, orderBy, sort);
            log.info(" paramList size =  " + paramList.size());
            //获取list
            questionIdList = questionService.getIdsByDynamicCondition(Question.class, paramList, start, size);
            if (CollectionUtils.isEmpty(questionIdList)) {
                log.info(" questionIdList is null ");
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
                return "/common-skill-service/question/json/questionListJson";
            } else {
                log.info(" questionIdList size =  " + questionIdList.size());
            }
            //获取total
            List<Long> allQuestion = questionService.getIdsByDynamicCondition(Question.class, paramList, 0, Integer.MAX_VALUE);
            log.info("total is:" + allQuestion.size());


            //获取问题标签关系
            String questionIds = StringUtils.join(questionIdList, ",");
            Map<String, Object> questionLabelRelationLisParamList = DynamicUtil.getQuestionLabelRelationListParam(null, questionIds);
            log.info(" questionLabelRelationLisParamList size =  " + questionLabelRelationLisParamList.size());

            questionLabelRelationIdList = questionLabelRelationService.getIdsByDynamicCondition(QuestionLabelRelation.class, questionLabelRelationLisParamList, 0, Integer.MAX_VALUE);
            if (CollectionUtils.isEmpty(questionLabelRelationIdList)) {
                log.info(" questionLabelRelationIdList is null ");
            } else {
                log.info(" questionLabelRelationIdList size =  " + questionLabelRelationIdList.size());
                questionLabelRelationList = questionLabelRelationService.getObjectsByIds(questionLabelRelationIdList);

            }
            //一一映射
            questionId_questionLabelRelation = MyListUtil.convert2ListMap(QuestionLabelRelation.class.getDeclaredField("questionId"), questionLabelRelationList);
            log.info(questionId_questionLabelRelation);
            for (QuestionLabelRelation questionLabelRelation : questionLabelRelationList) {
                if (questionLabelRelation.getLabelId() != null) {
                    labelIdList.add(questionLabelRelation.getLabelId());
                }
            }

            //获取相关list
            questionList = questionService.getObjectsByIds(questionIdList);
            for (Question question : questionList) {
                if (question.getOid() != null) {
                    oidList.add(question.getOid());
                }
                if (question.getTid() != null) {
                    tidList.add(question.getTid());
                }
                if (question.getCreateBy() != null) {
                    uidList.add(question.getCreateBy());
                }


            }

            if (CollectionUtils.isEmpty(labelIdList)) {
                log.info(" labelIdList is null ");
            } else {
                log.info(" labelIdList size =  " + labelIdList.size());
                labelList = labelService.getObjectsByIds(labelIdList);
            }

            if (CollectionUtils.isEmpty(oidList)) {
                log.info(" oidList is null ");
            } else {
                log.info(" oidList size =  " + oidList.size());
                occupationList = occupationService.getObjectsByIds(oidList);
            }

            if (CollectionUtils.isEmpty(tidList)) {
                log.info(" tidList is null ");
            } else {
                log.info(" tidList size =  " + tidList.size());
                taskList = taskService.getObjectsByIds(tidList);
            }

            if (CollectionUtils.isEmpty(uidList)) {
                log.info(" uidList is null ");
            } else {
                log.info(" uidList size =  " + uidList.size());
                userList = userService.getObjectsByIds(uidList);
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", questionList.size());
            model.addAttribute("total", allQuestion.size());
            model.addAttribute("questionList", questionList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("taskList", taskList);
            model.addAttribute("labelList", labelList);
            model.addAttribute("userList", userList);
            model.addAttribute("questionLabelRelationList", questionLabelRelationList);
            model.addAttribute("questionId_questionLabelRelation", questionId_questionLabelRelation);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get label list error,page is " + page + " , size " + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/question/json/questionListJson";
    }

    /**
     * 发送消息给回答创建者
     *
     * @param manager
     * @param user
     * @param question
     * @param template
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public void sendMessageToUser(Manager manager, User user, Question question, Integer template) throws ServiceException, ServiceDaoException {

        log.info(" sendMessageToUser start ");

        //创建消息
        String content = template.toString();

        Message message = new Message();

        message.setSendId(manager.getId());
        message.setReceiveId(user.getId());
        message.setReceiveName(user.getNick());
        message.setSendName(manager.getNick());
        message.setContent(content);
        message.setStatus(Message.STATUS_UNDELETE);
        message.setUnread(Message.Status_Unread);
        message.setType(Message.QUESTION_TYPE);
        message.setRelationId(question.getId());
        message.setTemplate(template);
        message.setCreateBy(manager.getId());
        message.setUpdateBy(manager.getId());

        messageService.insert(message);

        //发送
        adminSend(user.getMobile(), content);

        //更新个人消息未读数
        Integer unLook = user.getIsLook() + 1;
        user.setIsLook(unLook);
        user.setLatestMsg(Message.QUESTION_TYPE);
        userService.update(user);
    }

    //发送信息，手机号+内容
    public static String adminSend(String mobile, String content) {
        String param = "{\n" +
                "    \"target_type\" : \"users\", \n" +
                "    \"target\" : [\"" + mobile + "\"],   \n" +
                "                                   \n" +
                "                                   \n" +
                "    \"msg\" : {\n" +
                "        \"type\" : \"txt\",\n" +
                "        \"msg\" : \"" + content + "\" \n" +
                "        },\n" +
                "    \"from\" : \"admin\"\n" +
                "}";
        String result = HttpClientUtil.sendPostRequestByJavaSetHeader("https://a1.easemob.com/jnshu4/jnshu4/messages", param, "application/json", "Bearer YWMtwJlMnN7iEeW93dWWI_R-hgAAAVRiEFRny8NEKnIG6-Gu_yibQ4d46AkTlmM");
        log.info(result);
        return result;
    }

}

