package com.ptteng.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Project  crud
 * 
 * @author magenm
 * @Date 2014-4-16 13:43
 * 
 */
@Controller
public class ProjectController {
	private static final Log log = LogFactory.getLog(ProjectController.class);

	@Autowired
	private ProjectService projectService;
	@Autowired
	private TeamService teamService;
	@Autowired
	private ProductService producService;
	@Autowired
	private IterationService iterationService;
	@Autowired
	private CookieUtil cookieUtil;
	@Autowired
	private UserService userService;
	@Autowired
	private RoleService roleService;
	@Autowired
	private ManagerService managerService;
	@Autowired
	private UserTeamRelationService userTeamRelationService;



	//项目详情
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.GET)
	public String getProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		if (id==null){
			log.info("iteration id cannot be null");
			model.addAttribute("code", -22002);
		}
		try {
			Project project = projectService.getObjectById(id);
//			log.info("get project data is " + project);

			model.addAttribute("code", 0);

			model.addAttribute("project", project);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get project error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/project/json/projectDetailJson";
	}


	//编辑项目、更改项目状态//////
	// status：0未开始，1进行中，2完成，3延期，4中止
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.PUT)
	public String updateProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,@PathVariable Long id, Project project) throws Exception {

		log.info("update project : project= " + project);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		Project oldProject=projectService.getObjectById(id);
		if (oldProject == null) {
			model.addAttribute("code", -22012);
			log.info("this project does not exist");
			return "/common/success";
		}
		if (project.getTid() == null|| project.getName()==null|| project.getProductId()==null
				|| project.getIterationId()==null|| project.getStatus()==null|| project.getDailyNums()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}


		try {
			//将修改数据的人记录进数据库
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			project.setUpdateBy(Long.parseLong(userId));
			//将创建数据记录进数据库
			project.setCreateAt(oldProject.getCreateAt());
			project.setCreateBy(oldProject.getCreateBy());

			//更新迭代数据
			Iteration iteration = iterationService.getObjectById(project.getIterationId());
			//进行中人数
			int goingUsers=iteration.getGoingUsers();
			//进行中项目数
			int goingProjects=iteration.getGoingProjects();
			//完成人数
			int doneUsers=iteration.getDoneUsers();
			//完成项目数
			int doneProjects=iteration.getDoneProjects();
			//平均开发时长
			int avg=iteration.getAvgPeriod();
			//实际总开发时长
			int totalPeriod=iteration.getTotalPeriod();


			//获取小组人数
			Team team = teamService.getObjectById(project.getTid());
			int teamNums = team.getNums();

			//修改前的状态
			int oldStatus = oldProject.getStatus();
			//修改后的状态
			int newStatus = project.getStatus();

			//项目是未开始时，不能直接选择延期、完成、中止状态
			if (oldStatus==0){
				if (newStatus==3){
					model.addAttribute("code", -22033);
					log.info("项目未开始，不能选择延期状态");
					return "/common/success";
				}
				if (newStatus==2){
					model.addAttribute("code", -22034);
					log.info("项目未开始，不能选择完成状态");
					return "/common/success";
				}
				if (newStatus==4){
					model.addAttribute("code", -22035);
					log.info("项目未开始，不能选择中止状态");
					return "/common/success";
				}
			}

			//点了完成，就不能再选择未开始、进行中、延期、中止状态
			if (oldStatus==2){
				if (newStatus==0){
					model.addAttribute("code", -22022);
					log.info("项目已完成，就不能再选择未开始");
					return "/common/success";
				}
				if (newStatus==1){
					model.addAttribute("code",-22023);
					log.info("项目已完成，无法重新开始");
					return "/common/success";
				}
				if (newStatus==3){
					model.addAttribute("code",-22024);
					log.info("项目已完成，无法延期");
					return "/common/success";
				}
				if (newStatus==4){
					model.addAttribute("code",-22025);
					log.info("项目已完成，无法中止");
					return "/common/success";
				}
			}
			//点了进行中，就不能再选择未开始的状态
			if (oldStatus==1){
				if (newStatus==0){
					model.addAttribute("code",-22026);
					log.info("项目进行中，无法重新选择未开始状态");
					return "/common/success";
				}
			}
			//点了延期，就不能再选择未开始、进行中
			if (oldStatus==3){
				if (newStatus==0){
					model.addAttribute("code",-22027);
					log.info("项目延期了，无法重新选择未开始状态");
					return "/common/success";
				}
				if (newStatus==1){
					model.addAttribute("code",-22028);
					log.info("项目延期了，无法重新开始");
					return "/common/success";
				}
			}
			//点了中止，就不能再选择延期、完成
			if (oldStatus==4){
				if (newStatus==3){
					model.addAttribute("code",-22029);
					log.info("项目中止了，无法延期");
					return "/common/success";
				}
				if (newStatus==2){
					model.addAttribute("code",-22030);
					log.info("项目中止了，无法设置完成");
					return "/common/success";
				}
			}
			//如果status的新旧值没有发生改变，不进行迭代统计数据的变动
			if (oldProject.getStatus().intValue()==project.getStatus().intValue()){
				log.info("status has not change");
			}else  {
				//进行中
				if (newStatus == 1) {
					iteration.setGoingUsers(goingUsers + teamNums);
					iteration.setGoingProjects(goingProjects + 1);
					//第一次选择此状态记录记录项目开始时间
					if (project.getStartAt() == null) {
						project.setStartAt(System.currentTimeMillis());
					}
				}
				//中止
				if (newStatus == 4) {
					iteration.setGoingUsers(goingUsers - teamNums);
					iteration.setGoingProjects(goingProjects - 1);
				}
				//完成
				if (newStatus == 2) {
					iteration.setGoingUsers(goingUsers - teamNums);
					iteration.setGoingProjects(goingProjects - 1);
					iteration.setDoneUsers(doneUsers + teamNums);
					iteration.setDoneProjects(doneProjects + 1);

					//获取新的完成项目数
					int newDoneProjects = iteration.getDoneProjects();

					//每次选择此状态都记录项目完成时间
					project.setEndAt(System.currentTimeMillis());
//					log.info("启动时间："+oldProject.getStartAt()+"完成时间:"+project.getEndAt());
					Long realTime =  project.getEndAt()-oldProject.getStartAt();
					iteration.setTotalPeriod(totalPeriod + realTime.intValue()/1000);
					if (newDoneProjects != 0) {
						avg = (totalPeriod + realTime.intValue()) / newDoneProjects;
						iteration.setAvgPeriod(avg);
					}

				}
			}

			iterationService.update(iteration);

			projectService.update(project);

			model.addAttribute("code", 0);

			model.addAttribute("project", project);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update project error,id is  " + project.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//新增项目
	@RequestMapping(value = "/a/u/project", method = RequestMethod.POST)
	public String addProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Project project) throws Exception {

		if (project.getTid() == null|| project.getName()==null||project.getProductId()==null||
				project.getIterationId()==null) {
			model.addAttribute("code", -1000);
			log.info("param is null");
			return "/common/success";
		}

		Team team = teamService.getObjectById(project.getTid());
		if (DataUtils.isNullOrEmpty(team)) {
			log.info(" team is not exist");
			model.addAttribute("code", -22009);
			return "/common/success";
		}
		Product product = producService.getObjectById(project.getProductId());
		if (DataUtils.isNullOrEmpty(product)) {
			log.info(" product is not exist");
			model.addAttribute("code", -22010);
			return "/common/success";
		}
		Iteration iteration = iterationService.getObjectById(project.getIterationId());
		if (DataUtils.isNullOrEmpty(iteration)) {
			log.info(" team is not exist");
			model.addAttribute("code", -22011);
			return "/common/success";
		}
		//验证名称是否重复
		List<Long> alreadyProject=projectService.getProjectIdsByNameOrderByCreateAt(project.getName(),0,Integer.MAX_VALUE);
		if (alreadyProject.size()==0){
			log.info("this name is new");
		}else {
			model.addAttribute("code", -22021);
			log.info("this name is already exist");
			return "/common/success";
		}
		//验证是否是做过的项目
		Map<String, Object> params = DynamicUtil.getDoneProjects(project.getTid(),project.getIterationId());
		log.info("搜索结果 is"+params);
		List<Long> doneProjectIdList = projectService.getIdsByDynamicCondition(Project.class,params,0, Integer.MAX_VALUE);
//		List<Long> doneProject=projectService.getProjectIdsByIterationIdOrderByCreateAt(project.getIterationId(),0,Integer.MAX_VALUE);
		if (doneProjectIdList.size()==0){
			log.info("this project is new");
		}else {
			model.addAttribute("code", -22032);
			log.info("this project is already done");
			return "/common/success";
		}
		try {
			//验证该小组是否有未完成的项目
			List<Long> doneProjectIds=projectService.getProjectIdsByTidAndStatusOrderByCreateAt(project.getTid(),2,0,Integer.MAX_VALUE);
			List<Long> goingProjectIds = projectService.getProjectIdsByTidOrderByCreateAt(project.getTid(),0,Integer.MAX_VALUE);
			if (doneProjectIds.size()==goingProjectIds.size()){
				log.info("该小组所有创建项目都已完成，可以创建新的项目");
			}else {
				model.addAttribute("code", -22031);
				log.info("有未完成的项目，请先完成在做的项目再创建新的项目");
				return "/common/success";
			}

			//记录更改数据的操作者
			String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			project.setCreateBy(Long.parseLong(userId));
			project.setUpdateBy(Long.parseLong(userId));
			//默认晨报数为0
			project.setDailyNums(0);
			//新建项目默认是未开始状态
			project.setStatus(0);

			Long pid=projectService.insert(project);

			model.addAttribute("code", 0);
			model.addAttribute("pid", pid);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add project error ");
			model.addAttribute("code", -6002);
		}

		return "/common-skill-service/project/json/addProject";
	}

	//删除项目
	@RequestMapping(value = "/a/u/project/{id}", method = RequestMethod.DELETE)
	public String deleteProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete project : id= " + id);
		if (id == null) {
			model.addAttribute("code", -18007);
			log.info("id is null");
			return "/common/success";
		}
		try {
			Project project = projectService.getObjectById(id);
			if (DataUtils.isNullOrEmpty(project)) {
				log.info(" delete project error :project == null");
				model.addAttribute("code", -22012);
				return "/common/success";
			}
			projectService.delete(id);

			log.info("add project success");
			model.addAttribute("code", 0);
			//判断项目状态，更新迭代数据
			Iteration iteration = iterationService.getObjectById(project.getIterationId());
			//进行中人数
			int goingUsers=iteration.getGoingUsers();
			//进行中项目数
			int goingProjects=iteration.getGoingProjects();
			//获取小组人数
			Team team = teamService.getObjectById(project.getTid());
			int teamNums = team.getNums();

			int status = project.getStatus();
			if (status==1||status==3){
				iteration.setGoingUsers(goingUsers - teamNums);
				iteration.setGoingProjects(goingProjects - 1);
			}
			iterationService.update(iteration);

			//组员、用户关系表值重置
			List<Long> userIds = new ArrayList();
			List<Long> memberIds = userTeamRelationService.getUserTeamRelationIdsByTidOrderByCreateAt(project.getTid(),0,Integer.MAX_VALUE);
			int memberSize=memberIds.size();
			for (int i=0;i<memberSize;i++){
				UserTeamRelation member = userTeamRelationService.getObjectById(memberIds.get(i));
				//清空用户表中关系字段
				User user = userService.getObjectById(member.getUid());
				user.setUserTeamId("-1");
				userService.update(user);
			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete project error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	//项目列表
	@RequestMapping(value = "/a/u/project/search", method = RequestMethod.GET)
	public String getMultiProjectJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page, Integer size,
									  Long tid ,String name,String productName,String iterationName,
									  Long startAt,Long endAt,Long finishStartAt,Long finishEndAt,
									  Long createBy,Long sid,Long status,Long createStartAt,Long createEndAt)
			throws Exception {
			/* 1 默认分页 */
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			//初始值
			Long total =0L;
			//动态查询
			Map<String,Object> paramList = DynamicUtil.getProjectsListParam(tid ,name,productName,iterationName, startAt,
					endAt,finishStartAt,finishEndAt, createBy,sid,status,createStartAt,createEndAt,false);
			log.info("paramList size =" + paramList.size());
			//获取项目Id列表
			List<Long> projectsIdList = projectService.getIdsByDynamicCondition(Project.class,paramList,start,size);
			//获取total
			Map<String,Object> paramCount = DynamicUtil.getProjectsListParam(tid ,name,productName,iterationName, startAt,
					endAt,finishStartAt,finishEndAt, createBy,sid,status,createStartAt,createEndAt,true);
			List<Long> projectsIdCount = projectService.getIdsByDynamicCondition(Project.class,paramCount, 0, Integer.MAX_VALUE);
			if (CollectionUtils.isNotEmpty(projectsIdCount)) {
				total = projectsIdCount.get(0);
				log.info("项目列表总数"+total);
			}
			//获取项目列表
			List<Project> projectList = projectService.getObjectsByIds(projectsIdList);
			log.info("get  project data is " + projectList.size());
			//获取创建者id列表
			List<Long> managerIds=new ArrayList();

			int projectSize=projectList.size();
			for (int i=0;i<projectSize;i++){
				managerIds.add(projectList.get(i).getCreateBy());
			}
			//获取管理者列表
			List<Manager> managerList = managerService.getObjectsByIds(managerIds);


			model.addAttribute("code", 0);
			model.addAttribute("total",total);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("projectList", projectList);
			model.addAttribute("managerList", managerList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get project list error");
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/project/json/projectListJson";
	}
}

