package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.skill.model.Manager;
import com.ptteng.common.skill.model.Order;
import com.ptteng.common.skill.model.User;
import com.ptteng.common.skill.service.OrderService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.jws.soap.SOAPBinding;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Order  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 *
 */
@Controller
public class OrderController {
	private static final Log log = LogFactory.getLog(OrderController.class);

	@Autowired
	private OrderService orderService;



	@Autowired
	private UserService userService;


    /**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */

		@RequestMapping(value = "/a/u/order ", method = RequestMethod.GET)
	public String getOrderIdsByBuyerJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Integer type,String mobile,Integer status,Long startTime,Long endTime,String name) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids = new ArrayList<>();

			Map<String, Object> param = DynamicUtil.getOrdertListParam(type, mobile, status, startTime, endTime,name, false);

            log.info("the order params is"+param);


			ids= orderService.getIdsByDynamicCondition(Order.class,param,start,size);

//			List<Long> ids= orderService.getOrderIds(start, size);
		log.info("get countOrderIdsByBuyer size is " + ids.size());

			List<Order> orderList = orderService.getObjectsByIds(ids);
			log.info("get order data is " + orderList.size());

			Integer total = orderService. countOrderIds();
			log.info("get order count is " + total);


			// 获取用户id
			List<Long> userids = new ArrayList<>();
			for (Order order:orderList){

				userids.add(order.getBuyer());

			}
			List<User> userList = userService.getObjectsByIds(userids);
			HashMap userHash = new HashMap();

           for (User user :userList){

			   userHash.put(user.getId(),user.getNick());

		   }


            model.addAttribute("userHash",userHash);
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/order/json/orderListJson";
	}







	@RequestMapping(value = "/a/u/order/{oid}", method = RequestMethod.GET)
	public String getOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable String oid)
			throws Exception {

		log.info("get data : id= " + oid);
		try {

			Order order = orderService.getObjectByOrderId(oid);
			log.info("get order data is " + order);

			if (order != null){

				model.addAttribute("code", 0);

				model.addAttribute("order", order);
			}else {

				model.addAttribute("code",-14002);
				return "/data/json";

			}

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get order error,id is  " + oid);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/order/json/orderDetailJson";
	}

	@RequestMapping(value = "/a/u/order/{id}", method = RequestMethod.PUT)
	public String updateOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Order order) throws Exception {

		log.info("update order : order= " + order);
		Manager manager = (Manager)request.getAttribute("manager");
		try {
			////记录操作人
			order.setUpdateBy(manager.getId());
			orderService.update(order);

			model.addAttribute("code", 0);

			model.addAttribute("order", order);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update order error,id is  " + order.getId());
			model.addAttribute("code", -6003);

		}
		return "/data/json";
	}

	@RequestMapping(value = "/a/u/order", method = RequestMethod.POST)
	public String addOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Order order) throws Exception {

		log.info("update order : order= " + order);

		try {
			order.setId(null);

			Long id = orderService.insert(order);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add order error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/a/u/order/{id}", method = RequestMethod.DELETE)
	public String deleteOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete order : id= " + id);
		try {
			orderService.delete(id);

			log.info("add order success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete order error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}


	@RequestMapping(value = "/web/a/multi/order", method = RequestMethod.GET)
	public String getMultiOrderJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<Order> orderList = orderService.getObjectsByIds(idList);
			log.info("get  order data is " + orderList.size());

			model.addAttribute("code", 0);
			model.addAttribute("total",orderList.size());

			model.addAttribute("orderList", orderList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get order error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-skill-service/order/json/orderListJson";
	}


}

