package com.ptteng.controller;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.StringUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.*;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Created by asus on 2015/10/27.
 */
@Controller
public class ClassesController {
    private static final Log log = LogFactory.getLog(ClassesController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private ArticleService articleService;

    @Autowired
    private ConstantService  constantService;



    @Autowired
    private ClassesService classesService;

    @Autowired
    private OccupationService occupationService;

    @Autowired
    private UserClassRelationService userClassRelationService;

    @Autowired
    private ArticleTaskRelationService articleTaskRelationService;
    @Autowired
    private TeacherService teacherService;
    @Autowired BranchInstituteService branchInstituteService;

    /**
     * @param
     * @return
     */

    //20.获取班级详情
    @RequestMapping(value = "/a/u/class/detail", method = RequestMethod.GET)
    public String classesDetail(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Long[] cid) throws Exception {


        log.info("============================================");
        log.info("cid is " + cid);

        List<Long> cidList = new ArrayList();
        List<Classes> classesList = new ArrayList();
        Map<Long, List<User>> cid_userList = new HashMap<>();
        Map<Long, String> cid_img = new HashMap<>();

        try {
            if (cid == null) {
                log.info("not get any data ");
                model.addAttribute("code", -1004);
                return "/common/success";

            } else {
                cidList = Arrays.asList(cid);
                log.info(cidList + " want get detail info ");
                classesList = classesService.getObjectsByIds(cidList);
                log.info("get classes data is " + classesList.size());
            }

            Map<Long, Map<Long, Long>> cid_numMap = userClassRelationService.getUidNumRelationListByCids(cidList, 0, Integer.MAX_VALUE);
            log.info("uid_Map is "+cid_numMap);

            Map<Long, Map<Long, String>> cid_swearMap = userClassRelationService.getUidSwearRelationListByCids(cidList, 0, Integer.MAX_VALUE);
            log.info("uid_Map is "+cid_swearMap);

            Map<Long,String> cid_qq = new HashMap<>();
            Map<Long,String> cid_thumb = new HashMap<>();
            Map<Long,Map<Long,Integer>> cid_uid_status = new HashMap<>();

            for (Classes classes : classesList) {
                List<User> userList = new ArrayList<>();
                Long classesID = classes.getId();
                Long oid = classes.getOid();
                Long leaderId = classes.getLeader();
                if(leaderId!=null) {
                    User user = userService.getObjectById(leaderId);
                    cid_qq.put(classesID,user.getQq());
                    cid_thumb.put(classesID,user.getThumb());
                }else{
                    cid_qq.put(classesID,null);
                    cid_thumb.put(classesID,null);
                }

                HashMap<Long,Integer> uid_status = new HashMap<>();
                Occupation occupation = occupationService.getObjectById(oid);
                String img = occupation.getImg();
                cid_img.put(classesID,img);
                List<Long> relationList = userClassRelationService.getUserClassRelationIdsByCid(classesID, 0, Integer.MAX_VALUE);
                log.info("relationList is " + relationList);
                for (Long relationId : relationList) {
                    UserClassRelation relation = userClassRelationService.getObjectById(relationId);
                    Integer status = relation.getStatus();
                    Long uid = relation.getUid();
                    log.info("uid is "+uid);
                    User user = userService.getObjectById(uid);
                    uid_status.put(uid,status);
                    userList.add(user);
                }
                cid_uid_status.put(classesID,uid_status);
                cid_userList.put(classesID, userList);
                log.info("cid_userList get over" + classesID);
                DynamicUtil.checkUserGraduateStatus(userList);
            }
            log.info("cid_userList" + cid_userList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", classesList.size());
            model.addAttribute("cid_uid_status",cid_uid_status);
            model.addAttribute("cid_qq",cid_qq);
            model.addAttribute("cid_thumb",cid_thumb);
            model.addAttribute("classesList", classesList);
            model.addAttribute("cid_numMap",cid_numMap);
            model.addAttribute("cid_swearMap",cid_swearMap);
            model.addAttribute("cid_img",cid_img);
            model.addAttribute("cid_userList", cid_userList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classes error,id is  " + cidList);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/classesDetailJson";
    }


    /**
     * @param
     * @return
     */

    //21.后台获取班级列表
    @RequestMapping(value = "/a/u/class/list", method = RequestMethod.GET)
    public String classesList(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, Long occupation, String name, String type,
                              Integer branch,Long startAt,Long endAt,
                              Integer page, Integer size) throws Exception {


        log.info("get  /a/u/class/list ============================================");
        log.info("occupation is " + occupation + " name is " + name + "type is " + type + " page is " + page + " size is " + size+" " +
                " branch = "+branch+" startAt = "+startAt+" endAt = "+endAt);

        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        int end = start + size - 1;

        try {
            List<Classes> classesList = new ArrayList<>();
            List<BranchInstitute> branches = new ArrayList<>();
           Set<Long> oids = new HashSet<>();
           List<Long> branchIds = new ArrayList<>();
            List<Occupation> occupationList = new ArrayList<>();
            Map<String, Object> param = DynamicUtil.getClassListParam(occupation, name, type, branch, startAt, endAt, false);
            List<Long> ids = classesService.getIdsByDynamicCondition(Classes.class, param, start, size);

            if(CollectionUtils.isEmpty(ids)){
                log.info(" ids is null ");
            }else {
                log.info(" class ids size = "+ids.size());
                classesList = classesService.getObjectsByIds(ids);
                for(Classes classes : classesList){
                    oids.add(classes.getOid());
                    if (classes.getBranch() !=null) {
                        branchIds.add(classes.getBranch().longValue());
                    }else {
                        log.info("This classes branch is null , id is " + classes.getId());
                    }
                }
                occupationList = occupationService.getObjectsByIds(new ArrayList<Long>(oids));
                log.info("branches size is " + branchIds.size());
                branches = branchInstituteService.getObjectsByIds(branchIds);
            }




            Map<String, Object> cntParam = DynamicUtil.getClassListParam(occupation, name, type,branch,startAt,endAt,true);
            Long totalSize = classesService.getIdsByDynamicCondition(Classes.class, cntParam, 0, Integer.MAX_VALUE).get(0);

            Boolean next = true;
            if (end + 1 > totalSize) {
                next = false;
            }

            model.addAttribute("total", totalSize);
            Long totalPage = (((totalSize - 1)) / (size)) + 1;
            model.addAttribute("classesList", classesList);
            model.addAttribute("occupationList", occupationList);
            model.addAttribute("totalPage", totalPage);
            model.addAttribute("branches", branches);

            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("next", next);
            model.addAttribute("code", 0);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get classes error, occupation is " + occupation + " name is " + name + "type is " + type + " page is " + page + " size is " + size);
            model.addAttribute("code", -1);
        }

        return "/common-skill-service/classes/json/classesListJson";
    }

    /**
     * @param
     * @return
     */

    //22.新增班级
    @RequestMapping(value = "/a/u/class", method = RequestMethod.POST)
    public String addClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                             String name, Long occupation, Long qq, Long grade, String type,Integer branch) throws Exception {


        log.info("============================================");
        Manager manager = (Manager)request.getAttribute("manager");

        log.info("new classes name is " + name + " occupation is " + occupation + "type is " + type+" branch = "+branch);

        if (StringUtil.isEmpty(name) || null == occupation || null == qq ||
                (!(type.equals(Classes.Type_Online)) && (!type.equals(Classes.Type_Offline))&&(!type.equals(Classes.Type_Outline)))) {
            model.addAttribute("code", -1004);
            log.info("name and occupation is null");
            return "/common/success";
        }
        //获取职业信息
        Occupation occupation1 = occupationService.getObjectById(occupation);
        log.info("occupation is : "+occupation1);
        /**
         * 如果新增内门(线下)班级,分院信息必填
         */
        if(Classes.Type_Offline.equals(type)){
            if(DataUtils.isNullOrEmpty(branch)){
                model.addAttribute("code",-9006);
                log.info("wrong branch");
                return "/common/success";
            }
        }
//        /*校验该班号是否已存在*/
//        List<Long> oldClassesIds =    classesService.getClassesIdsByOidAndNameAndType(occupation,name,type,0,1);
//        if(CollectionUtils.isNotEmpty(oldClassesIds)){
//            log.info(" classes num is exit ");
//            model.addAttribute("code",-9008 );
//            return "/common/success";
//        }
        /*校验班号是否是最新班号*/
//       oldClassesIds =  classesService.getClassesIdsByOidAndType(occupation,type,0,1);
//        if(CollectionUtils.isEmpty(oldClassesIds)){
//
//        }else {
//            Integer num = Integer.valueOf(name);
//            num = num-1;
//            Classes classes =  classesService.getObjectById(oldClassesIds.get(0));
//            if(num.toString().equals(classes.getName())){
//                log.info(" classes num is right ");
//            }else {
//                model.addAttribute("code",-9007);
//                log.info("wrong classes num");
//                return "/common/success";
//            }
//        }

        if (Classes.Type_Online.equals(type)) {
            //获取线上期数
            Long grade_count = occupation1.getOnlineGradeCount();
            if ((!(grade.equals(grade_count))&&(!grade.equals(grade_count + 1)))) {
                model.addAttribute("code", -9004);
                log.info("wrong grade");
                return "/common/success";
            }
            //线上班级总数和所有班级总数均+1
            Long class_count = occupation1.getClassCount();
            Long onlineClassesCount = occupation1.getOnlineClassCount();
            onlineClassesCount = onlineClassesCount + 1;
            class_count = class_count + 1;
            occupation1.setClassCount(class_count);
            occupation1.setOnlineClassCount(onlineClassesCount);

            if (grade.equals(grade_count + 1)) {
                occupation1.setOnlineGradeCount(grade);
            }
            occupationService.update(occupation1);
        }else{
            Long grade_count = occupation1.getOfflineGradeCount();
            if ((!(grade.equals(grade_count))&&(!grade.equals(grade_count + 1)))) {
                model.addAttribute("code", -9004);
                log.info("wrong grade");
                return "/common/success";
            }
            Long class_count = occupation1.getClassCount();
            Long offlineClassesCount = occupation1.getOfflineClassCount();
            offlineClassesCount = offlineClassesCount + 1;
            class_count = class_count + 1;
            occupation1.setClassCount(class_count);
            occupation1.setOfflineClassCount(offlineClassesCount);

            if (grade.equals(grade_count + 1)) {
                occupation1.setOfflineGradeCount(grade);
            }
            occupationService.update(occupation1);
        }

        try {
            Classes classes = new Classes();
            classes.setStatus(0L);
            classes.setGrade(grade);
            classes.setName(name);
            classes.setOid(occupation);
            classes.setTotal(0L);
            classes.setQq(qq);
            classes.setType(type);
            classes.setBranch(branch);
            classes.setCreateBy(manager.getId());
            classes.setUpdateBy(manager.getId());
            Long cid = classesService.insert(classes);

            Long constantID = this.constantService.getConstantIdByTypeAndName(Constant.Type_Statistics, Constant.Name_ClassCount);
            if(constantID==null){
                log.error(" not statistics class Count ,check constant "+Constant.Type_Statistics+" name is "+Constant.Name_ClassCount);
            }else{
                Constant constant= this.constantService.getObjectById(constantID);
                log.info(" constant is "+constant );
                Integer classCount=Integer.valueOf(constant.getValue())+1;



                constant.setValue(classCount.toString());
                this.constantService.update(constant);
                log.info(" update class count success ");

            }


            model.addAttribute("code", 0);
            model.addAttribute("cid", cid);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add classes error,name is  " + name + " and occupation is " + occupation);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    /**
     * @param
     * @return
     */

    //23.修改班级
    @RequestMapping(value = "/a/u/class/{cid}", method = RequestMethod.PUT)
    public String updateClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                String name, Long qq, String content,Integer branch, @PathVariable Long cid) throws Exception {


        log.info("============================================");
        log.info("new classes name is " + name + " qq is " + qq + "swear is " + content+" branch = "+branch);

        if (StringUtil.isEmpty(name) || DataUtils.isNullOrEmpty(qq) || cid.equals(null)) {
            model.addAttribute("code", -1004);
            log.info("name or qq or cid is null");
            return "/common/success";
        }

        Manager manager = (Manager)request.getAttribute("manager");


        try {
            Classes classes = classesService.getObjectById(cid);
            if (classes.equals(null)) {
                model.addAttribute("code", -10002);
                log.info("the class is null");
                return "/common/success";
            }

            classes.setName(name);
            classes.setQq(qq);
            classes.setContent(content);

            //记录操作人
            classes.setUpdateBy(manager.getId());


            List<Long> uids =  userService.getUIdsByCid(cid, 0, Integer.MAX_VALUE);
            List<User> users = new ArrayList<>();
            if(CollectionUtils.isEmpty(uids)){
                log.info(" this classes don't have student ");
            }else {
                users = userService.getObjectsByIds(uids);
            }


            if(DataUtils.isNullOrEmpty(classes.getBranch())){
                log.info(" classes don't have branch ");

                if(DataUtils.isNullOrEmpty(branch)){
                    log.info(" param branch is null ");
                }else {
                    log.info(" update classes's branch ");
                    classes.setBranch(branch);
                    //并修改班内学员分院信息
                    if(!CollectionUtils.isEmpty(uids)){
                        log.info(" uopdate users branch ");
                        for(User user : users){
                            user.setBranch(branch);
                        }
                        userService.updateList(users);
                    }
                }
            }else {
                log.info(" classes branch is "+classes.getBranch());
                if(classes.getBranch().equals(branch)){
                    //不做修改
                }else {
                    classes.setBranch(branch);
                    log.info(" update classes's branch ");
                    //并修改班内学员分院信息
                    if(!CollectionUtils.isEmpty(uids)){
                        log.info(" uopdate users branch ");
                        for(User user : users){
                            user.setBranch(branch);
                        }
                        userService.updateList(users);
                    }
                }
            }



            classesService.update(classes);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add classes error,name is  " + name + " and qq is " + qq);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }




    /**
     * @param
     * @return
     */

    //18.设置首席弟子
    @RequestMapping(value = "/a/u/classmate/leader/{cid}", method = RequestMethod.PUT)
    public String classLeader(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                              @PathVariable Long cid, Long uid) throws Exception {


        log.info("============================================");
        log.info("cid is " + cid + " uid is " + uid);

        try {
            Manager manager = (Manager)request.getAttribute("manager");

            Classes classes = classesService.getObjectById(cid);

            if(classes.equals(null)){
                model.addAttribute("code", -10002);
                log.info("classes is null");
                return "/common/success";
            }

            if(uid==null){
                model.addAttribute("code", -1004);
                log.info("uid is null");
                return "/common/success";
            }

            Long relationId = userClassRelationService.getUserClassRelationIdByCidAndUid(cid, uid);

            if (relationId==null) {
                model.addAttribute("code", -10003);
                log.info("you are not in the classes");
                return "/common/success";
            }

            UserClassRelation relation = userClassRelationService.getObjectById(relationId);
            Integer status = relation.getStatus();

            //记录操作人
            relation.setUpdateBy(manager.getId());

            if(status==1){
                classes.setLeader(uid);
                classesService.update(classes);
            }else{
                model.addAttribute("code", -10007);
                log.info("you have quit the classes");
                return "/common/success";
            }

            Occupation occupation = occupationService.getObjectById(classes.getOid());
            Long core = occupation.getCoreUserCount();
            occupation.setCoreUserCount(core+1);
            occupationService.update(occupation);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("quit classes error,cid is  " + cid);
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /**
     * 初始化用户信息
     * @param request
     * @param response
     * @param model
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/init/user", method = RequestMethod.GET)
    public String initUser(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd ,Long endAt,Integer step ) throws ServiceException, ServiceDaoException {
        log.info(pwd + " will init user step is "+step+" and  endAt "+endAt );


        if("xdylxdyl".equals(pwd)){


            Integer userCounts=this.userService.countUserIds();
            log.info(" all use is "+userCounts);
            int start=0;
            if(step==null){
                step=200;
            }

            while(start<=userCounts){
                Long batchStart=System.currentTimeMillis();
                List<Long> uids=this.userService.getUserIds(start, step);
                List<User> users=this.userService.getObjectsByIds(uids);
                for(User user:users){
                    Long startAt=System.currentTimeMillis();
                    Long uid=user.getId();
                    Long ucid=this.userClassRelationService.getUserClassRelationIdsByUidAndStatus(uid, UserClassRelation.Status_Valid);
                    if(ucid==null){
                        log.info(uid+" not in class ");
                    }else{
                        UserClassRelation ucRelation=this.userClassRelationService.getObjectById(ucid);
                        log.info(uid+" get  class relation "+ucRelation.getId()+" get class id "+ucRelation.getCid());
                        user.setCid(ucRelation.getCid());
                        user.setUserClassID(ucid);
                        user.setStudyNumber(ucRelation.getNum().intValue());

                        Classes classes=this.classesService.getObjectById(ucRelation.getCid());
                        if(classes!=null){
                            user.setType(classes.getType());
                        }else{
                            log.info(uid+" get  class "+ucRelation.getCid()+" is null ");
                        }





                    }

                    List<Long> articleIDS=this.articleService.getArticleIdsByUidAndType(uid, Article.TYPE_DAILT, 0, Integer.MAX_VALUE);
                    user.setDailyCount(articleIDS.size());
                    this.userService.update(user);

                    log.info(user.getId()+" ================ user time is  "+(System.currentTimeMillis()-startAt));
                }

                start=start+step;
                log.info(start +" ====================== is update ,step is ====================== "+step +" user time is "+(System.currentTimeMillis()-batchStart));

            }



        } else {

            model.addAttribute("code", -10000);
            return "/common/success";

        }
        model.addAttribute("code", 0);

        return "/common/success";

    }



    /**
     * 初始化用户信息
     * @param request
     * @param response
     * @param model
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @RequestMapping(value = "/a/init/classes", method = RequestMethod.GET)
    public String initClasses(HttpServletRequest request, HttpServletResponse response, ModelMap model, String pwd ,Long endAt,Integer step ) throws ServiceException, ServiceDaoException {
        log.info(pwd + " will init user step is "+step+" and  endAt "+endAt );


        if("xdylxdyl".equals(pwd)){


            Integer classesCounts=this.classesService.countClassesIds();
            log.info(" all classesCounts is "+classesCounts);
            int start=0;
            if(step==null){
                step=200;
            }

            while(start<=classesCounts){
                Long batchStart=System.currentTimeMillis();
                List<Long> cids=this.classesService.getClassesIds(start, step);
                List<Classes> classesList=this.classesService.getObjectsByIds(cids);
                for(Classes classes:classesList){
                    Long startAt=System.currentTimeMillis();
                    Long cid=classes.getId();
                    Integer count=this.articleService.countArticleIdsByCidAndType(cid, Article.TYPE_DAILT);
                    classes.setDailyCount(count);
                    this.classesService.update(classes);

                    log.info(classes.getId()+" update daily count is "+count+" ================ user time is  "+(System.currentTimeMillis()-startAt));
                }

                start=start+step;
                log.info(start +" ====================== is update ,step is ====================== "+step +" user time is "+(System.currentTimeMillis()-batchStart));

            }



        } else {

            model.addAttribute("code", -10000);
            return "/common/success";

        }
        model.addAttribute("code", 0);

        return "/common/success";

    }

}