package com.ptteng.controller;

import com.gemantic.common.util.MyListUtil;
import com.ptteng.common.skill.model.*;
import com.ptteng.common.skill.service.BranchInstituteService;
import com.ptteng.common.skill.service.OccupationService;
import com.ptteng.common.skill.service.SuccessorService;
import com.ptteng.common.skill.service.UserService;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Successor  crud
 *
 * @author magenm
 * @Date 2014-4-16 13:43
 */
@Controller
public class SuccessorController {
    private static final Log log = LogFactory.getLog(SuccessorController.class);

    @Autowired
    private SuccessorService successorService;
    @Autowired
    private UserService userService;
    @Autowired
    private BranchInstituteService branchInstituteService;
    @Autowired
    private OccupationService occupationService;


    /**
     * show 获取真传列表
     *
     * @param branchId 分院id
     * @param oid      职业id
     * @param uid      用户id
     * @param nick     用户昵称
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author lishaobo
     * @date 2018/5/7
     */
    @RequestMapping(value = "/a/successor/search", method = RequestMethod.GET)
    public String getSuccessorDetail(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Long branchId, Long oid, Long uid, String nick, Integer size, Integer page) throws Exception {


        log.info("getSuccessorLIst: branchId=" + branchId + " ,oid=" + oid + " ,uid=" + uid + " ,nick=" + nick);

        /* 1 默认分页 */
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        boolean next = false;

        List<Long> idList = null;
        List<Long> totalList = null;
        List<User> userList = null;
        Integer total = 0;
        List<Successor> successorList = new ArrayList<>();
        try {

            Map<String, Object> params = DynamicUtil.getSuccessorList(uid, nick, oid, branchId);
            idList = successorService.getIdsByDynamicCondition(Successor.class, params, start, size);
            log.info("====== successor idList size is " + idList.size());
            successorList = successorService.getObjectsByIds(idList);

            Map<String, Object> paramTotal = DynamicUtil.getSuccessorList(uid, nick, oid, branchId);
            totalList = successorService.getIdsByDynamicCondition(Successor.class, paramTotal, 0, Integer.MAX_VALUE);
            total = totalList.size();

            List<Long> uids = MyListUtil.getList(Successor.class.getDeclaredField("uid"), successorList);

            userList = userService.getObjectsByIds(uids);
            log.info("successor uids is " + uids);


            next = (page * size < total);

            model.addAttribute("successorList", successorList);
            model.addAttribute("userList", userList);
            model.addAttribute("next", next);
            model.addAttribute("total", total);
            model.addAttribute("size", size);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            log.error("get successor error,branchId is " + branchId + " ,oid is " + oid);
            model.addAttribute("code", -100000);
        }
        return "/common-skill-service/successor/json/successorListJson";
    }


    /**
     * show 新增真传
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author hanjianmin
     * @date 2018/5/7
     */
    @RequestMapping(value = "/a/u/successor ", method = RequestMethod.POST)
    public String postSuccessorAdd(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model, Successor successor
    ) throws Exception {

        log.info("postSuccessorAdd: successor=" + successor);

        try {
            Manager manager = (Manager) request.getAttribute("manager");
            //校验
            if (DataUtils.isNullOrEmpty(successor.getBranchId())) {
                model.addAttribute("code", -50005);
                log.info("params error");
                return "/common/failure";
            } else {
                BranchInstitute branch = branchInstituteService.getObjectById(successor.getBranchId());
                if (DataUtils.isNullOrEmpty((branch))) {
                    model.addAttribute("code", -50006);
                    log.info("params error");
                    return "/common/failure";
                }
            }
            if (DataUtils.isNullOrEmpty(successor.getOid())) {
                model.addAttribute("code", -50000);
                log.info("params error");
                return "/common/failure";
            } else {
                 List<Long> uids = successorService.getUidsByOidAndBranchId(successor.getOid(),successor.getBranchId(),0,1);
                 if(!uids.isEmpty()){
                     model.addAttribute("code", -50008);
                     log.info("params error");
                     return "/common/failure";
                 }
            }
            if (DataUtils.isNullOrEmpty(successor.getProjectExp())) {
                model.addAttribute("code", -50003);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getTeachStyle())) {
                model.addAttribute("code", -50004);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getCliqueIntro())) {
                model.addAttribute("code", -50002);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getAvatar())) {
                model.addAttribute("code", -50009);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getUid())) {
                model.addAttribute("code", -50001);
                log.info("params error");
                return "/common/failure";
            } else {
                User user = userService.getObjectById(successor.getUid());
                if (DataUtils.isNullOrEmpty(user)) {
                    model.addAttribute("code", -5003);
                    log.info("params error");
                    return "/common/failure";
                }
            }

            Map<String, Object> map = DynamicUtil.getSuccessorMaxSort(successor.getBranchId());
            Integer maxSort = (Integer) successorService.getObjectByDynamicCondition(Successor.class, map, 0, Integer.MAX_VALUE);
            log.info("db maxSort is " + maxSort);
            if (DataUtils.isNotNullOrEmpty(maxSort)) {
                maxSort++;
            }else {
                maxSort=1;
            }
            log.info("maxSort is " + maxSort);
            successor.setSort(maxSort);
            successor.setCreateBy(manager.getId());
            successor.setUpdateBy(manager.getId());
            Long id = successorService.insert(successor);
            log.info("insert success " + id);
            model.addAttribute("code", 0);
            model.addAttribute("id", id);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -1000);
        }
        return "/common/insert";
    }


    /**
     * show 更新真传
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author 、
     * @date 2018/5/7
     */
    @RequestMapping(value = "/a/u/successor/{id}", method = RequestMethod.PUT)
    public String putSuccessorUpdate(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id, Successor successor) throws Exception {

        log.info("putSuccessorUpdate: successor=" + successor + " id=" + id);
        try {
            Manager manager = (Manager) request.getAttribute("manager");
            //校验
            Successor oSuccessor = successorService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(oSuccessor)) {
                model.addAttribute("code", -50007);
                log.info("data error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getOid())) {
                model.addAttribute("code", -50000);
                log.info("params error");
                return "/common/failure";
            } else {
                Occupation occupation = occupationService.getObjectById(successor.getOid());
                if (DataUtils.isNullOrEmpty(occupation)) {
                    model.addAttribute("code", -14011);
                    log.info("params error");
                    return "/common/failure";
                }else{
                    List<Long> uids= successorService.getUidsByOidAndBranchId(successor.getOid(), successor.getBranchId(), 0, 1);

                    if(uids.isEmpty() || successor.getUid().equals(uids.get(0))){
                        log.info("update this data");
                    }else{
                        model.addAttribute("code", -50008);
                        log.info("params error");
                        return "/common/failure";
                    }
                }
            }
            if (DataUtils.isNullOrEmpty(successor.getProjectExp())) {
                model.addAttribute("code", -50003);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getTeachStyle())) {
                model.addAttribute("code", -50004);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getCliqueIntro())) {
                model.addAttribute("code", -50002);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getAvatar())) {
                model.addAttribute("code", -50009);
                log.info("params error");
                return "/common/failure";
            }
            if (DataUtils.isNullOrEmpty(successor.getUid())) {
                model.addAttribute("code", -50001);
                log.info("params error");
                return "/common/failure";
            } else {
                User user = userService.getObjectById(successor.getUid());
                if (DataUtils.isNullOrEmpty(user)) {
                    model.addAttribute("code", -5003);
                    log.info("params error");
                    return "/common/failure";
                }
            }
            if (DataUtils.isNullOrEmpty(successor.getBranchId())) {
                model.addAttribute("code", -50005);
                log.info("params error");
                return "/common/failure";
            } else {
                BranchInstitute branch = branchInstituteService.getObjectById(successor.getBranchId());
                if (DataUtils.isNullOrEmpty((branch))) {
                    model.addAttribute("code", -50006);
                    log.info("params error");
                    return "/common/failure";
                }
            }

            successor.setUpdateBy(manager.getId());
            successor.setId(id);
            successor.setCreateBy(oSuccessor.getCreateBy());
            successor.setCreateAt(oSuccessor.getCreateAt());
            successor.setSort(oSuccessor.getSort());
            successorService.update(successor);
            log.info("update success " + id);
            model.addAttribute("code", 0);
            model.addAttribute("id", id);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -1000);
        }
        return "/common/insert";
    }


    /**
     * show 查看真传
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author 、
     * @date 2018/5/7
     */
    @RequestMapping(value = "/a/u/successor/{id}/detail", method = RequestMethod.GET)
    public String getSuccessorDetail(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("getSuccessorDetail: id=" + id);
        try {

            //校验
            Successor successor = successorService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(successor)) {
                model.addAttribute("code", -50007);
                log.info("data error");
                return "/common/failure";
            }
            User user = userService.getObjectById(successor.getUid());
            model.addAttribute("code", 0);
            model.addAttribute("successor", successor);
            model.addAttribute("user", user);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -1000);
        }
        return "/common-skill-service/successor/json/successorDetailJson";


    }


    /**
     * show 删除真传
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author 、
     * @date 2018/5/7
     */
    @RequestMapping(value = "/a/u/successor/{id}", method = RequestMethod.DELETE)
    public String deleteSuccessor(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("deleteSuccessor: id=" + id);
        try {
            Manager manager = (Manager) request.getAttribute("manager");
            //校验
            Successor successor = successorService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(successor)) {
                model.addAttribute("code", -50007);
                log.info("data error");
                return "/common/failure";
            }
            successorService.delete(id);
            log.info("delete success " + id + " by " + manager.getId());
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage(), t);
            model.addAttribute("code", -1000);
        }

        return "/common/success";
    }


    /**
     * show 分院真传排序
     *
     * @return java.lang.String
     * @throws Exception 异常信息
     * @author 、
     * @date 2018/5/8
     */


    @RequestMapping(value = "/a/u/successor/sort", method = RequestMethod.POST)
    public String sortStage(HttpServletRequest request,
                            HttpServletResponse response, ModelMap model, @RequestBody List<Long> ids)
            throws Exception {
        log.info("sort branch:ids=" + ids);
        try {
            List<Successor> successors = successorService.getObjectsByIds(ids);
            int index = 1;
            for (Successor successor : successors) {
                successor.setSort(index);
                index ++;
            }
            this.successorService.updateList(successors);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("order successor error");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }
}

	
	


