-- ----------------------------
-- Table structure for `user_order`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_order`;
CREATE TABLE `user_order` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint NOT NULL   COMMENT '品牌id',  
    `store_id` bigint(50) NOT NULL   COMMENT '店铺id',  
    `store_name` varchar(50)    COMMENT '店铺名',  
    `platform` varchar(10) NOT NULL   COMMENT '外卖渠道',  
    `user_name` varchar(50) NOT NULL   COMMENT '用户姓名',  
    `user_count` int(10)    COMMENT '用户下单次数',  
    `sex` int(1) NOT NULL   COMMENT '性别',  
    `mobile` varchar(20) NOT NULL   COMMENT '手机号码',  
    `delivery_address` varchar(50) NOT NULL   COMMENT '送餐地址',  
    `expect_time` varchar(20)    COMMENT '期望送达时间',  
    `buy_at` bigint NOT NULL   COMMENT '下单时间',  
    `accept_at` bigint NOT NULL   COMMENT '接单时间',  
    `end_at` bigint    COMMENT '完成时间',  
    `accept_status` int(2) NOT NULL   COMMENT '接单状态 【1、待接单 2、已接单 3、已拒绝】',  
    `order_status` int(2) NOT NULL   COMMENT '订单状态 【0取消订单 1、未完成 2、配送中 3、配送完成 4、退款中 5、已退款】',  
    `cancel_reason` varchar(500)    COMMENT '取消原因',  
    `order_price` varchar(20) NOT NULL   COMMENT '订单金额',  
    `box_fee` varchar(20)    COMMENT '餐盒费',  
    `delivery_fee` varchar(20)    COMMENT '配送费',  
    `pay_fee` varchar(20) NOT NULL   COMMENT '支付金额',  
    `promotion_fee` varchar(20)    COMMENT '优惠金额',  
    `brokerage` varchar(20)    COMMENT '佣金',  
    `platform_subsidy` varchar(20)    COMMENT '平台补贴',  
    `pay_way` int(2) NOT NULL   COMMENT '支付方式',  
    `order_num` bigint(50) NOT NULL   COMMENT '订单号',  
    `platform_order_num` bigint(50) NOT NULL   COMMENT '外卖平台订单号',  
    `courier_mobile` varchar(20)    COMMENT '快递人员手机号',  
    `delivery_method` varchar(20)    COMMENT '配送方式',  
    `order_remarks` varchar(500)    COMMENT '订单备注',  
    `invoice` int(2)    COMMENT '是否需要发票【0不需要 1需要】',  
    `invoice_title` varchar(50)    COMMENT '发票抬头',  
    `tax_num` varchar(50)    COMMENT '发票税号',  
    `invoice_mark` int(2)    COMMENT '发票标记',  
    `print_status` int(2)    COMMENT '订单打印状态【0未打印1已打印】',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





