-- ----------------------------
-- Table structure for `food_spec_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `food_spec_relation`;
CREATE TABLE `food_spec_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `target_id` bigint NOT NULL   COMMENT '与菜品关联id',  
    `spec_name` varchar(20) NOT NULL   COMMENT '规格名',  
    `stock` int    COMMENT '库存',  
    `max_stock` int    COMMENT '最大库存量',  
    `price` decimal(10,2) NOT NULL   COMMENT '价格',  
    `packing_fee` decimal(10,2)    COMMENT '包装费',  
    `weight` int    COMMENT '商品重量',  
    `available_times` varchar(100)    COMMENT '起售时间',  
    `on_shelf` int    COMMENT '是否上架',  
    `extend_code` varchar(20)    COMMENT '商品扩展码',  
    `bar_code` varchar(20)    COMMENT '商品条形码',  
    `activity_level` int    COMMENT '商品活动',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





