CREATE DATABASE onway_platform DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;
use onway_platform;
-- ----------------------------
-- Table structure for `trademark_params_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `trademark_params_relation`;
CREATE TABLE `trademark_params_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint NOT NULL   COMMENT '品牌id',  
    `trademark_num` varchar(20) COMMENT '品牌编号',
    `platform` varchar(10) NOT NULL   COMMENT '对接平台(百度000100、饿了么000010、美团000001)',  
    `isEnabled` int(2) NOT NULL DEFAULT 0 COMMENT '参数启用（0否1是）',
    `appid` varchar(50)    COMMENT 'appid',
    `secret` varchar(50)    COMMENT 'secret',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `syn_record`
-- ----------------------------
-- DROP TABLE IF EXISTS `syn_record`;
CREATE TABLE `syn_record` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `trademark_num` bigint    COMMENT '品牌编号',
    `trademark_id` bigint    COMMENT '品牌id',
    `store_id` bigint    COMMENT '门店id',
    `platform` varchar(20)    COMMENT '同步平台',
    `syn_type` int    COMMENT '同步类型',
    `status` int    COMMENT '同步状态',
    `error_msg` varchar(500)    COMMENT '异常信息',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `store`
-- ----------------------------
-- DROP TABLE IF EXISTS `store`;
CREATE TABLE `store` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint NOT NULL   COMMENT '品牌id',  
    `trademark_num` varchar(20) NOT NULL   COMMENT '品牌编号',  
    `name` varchar(20) NOT NULL   COMMENT '门店名称',  
    `online_platform` varchar(20) NOT NULL   COMMENT '上线平台',  
    `auto_orders` int(2) NOT NULL   COMMENT '是否开启自动接单(0关闭、1开启)',  
    `invoice` int(2) NOT NULL   COMMENT '是否支持发票 (0关闭、1开启)',  
    `synchronize` varchar(20) NOT NULL   COMMENT '三方平台同步设置',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_order`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_order`;
CREATE TABLE `user_order` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint NOT NULL   COMMENT '品牌id',  
    `uid` bigint COMMENT '用户id',
    `store_id` bigint(50) NOT NULL   COMMENT '店铺id',
    `store_name` varchar(50)    COMMENT '店铺名',
    `platform` varchar(10) NOT NULL   COMMENT '外卖渠道',  
    `user_name` varchar(50) NOT NULL   COMMENT '用户姓名',  
    `buy_count` int(10)    COMMENT '用户下单次数',
    `sex` int(1)    COMMENT '性别',
    `mobile` varchar(20) NOT NULL   COMMENT '手机号码',  
    `delivery_address` varchar(50) NOT NULL   COMMENT '送餐地址',  
    `expect_time` varchar(20)    COMMENT '期望送达时间',  
    `buy_at` bigint NOT NULL   COMMENT '下单时间',  
    `accept_at` bigint NOT NULL   COMMENT '接单时间',  
    `end_at` bigint    COMMENT '完成时间',  
    `accept_status` int(2) NOT NULL   COMMENT '接单状态 【1、待接单 2、已接单 3、已拒绝】',  
    `order_status` int(2) NOT NULL   COMMENT '订单状态 【0取消订单 1、未完成 2、配送中 3、配送完成 4、退款中 5、已退款】',  
    `cancel_reason` varchar(500)    COMMENT '取消原因',  
    `order_price` varchar(20) NOT NULL   COMMENT '订单金额',  
    `box_fee` varchar(20)    COMMENT '餐盒费',  
    `delivery_fee` varchar(20)    COMMENT '配送费',  
    `pay_fee` varchar(20) NOT NULL   COMMENT '支付金额',  
    `promotion_fee` varchar(20)    COMMENT '优惠金额',  
    `brokerage` varchar(20)    COMMENT '佣金',  
    `platform_subsidy` varchar(20)    COMMENT '平台补贴',  
    `pay_way` int(2) NOT NULL   COMMENT '支付方式',  
    `order_num` bigint(50) NOT NULL   COMMENT '订单号',  
    `platform_order_num` bigint(50) NOT NULL   COMMENT '外卖平台订单号',  
    `courier_mobile` varchar(20)    COMMENT '快递人员手机号',  
    `delivery_method` varchar(20)    COMMENT '配送方式',  
    `order_remarks` varchar(500)    COMMENT '订单备注',  
    `invoice` int(2)    COMMENT '是否需要发票【0不需要 1需要】',  
    `invoice_title` varchar(50)    COMMENT '发票抬头',  
    `tax_num` varchar(50)    COMMENT '发票税号',  
    `invoice_mark` int(2)    COMMENT '发票标记',  
    `print_status` int(2)    COMMENT '订单打印状态【0未打印1已打印】',  
    `sort` int DEFAULT 1 COMMENT '当天订单计数',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `food_type_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `food_type_relation`;
CREATE TABLE `food_type_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `trademark_id` bigint    COMMENT '品牌id',
    `store_id` bigint    COMMENT '门店id',
    `name` varchar(20)    COMMENT '菜品分类名',
    `old_name` varchar(20)    COMMENT '菜品分类旧名',
    `group_rank` int    COMMENT '分类排序',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `food`
-- ----------------------------
-- DROP TABLE IF EXISTS `food`;
CREATE TABLE `food` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `food_num` varchar(20)    COMMENT '菜品编号',  
    `name` varchar(20) NOT NULL   COMMENT '菜品名',  
    `price` varchar(20) NOT NULL   COMMENT '价格',  
    `format` int(2) NOT NULL   COMMENT '单位',  
    `stock` bigint NOT NULL   COMMENT '库存',  
    `food_type` int(2)    COMMENT '菜品类型',
    `meal_type` int(2)    COMMENT '餐别',
    `meituan_status` int(2) DEFAULT 0   COMMENT '美团外卖(0不启用1启用)',
    `baidu_status` int(2) DEFAULT 0   COMMENT '百度外卖(0不启用1启用)',
    `ele_status` int(2) DEFAULT 0   COMMENT '饿了么外卖(0不启用1启用)',
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `trademark`
-- ----------------------------
-- DROP TABLE IF EXISTS `trademark`;
CREATE TABLE `trademark` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `name` varchar(50) NOT NULL   COMMENT '品牌名称',  
    `trademark_num` varchar(20) NOT NULL   COMMENT '品牌编号',  
    `platform` varchar(10) NOT NULL   COMMENT '对接平台(百度000100、饿了么000010、美团000001)',  
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `food_order_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `food_order_relation`;
CREATE TABLE `food_order_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint    COMMENT '品牌id',  
    `store_id` bigint    COMMENT '门店id',  
    `food_id` bigint    COMMENT '菜品id',  
    `food_name` varchar(20)    COMMENT '菜品名',
    `food_type` int(2)    COMMENT '菜品类型',
    `order_id` bigint NOT NULL   COMMENT '订单id',  
    `amount` bigint NOT NULL   COMMENT '菜品数量',
    `price` varchar(20) NOT NULL   COMMENT '菜品总金额',
    `platform` varchar(20)    COMMENT '平台',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `user_id` bigint    COMMENT '三方用户id',  
    `name` varchar(20) NOT NULL   COMMENT '姓名',  
    `mobile` varchar(20)    COMMENT '手机',  
    `sex` int(2) COMMENT '性别(1男2女）',
    `for_here` int(2) NOT NULL   COMMENT '是否堂食用户（0否1是）',  
    `level` int(2) NOT NULL   COMMENT '是否堂食会员（0否1是）',  
    `platform` varchar(20) NOT NULL   COMMENT '平台',  
    `address` varchar(50)    COMMENT '收货地址',  
    `join_at` bigint COMMENT '加入时间',
    `create_by` bigint    COMMENT '创建人ID',  
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `evaluate_order_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `evaluate_order_relation`;
CREATE TABLE `evaluate_order_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',  
    `trademark_id` bigint    COMMENT '品牌id',  
    `order_id` bigint NOT NULL   COMMENT '订单id',  
    `store_id` bigint    COMMENT '门店id',  
    `platform_order_num` varchar(20) NOT NULL   COMMENT '第三方订单号',  
    `platform` varchar(20)    COMMENT '平台',  
    `business_reply` varchar(500)    COMMENT '商家回复',  
    `score` int(2) NOT NULL   COMMENT '评价分数',  
    `price` VARCHAR(20) COMMENT '订单价格',
    `content` varchar(500) NOT NULL   COMMENT '评价内容',
    `img` varchar(500)    COMMENT '图片列表',  
    `uid` bigint COMMENT '用户id',
    `evaluate_at` bigint   COMMENT '评价时间',
    `reply_at` bigint   COMMENT '回复时间',
    `buy_at` bigint   COMMENT '下单时间',
    `create_by` bigint    COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',  
    `update_at` bigint NOT NULL   COMMENT '数据更新时间',  
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `period`
-- ----------------------------
-- DROP TABLE IF EXISTS `period`;
CREATE TABLE `period` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `period_start` bigint NOT NULL  ,
    `period_end` bigint NOT NULL  ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `store_period_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `store_period_relation`;
CREATE TABLE `store_period_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `store_id` bigint NOT NULL  ,
    `period_id` bigint NOT NULL  ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `food_period_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `food_period_relation`;
CREATE TABLE `food_period_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,
    `food_id` bigint NOT NULL  ,
    `period_id` bigint NOT NULL  ,
    `create_by` bigint   ,
    `update_by` bigint   ,
    `update_at` bigint NOT NULL  ,
    `create_at` bigint NOT NULL  ,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;







