/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Lists;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.ShopService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.BussinessTime;
import com.jiabangou.bdwmsdk.model.Shop;
import com.jiabangou.bdwmsdk.model.ShopDetail;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.BaiduAbstractService;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class BaiduStoreServiceImpl
extends BaiduAbstractService
implements WaimaiStoreService {
    private static Logger logger = Logger.getLogger(BaiduStoreServiceImpl.class);

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        ShopService shopService = bdWmClient.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        String mappingId = storeMapping == null ? String.valueOf(storeId) : storeMapping.getMappingId();
        ShopDetail shopDetail = this.getStore(mappingId, shopService);
        try {
            if (shopDetail != null) {
                Shop shop = this.buildUpdateShop(mappingId, waimaiStoreDTO);
                shopService.update(shop);
            }
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    private ShopDetail getStore(String mappingId, ShopService shopService) {
        try {
            return shopService.getDetail(mappingId);
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
            return null;
        }
    }

    private Shop buildCreateShop(String mappingId, WaimaiStoreDTO waiMaiDTO) {
        Shop shop = new Shop();
        shop.setShop_id(mappingId);
        shop.setName(waiMaiDTO.getName());
        shop.setShop_logo(waiMaiDTO.getShopLogo() + "@750w_625h_1e_1c_1pr");
        shop.setPhone(waiMaiDTO.getPhone());
        shop.setService_phone(waiMaiDTO.getServicePhone());
        String[] businessTimes = waiMaiDTO.getOpenTime().split(",");
        ArrayList business_time = Lists.newArrayList();
        if (businessTimes.length != 0) {
            for (String businessTimeStr : businessTimes) {
                String[] businessTimeStartEnd = businessTimeStr.split("-");
                if (businessTimeStartEnd.length != 2) continue;
                BussinessTime bussinessTime = new BussinessTime();
                bussinessTime.setStart(businessTimeStartEnd[0]);
                bussinessTime.setEnd(businessTimeStartEnd[1]);
                business_time.add(bussinessTime);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)business_time)) {
            shop.setBusiness_time((List)business_time);
        }
        shop.setInvoice_support(Integer.valueOf(waiMaiDTO.getIsInvoice()));
        shop.setMin_order_price(Integer.valueOf(waiMaiDTO.getMinOrderPrice()));
        shop.setPackage_box_price(Integer.valueOf(waiMaiDTO.getPackageBoxPrice()));
        return shop;
    }

    private Shop buildUpdateShop(String mappingId, WaimaiStoreDTO waiMaiDTO) {
        Shop shop = this.buildCreateShop(mappingId, waiMaiDTO);
        shop.setDelivery_region(null);
        shop.setMin_order_price(null);
        shop.setName(null);
        return shop;
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        if (!this.checkStorePlatformById(mchId, storeId, "000010").booleanValue()) {
            return;
        }
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        ShopService shopService = bdWmClient.getShopService();
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        String mappingId = storeMapping == null ? String.valueOf(storeId) : storeMapping.getMappingId();
        ShopDetail shopDetail = this.getStore(mappingId, shopService);
        try {
            if (shopDetail != null) {
                shopService.open(mappingId);
            }
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        BdWmClient bdWmClient = this.getBdWmClient(mchId);
        if (bdWmClient == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000010");
        if (storeMapping == null) {
            return;
        }
        ShopService shopService = bdWmClient.getShopService();
        try {
            shopService.offline(storeMapping.getMappingId());
        }
        catch (BdWmErrorException bdWmErrorException) {
            logger.error((Object)bdWmErrorException.getMessage(), (Throwable)bdWmErrorException);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        return null;
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
    }
}

