/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.other;

import com.gemantic.common.exception.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.map.HashedMap;

public class ConvertUtils {
    public static <T> T convert(Object src, Class<T> destType) throws ServiceException {
        if (src == null) {
            return null;
        }
        T t = null;
        try {
            t = destType.newInstance();
            BeanUtils.copyProperties(t, (Object)src);
        }
        catch (Exception e) {
            throw new ServiceException("data convert error.", (Throwable)e);
        }
        return t;
    }

    public static void convert(Object src, Object dest) throws ServiceException {
        try {
            BeanUtils.copyProperties((Object)dest, (Object)src);
        }
        catch (Exception e) {
            throw new ServiceException("data convert error.", (Throwable)e);
        }
    }

    public static <T> List<T> converts(List list, Class<T> destType) throws ServiceException {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> userDTOs = new ArrayList<T>(list.size());
        for (Object obj : list) {
            userDTOs.add(ConvertUtils.convert(obj, destType));
        }
        return userDTOs;
    }

    public static <K, T> Map<K, T> convertMap(Map<K, ?> map, Class<T> destType) throws ServiceException {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        HashedMap destMap = new HashedMap(map.size());
        Set<Map.Entry<K, ?>> set = map.entrySet();
        for (Map.Entry<K, ?> entry : set) {
            destMap.put(entry.getKey(), ConvertUtils.convert(entry.getValue(), destType));
        }
        return destMap;
    }
}

