/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Sets;
import com.ptteng.onway.platform.service.WaimaiOrderHandleService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class OrderHandleServiceImpl
implements WaimaiOrderHandleService {
    @Autowired
    @Qualifier(value="meituanOrderService")
    private static WaimaiOrderService meituanOrderService;
    private static final Set<WaimaiOrderService> waimaiOrderServices;

    public void confirm(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.confirmOrder(mchId, storeId, orderId);
        }
    }

    public void cancel(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.cancelOrder(mchId, storeId, orderId, reasonId, reason);
        }
    }

    public void complete(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.completeOrder(mchId, storeId, orderId);
        }
    }

    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.agreeRefund(mchId, storeId, orderId);
        }
    }

    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
        for (WaimaiOrderService s : waimaiOrderServices) {
            s.disagreeRefund(mchId, storeId, orderId, reason);
        }
    }

    static {
        waimaiOrderServices = Sets.newHashSet();
        waimaiOrderServices.add(meituanOrderService);
    }
}

