/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.order.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.OrderService;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.order.WaimaiOrderService;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import java.util.Objects;
import org.apache.log4j.Logger;

public class MeituanOrderServiceImpl
extends MeituanAbstractService
implements WaimaiOrderService {
    private static Logger logger = Logger.getLogger(MeituanOrderServiceImpl.class);

    @Override
    public void confirmOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!this.isMeituanOrder(orderId).booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (Objects.isNull(client)) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (Objects.isNull(storeMapping)) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000001");
        if (Objects.isNull(orderMapping)) {
            return;
        }
        try {
            client.getOrderService().confirm(orderMapping.getTargetId());
        }
        catch (MtWmErrorException e) {
            logger.info((Object)"\u7f8e\u56e2\u5916\u5356\u786e\u8ba4\u8ba2\u5355\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9519\u8bef\u65e5\u5fd7!");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void cancelOrder(Long mchId, Long storeId, Long orderId, Long reasonId, String reason) throws ServiceException, ServiceDaoException {
        if (!this.isMeituanOrder(orderId).booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000001");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = client.getOrderService();
        try {
            orderService.cancel(orderMapping.getTargetId(), this.cancelReasonCodeTransform(reasonId.intValue()).intValue(), reason);
        }
        catch (MtWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    private Integer cancelReasonCodeTransform(Integer selfPlatformReasonCode) {
        switch (selfPlatformReasonCode) {
            case 1: {
                return 2010;
            }
            case 2: {
                return 2011;
            }
            case 3: {
                return selfPlatformReasonCode;
            }
            case 4: {
                return selfPlatformReasonCode;
            }
            case 5: {
                return 2006;
            }
            case 6: {
                return 2013;
            }
            case 7: {
                return 2008;
            }
            case 8: {
                return 2012;
            }
            case 9: {
                return selfPlatformReasonCode;
            }
        }
        return selfPlatformReasonCode;
    }

    @Override
    public void completeOrder(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!this.isMeituanOrder(orderId).booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (Objects.isNull(client)) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (Objects.isNull(storeMapping)) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000001");
        if (Objects.isNull(orderMapping)) {
            return;
        }
        try {
            client.getOrderService().arrived(orderMapping.getTargetId());
        }
        catch (MtWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void agreeRefund(Long mchId, Long storeId, Long orderId) throws ServiceException, ServiceDaoException {
        if (!this.isMeituanOrder(orderId).booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000001");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = client.getOrderService();
        try {
            orderService.agreeRefund(orderMapping.getTargetId(), "\u987e\u5ba2\u5c31\u662f\u4e0a\u5e1d\u786e\u8ba4\u9000\u6b3e");
        }
        catch (MtWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void disagreeRefund(Long mchId, Long storeId, Long orderId, String reason) throws ServiceException, ServiceDaoException {
        if (!this.isMeituanOrder(orderId).booleanValue()) {
            return;
        }
        MtWmClient client = this.getMtWmClient(mchId);
        if (client == null) {
            return;
        }
        WaimaiStoreMapping storeMapping = this.findStoreMapping(mchId, storeId, "000001");
        if (storeMapping == null) {
            return;
        }
        WaimaiOrderMapping orderMapping = this.findOrderMappingByOrderIdPlatformType(mchId, storeId, orderId, "000001");
        if (orderMapping == null) {
            return;
        }
        OrderService orderService = client.getOrderService();
        try {
            orderService.disagreeRefund(orderMapping.getTargetId(), reason == null || reason.equals("") ? "\u5546\u5bb6\u62d2\u7edd\u9000\u6b3e" : reason);
        }
        catch (MtWmErrorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

