/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai.dish.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Sets;
import com.ptteng.onway.platform.model.DishGroupWmDTO;
import com.ptteng.onway.platform.model.DishNormWmDTO;
import com.ptteng.onway.platform.service.WaimaiDishConsumerService;
import com.ptteng.onway.platform.service.waimai.dish.WaimaiDishService;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DishConsumerServiceImpl
implements WaimaiDishConsumerService {
    @Autowired
    @Qualifier(value="meituanDishService")
    private WaimaiDishService meituanDishService;
    private static Set<WaimaiDishService> waimaiDishServices = Sets.newHashSet();

    private Set<WaimaiDishService> getWaimaiDishServices() {
        if (CollectionUtils.isEmpty(waimaiDishServices)) {
            waimaiDishServices.add(this.meituanDishService);
        }
        return waimaiDishServices;
    }

    public void saveDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.saveDishGroup(mchId, storeId, dishGroupId, dishGroup);
        }
    }

    public void updateDishGroup(Long mchId, Long storeId, Long dishGroupId, DishGroupWmDTO dishGroup) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.updateDishGroup(mchId, storeId, dishGroupId, dishGroup);
        }
    }

    public void onlineDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.onlineDish(mchId, storeId, dishNormId, dishNormWmDTO);
        }
    }

    public void offlineDish(Long mchId, Long storeId, Long dishNormId) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.offlineDish(mchId, storeId, dishNormId);
        }
    }

    public void updateDish(Long mchId, Long storeId, Long dishNormId, DishNormWmDTO dishNormWmDTO) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.updateDish(mchId, storeId, dishNormId, dishNormWmDTO);
        }
    }

    public void batchUpdateDish(Long mchId, Long storeId, List<DishNormWmDTO> dishNormWmDTOs) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.batchUpdateDish(mchId, storeId, dishNormWmDTOs);
        }
    }

    public void setThreshold(Long mchId, Long storeId, Long dishNormId, int stock) throws ServiceException, ServiceDaoException {
        for (WaimaiDishService s : this.getWaimaiDishServices()) {
            s.setThreshold(mchId, storeId, dishNormId, stock);
        }
    }
}

