/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.waimai;

import com.alibaba.fastjson.JSONObject;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.service.WaimaiService;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiDishCategoryMappingDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiDishMappingDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiOrderMappingDao;
import com.ptteng.onway.platform.service.waimai.other.daos.WaimaiStoreMappingDao;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishCategoryMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiDishMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiOrderMapping;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WaimaiAbstractService {
    private Logger logger = LoggerFactory.getLogger(WaimaiAbstractService.class);
    @Autowired
    private WaimaiStoreMappingDao storeMappingDao;
    @Autowired
    protected WaimaiDishCategoryMappingDao dishCategoryMappingDao;
    @Autowired
    protected WaimaiDishMappingDao dishMappingDao;
    @Autowired
    protected WaimaiOrderMappingDao orderMappingDao;
    @Autowired
    private WaimaiService waimaiService;

    protected void log(String cmd, String method, Boolean isSuccess, String request, String response) {
        try {
            this.waimaiService.saveWaiMaiLog(cmd, method, isSuccess, request, response);
        }
        catch (Exception e) {
            this.logger.error("save log info error", (Throwable)e);
        }
    }

    protected Boolean checkStorePlatformById(Long mchId, Long storeId, String platformType) {
        return Boolean.TRUE;
    }

    protected WaimaiStoreMapping findStoreMapping(Long mchId, Long storeId, String platformType) throws ServiceException, ServiceDaoException {
        return this.storeMappingDao.findOneByMchIdStoreIdPlatformType(mchId, storeId, platformType);
    }

    protected WaimaiStoreMapping findStoreMappingByMappingIdPlatformType(String mappingId, String platformType) throws ServiceException, ServiceDaoException {
        return this.storeMappingDao.findOneByMappingIdPlatformType(mappingId, platformType);
    }

    protected void saveStoreMapping(Long mchId, Long storeId, String targetId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiStoreMapping storeMapping = new WaimaiStoreMapping();
        storeMapping.setMchId(mchId);
        storeMapping.setStoreId(storeId);
        storeMapping.setPlatformType(platformType);
        storeMapping.setMappingId(String.valueOf(storeId));
        storeMapping.setTargetId(targetId);
        this.storeMappingDao.saveStoreMapping(storeMapping);
    }

    protected WaimaiDishCategoryMapping findDishCategoryMapping(Long mchId, Long storeId, Long dishGroupId, String platformType) throws ServiceException, ServiceDaoException {
        return this.dishCategoryMappingDao.findOneByMchIdStoreIdCategoryIdPlatformType(mchId, storeId, dishGroupId, platformType);
    }

    protected WaimaiDishCategoryMapping saveDishCategoryMapping(Long mchId, Long storeId, Long dishGroupId, String name, String targetId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiDishCategoryMapping dishCategoryMapping = this.dishCategoryMappingDao.findOneByMchIdStoreIdCategoryIdPlatformType(mchId, storeId, dishGroupId, platformType);
        if (dishCategoryMapping != null) {
            if (name.equals(dishCategoryMapping.getName())) {
                return dishCategoryMapping;
            }
            dishCategoryMapping.setName(name);
            this.dishCategoryMappingDao.updateDishCategoryMapping(dishCategoryMapping);
        } else {
            dishCategoryMapping = new WaimaiDishCategoryMapping();
            dishCategoryMapping.setMchId(mchId);
            dishCategoryMapping.setPlatformType(platformType);
            dishCategoryMapping.setStoreId(storeId);
            dishCategoryMapping.setCategoryId(dishGroupId);
            dishCategoryMapping.setName(name);
            dishCategoryMapping.setTargetId(targetId);
            this.dishCategoryMappingDao.saveDishCategoryMapping(dishCategoryMapping);
        }
        return dishCategoryMapping;
    }

    protected Boolean checkDishPlatformById(Long mchId, Long storeId, Long dishNormId, String platformType) {
        return Boolean.TRUE;
    }

    protected List<Long> checkDishPlatformByIds(Long mchId, Long storeId, List<Long> dishNormIds, String platformType) {
        return null;
    }

    protected WaimaiDishMapping findDishMapping(Long mchId, Long storeId, Long dishNormId, String platformType) throws ServiceException, ServiceDaoException {
        return this.dishMappingDao.findOneByMchIdStoreIdDishNormIdPlatformType(mchId, storeId, dishNormId, platformType);
    }

    protected void addDishMapping(Long mchId, Long storeId, Long dishNormId, String targetId, String platformType) throws ServiceException, ServiceDaoException {
        this.addDishMapping(mchId, storeId, dishNormId, targetId, platformType, null);
    }

    protected void addDishMapping(Long mchId, Long storeId, Long dishNormId, String targetId, String platformType, Map<String, Object> properties) throws ServiceException, ServiceDaoException {
        WaimaiDishMapping dishMapping = new WaimaiDishMapping();
        dishMapping.setPlatformType(platformType);
        dishMapping.setTargetId(targetId);
        dishMapping.setDishNormId(dishNormId);
        dishMapping.setMchId(mchId);
        dishMapping.setStoreId(storeId);
        dishMapping.setMappingId(String.valueOf(dishNormId));
        if (properties != null) {
            dishMapping.setProperties(JSONObject.toJSONString(properties));
        }
        this.dishMappingDao.saveDishMapping(dishMapping);
    }

    protected void updateDishMapping(WaimaiDishMapping dishMapping) throws ServiceException, ServiceDaoException {
        if (dishMapping == null) {
            return;
        }
        this.dishMappingDao.updateDishMapping(dishMapping);
    }

    protected Boolean isBaiduOrder(Long orderId) {
        return Boolean.TRUE;
    }

    protected Boolean isElemeOrder(Long orderId) {
        return Boolean.TRUE;
    }

    protected Boolean isMeituanOrder(Long orderId) {
        return Boolean.TRUE;
    }

    protected WaimaiOrderMapping findOrderMappingByOrderIdPlatformType(Long mchId, Long storeId, Long orderId, String platformType) throws ServiceException, ServiceDaoException {
        return this.orderMappingDao.findOneByMchIdStoreIdOrderIdPlatformType(mchId, storeId, orderId, platformType);
    }

    protected WaimaiOrderMapping findOrderMappingByTargetPlatformType(String targetId, String platformType) throws ServiceException, ServiceDaoException {
        return this.orderMappingDao.findOneByTargetIdPlatformType(targetId, platformType);
    }

    protected WaimaiOrderMapping saveOrderMapping(Long mchId, Long storeId, Long orderId, String targetId, String platformType) throws ServiceException, ServiceDaoException {
        return this.saveOrderMapping(mchId, storeId, orderId, targetId, null, platformType);
    }

    protected WaimaiOrderMapping saveOrderMapping(Long mchId, Long storeId, Long orderId, String targetId, String viewId, String platformType) throws ServiceException, ServiceDaoException {
        WaimaiOrderMapping orderMapping = new WaimaiOrderMapping();
        orderMapping.setMchId(mchId);
        orderMapping.setStoreId(storeId);
        orderMapping.setOrderId(orderId);
        orderMapping.setTargetId(targetId);
        orderMapping.setViewId(viewId);
        orderMapping.setPlatformType(platformType);
        this.orderMappingDao.saveOrderMapping(orderMapping);
        return orderMapping;
    }

    protected void updateOrderMapping(WaimaiOrderMapping orderMapping) throws ServiceException, ServiceDaoException {
        if (orderMapping == null) {
            return;
        }
        this.orderMappingDao.updateOrderMapping(orderMapping);
    }
}

