/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.Trademark;
import com.ptteng.onway.platform.service.TrademarkService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrademarkServiceImpl
extends BaseDaoServiceImpl
implements TrademarkService {
    private static final Log log = LogFactory.getLog(TrademarkServiceImpl.class);

    public Long insert(Trademark trademark) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + trademark));
        if (trademark == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        trademark.setCreateAt(Long.valueOf(currentTimeMillis));
        trademark.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)trademark);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + trademark));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Trademark> insertList(List<Trademark> trademarkList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (trademarkList == null ? "null" : Integer.valueOf(trademarkList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(trademarkList)) {
            return new ArrayList<Trademark>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Trademark trademark : trademarkList) {
            trademark.setCreateAt(Long.valueOf(currentTimeMillis));
            trademark.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(trademarkList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + trademarkList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Trademark.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Trademark trademark) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (trademark == null ? "null" : trademark.getId())));
        boolean result = false;
        if (trademark == null) {
            return true;
        }
        trademark.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)trademark);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + trademark));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + trademark));
        }
        return result;
    }

    public boolean updateList(List<Trademark> trademarkList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (trademarkList == null ? "null" : Integer.valueOf(trademarkList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(trademarkList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Trademark trademark : trademarkList) {
            trademark.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(trademarkList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + trademarkList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + trademarkList.size()));
        return result;
    }

    public Trademark getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Trademark trademark = null;
        if (id == null) {
            return trademark;
        }
        try {
            trademark = (Trademark)this.dao.get(Trademark.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return trademark;
    }

    public List<Trademark> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List trademark = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Trademark>();
        }
        try {
            trademark = this.dao.getList(Trademark.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (trademark == null ? "null" : Integer.valueOf(trademark.size()))));
        return trademark;
    }

    public Long getTrademarkIdByName(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by name  : " + name));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getTrademarkIdByName", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by name  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Long getTrademarkByTrademarkNum(String trademarkNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by trademarkNum : " + trademarkNum));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getTrademarkIdsByTrademarkNum", new Object[]{trademarkNum});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by trademarkNum)  : " + trademarkNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : id is " + id));
        }
        return id;
    }

    public Integer countTrademarkIdsByTrademarkNum(String trademarkNum) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by trademarkNum  : " + trademarkNum));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTrademarkIdsByTrademarkNum", new Object[]{trademarkNum});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by trademarkNum)  : " + trademarkNum));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getTrademarkIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTrademarkIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTrademarkIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTrademarkIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTrademarkIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

