/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.onway.platform.model.EvaluateStatistics;
import com.ptteng.onway.platform.model.FoodStatistics;
import com.ptteng.onway.platform.model.OrderStatistics;
import com.ptteng.onway.platform.model.UserStatistics;
import com.ptteng.onway.platform.service.TemplateTestService;
import com.qding.common.util.DataUtils;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class TemplateTestServiceImpl
implements TemplateTestService {
    private static final Log log = LogFactory.getLog(TemplateTestServiceImpl.class);
    private JdbcTemplate template;

    public JdbcTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    public List<OrderStatistics> getOrderStatisticsByTimeAndStoreId(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        log.info((Object)("getOrderStatisticsByTimeAndStoreId start_at is " + start_at + " , end_at is " + end_at + " storeId is " + storeId));
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE store_id = ? GROUP BY  platform";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and store_id = ? GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and store_id = ? GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, storeId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{storeId});
    }

    public List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkId(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? GROUP BY  platform,store_id";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? GROUP BY  platform  ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<OrderStatistics> getOrderStatisticsByTimeAndStoreIdAndOrderStatus(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform  ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, storeId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{storeId});
    }

    public List<OrderStatistics> getOrderStatisticsByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform,store_id";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform  ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkId(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? GROUP BY store_id";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? GROUP BY store_id";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? GROUP BY store_id";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? GROUP BY store_id";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreId(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE store_id = ?";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ?";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and store_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and store_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, storeId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{storeId});
    }

    public List<OrderStatistics> getOrderStatisticsAllByTimeAndTrademarkIdAndOrderStatus(Long start_at, Long end_at, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id  ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? AND order_status IN (2,3) AND accept_status = 2 GROUP BY  store_id";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql + " trademarkId is " + trademarkId));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<OrderStatistics> getOrderStatisticsAllByTimeAndStoreIdAndOrderStatus(Long start_at, Long end_at, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE store_id = ? AND order_status IN (2,3) AND accept_status = 2";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT store_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and store_id = ? AND order_status IN (2,3) AND accept_status = 2";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, storeId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{storeId});
    }

    public List<OrderStatistics> getTrademarkOrderStatisticsByTimeAndOrderStatus(Long start_at, Long end_at, Long trademarkId, Integer orderType) throws ServiceException, ServiceDaoException {
        String sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at >= ? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT trademark_id id,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount,cast(sum(pay_fee) as decimal(10,2))payFee,cast(sum(promotion_fee) as decimal(10,2))promotionFee,cast(sum(brokerage) as decimal(10,2))brokerage,cast(sum(platform_subsidy) as decimal(10,2))platformSubsidy FROM user_order WHERE buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "");
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<OrderStatistics> getTrademarkOrderStatisticsByPlatform(Long start_at, Long end_at, Long trademarkId, Integer orderType) throws ServiceException, ServiceDaoException {
        String sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
        if (DataUtils.isNotNullOrEmpty((Object)start_at) && DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, end_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)start_at)) {
            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at >= ? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{start_at, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)end_at)) {
            sql = "SELECT trademark_id id,platform,count(id)orderCount,cast(sum(order_price) as decimal(10,2))amount FROM user_order WHERE buy_at <=? and trademark_id = ? " + (orderType == 1 ? "AND order_status IN (2,3) AND accept_status = 2" : "") + " GROUP BY  platform";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{end_at, trademarkId});
        }
        log.info((Object)("sql is " + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(OrderStatistics.class), new Object[]{trademarkId});
    }

    public List<FoodStatistics> getTrademarkFoodStatisticsByTime(Long startAt, Long endAt, Long trademarkId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT b.trademark_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND a.trademark_id = ? ";
        if (DataUtils.isNotNullOrEmpty((Object)startAt) && DataUtils.isNotNullOrEmpty((Object)endAt)) {
            sql = "SELECT b.trademark_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at >= ? and buy_at <= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? and u.buy_at >= ? and u.buy_at <= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? and b.buy_at <= ? AND a.trademark_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{trademarkId, startAt, endAt, trademarkId, startAt, endAt, startAt, endAt, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            sql = "SELECT b.trademark_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at >= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.trademark_id = ? and u.buy_at >= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? AND a.trademark_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{trademarkId, startAt, trademarkId, startAt, startAt, trademarkId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            sql = "SELECT b.trademark_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and trademark_id = ? and buy_at <= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and u.trademark_id = ? and u.buy_at <= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at <= ? AND b.trademark_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{trademarkId, endAt, trademarkId, endAt, endAt, trademarkId});
        }
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{trademarkId, trademarkId, trademarkId});
    }

    public List<FoodStatistics> getStoreFoodStatisticsByTime(Long startAt, Long endAt, Long storeId) throws ServiceException, ServiceDaoException {
        String sql = "SELECT b.store_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND a.store_id = ? ";
        if (DataUtils.isNotNullOrEmpty((Object)startAt) && DataUtils.isNotNullOrEmpty((Object)endAt)) {
            sql = "SELECT b.store_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at >= ? and buy_at <= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at >= ? and u.buy_at <= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? and b.buy_at <= ? AND a.store_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{storeId, startAt, endAt, storeId, startAt, endAt, startAt, endAt, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            sql = "SELECT b.store_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at >= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at >= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at >= ? AND a.store_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{storeId, startAt, storeId, startAt, startAt, storeId});
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            sql = "SELECT b.store_id id,sum(quantity)quantity,sum(price*quantity)price,sum(quantity*price*(1-food_discount))discountAmount,(SELECT count(id) FROM user_order WHERE order_status=0 and store_id = ? and buy_at <= ? )cancelCount,(SELECT sum(price*quantity) FROM food_order_relation AS f,user_order AS u WHERE f.order_id=u.id AND u.order_status=0 and f.store_id = ? and u.buy_at <= ? )cancelAmount FROM food_order_relation AS a,user_order AS b WHERE a.order_id=b.id AND b.accept_status=2 AND b.order_status IN (2,3) AND b.buy_at <= ? AND a.store_id = ? ";
            return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{storeId, endAt, storeId, endAt, endAt, storeId});
        }
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class), new Object[]{storeId, storeId, storeId});
    }

    public List<FoodStatistics> getStoreFoodStatisticsDetailBuyTime(Long startAt, Long endAt, Long storeId, Integer sort, Integer foodType) throws ServiceException, ServiceDaoException {
        log.info((Object)(" startAt is " + startAt + " ,endAt is " + endAt + " ,storeId is " + storeId + " , sort is " + sort + " , foodType is " + foodType));
        String orderWord = "quantity";
        if (DataUtils.isNotNullOrEmpty((Object)sort) && sort < 0) {
            orderWord = orderWord + " DESC";
        }
        String startAtSql = "";
        String endAtSql = "";
        String typeSql = "";
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)sort)) {
            switch (sort) {
                case 1: {
                    orderWord = "meituanCount";
                    break;
                }
                case 2: {
                    orderWord = "baiduCount";
                    break;
                }
                case 3: {
                    orderWord = "eleCount";
                    break;
                }
                case 4: {
                    orderWord = "quantity";
                    break;
                }
                case 5: {
                    orderWord = "salesProportion";
                    break;
                }
                case 6: {
                    orderWord = "salesAmount";
                    break;
                }
                case 7: {
                    orderWord = "amountProportion";
                    break;
                }
            }
        }
        if (DataUtils.isNotNullOrEmpty((Object)foodType)) {
            typeSql = " AND f.food_type = " + foodType;
        }
        String sql = "SELECT  f.id,  ft.name foodType,  f.name,  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000001' AND o.order_status IN (2,3)  AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + " )meituanCount,  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000010' AND o.order_status IN (2,3) AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ")baiduCount,  (SELECT sum(fr.quantity) FROM food_order_relation AS fr WHERE fr.order_id=o.id AND o.platform='000100' AND o.order_status IN (2,3) AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ")eleCount,  sum(fr.quantity)quantity,  sum(fr.quantity/(SELECT sum(quantity) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status IN (2,3)) AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ")saleSProportion,  SUM(fr.quantity*fr.price)salesAmount,  SUM(fr.quantity*fr.price)/(SELECT SUM(fr.quantity*fr.price) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status IN (2,3) AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ")amountProportion,  sum(fr.quantity *fs.price* (1-fr.food_discount))discountAmount,  (SELECT sum(fr.quantity) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status=0 AND fr.food_id=f.id AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ") cancelCount,  (SELECT sum(fr.quantity*fr.price) FROM food_order_relation AS fr,user_order AS o WHERE fr.order_id=o.id AND o.order_status=0 AND fr.food_id=f.id AND o.store_id=" + storeId + startAtSql + endAtSql + typeSql + ")cancelAmount FROM food_order_relation AS fr,user_order AS o ,food AS f,food_type_relation AS ft, food_solid AS fs WHERE o.id=fr.order_id AND fr.food_id=f.id AND o.order_status IN (2,3) AND fs.group_num=ft.type_num AND f.food_num=fs.food_num AND o.store_id= " + storeId + startAtSql + endAtSql + typeSql + "  GROUP BY fr.food_id ORDER BY " + orderWord + ";";
        log.info((Object)(" sql is :" + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(FoodStatistics.class));
    }

    public List<UserStatistics> getUserStatisticsByTimeAndStoreId(Long startAt, Long endAt, Long storeId, Long trademarkId) {
        log.info((Object)(" startAt is " + startAt + " ,endAt is " + endAt + " ,storeId is " + storeId + " ,trademarkId is " + trademarkId));
        String startAtSql = "";
        String endAtSql = "";
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql = "SELECT o.store_id id,s.name storeName, t.name trademarkName, count(DISTINCT mobile) userCount, (SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.store_id=s.id AND o.trademark_id=t.id AND o.order_status in (2,3)) newUserCount, ((SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.store_id=s.id AND o.trademark_id=t.id AND o.order_status in (2,3))/count(DISTINCT mobile)) newUserRate FROM user_order AS o,store as s,trademark AS t WHERE o.store_id=s.id AND o.trademark_id=t.id AND o.trademark_id = " + trademarkId + " AND o.order_status in (2,3) AND  o.store_id = " + storeId + startAtSql + endAtSql + " GROUP BY  store_id";
        log.info((Object)("sql is :" + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(UserStatistics.class));
    }

    public List<UserStatistics> getUserStatisticsByTimeAndTrademarkId(Long startAt, Long endAt, Long trademarkId) {
        log.info((Object)(" startAt is " + startAt + " ,endAt is " + endAt + " ,trademarkId is " + trademarkId));
        String startAtSql = "";
        String endAtSql = "";
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql = "SELECT o.trademark_id id,t.name trademarkName, count(DISTINCT mobile) userCount, (SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.trademark_id=t.id AND o.order_status in (2,3)) newUserCount, ((SELECT count(DISTINCT o.mobile) FROM  user_order AS o,user AS u WHERE o.buy_count=1 AND o.trademark_id=t.id AND o.order_status in (2,3))/count(DISTINCT mobile)) newUserRate FROM user_order AS o,trademark AS t WHERE o.trademark_id=t.id AND o.trademark_id = " + trademarkId + " AND o.order_status in (2,3)" + startAtSql + endAtSql + " GROUP BY o.trademark_id";
        log.info((Object)("sql is :" + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(UserStatistics.class));
    }

    public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndStoreId(Long startAt, Long endAt, Long trademarkId, Long storeId) throws ServiceException, ServiceDaoException {
        log.info((Object)(" startAt is " + startAt + " ,endAt is " + endAt + " ,storeId is " + storeId));
        String startAtSql = "";
        String endAtSql = "";
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql = "SELECT o.store_id storeId, s.name storeName, o.trademark_id trademarkId, t.name trademarkName, (select count(o.id) FROM user_order AS o WHERE o.order_status = 3 AND o.store_id =" + storeId + " AND o.trademark_id =" + trademarkId + ")orderCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order as o WHERE o.id=e.order_id and o.store_id=" + storeId + ") evaluateCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order as o WHERE o.id=e.order_id and o.store_id=" + storeId + ")/(select count(o.id) FROM user_order AS o WHERE o.order_status = 3 AND o.store_id =" + storeId + " AND o.trademark_id =" + trademarkId + ") evaluateRate, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o WHERE o.order_status=3 and o.id=e.order_id and o.store_id = " + storeId + " and e.order_score=5) fiveCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = " + storeId + " and e.order_score=4) fourCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = " + storeId + " and e.order_score=3) threeCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = " + storeId + "  and e.order_score=2) twoCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e,user_order AS o  WHERE o.order_status=3 and o.id=e.order_id and o.store_id = " + storeId + " and e.order_score=1) oneCount FROM user_order AS o,store AS s,trademark AS t,evaluate_order_relation AS e WHERE o.id=e.order_id AND o.order_status=3 AND o.store_id = " + storeId + " AND o.trademark_id =" + trademarkId + startAtSql + endAtSql + " GROUP BY o.store_id";
        log.info((Object)("sql is :" + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(EvaluateStatistics.class));
    }

    public List<EvaluateStatistics> getEvaluateStatisticsByTimeAndTrademarkId(Long startAt, Long endAt, Long trademarkId) throws ServiceException, ServiceDaoException {
        log.info((Object)(" startAt is " + startAt + " ,endAt is " + endAt + " ,trademarkId is " + trademarkId));
        String startAtSql = "";
        String endAtSql = "";
        if (DataUtils.isNotNullOrEmpty((Object)startAt)) {
            startAtSql = " AND o.buy_at >= " + startAt;
        }
        if (DataUtils.isNotNullOrEmpty((Object)endAt)) {
            endAtSql = " AND o.buy_at <= " + endAt;
        }
        String sql = "SELECT o.trademark_id trademarkId, t.name trademarkName, (select count(o.id) FROM user_order AS o WHERE o.order_status = 3 AND o.trademark_id =" + trademarkId + ")orderCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e WHERE o.id=e.order_id) evaluateCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e WHERE o.id=e.order_id)/(select count(o.id) FROM user_order AS o WHERE o.order_status = 3 AND o.trademark_id =" + trademarkId + ") evaluateRate, (SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=5) fiveCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=4) fourCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=3) threeCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id  and e.order_score=2) twoCount, (SELECT count(e.order_score) FROM evaluate_order_relation AS e  WHERE o.order_status=3 and o.id=e.order_id and e.order_score=1) oneCount FROM user_order AS o,store AS s,trademark AS t,evaluate_order_relation AS e WHERE o.id=e.order_id AND o.order_status=3  AND o.trademark_id =" + trademarkId + startAtSql + endAtSql + " GROUP BY o.trademark_id";
        log.info((Object)("sql is :" + sql));
        return this.template.query(sql, (RowMapper)new BeanPropertyRowMapper(EvaluateStatistics.class));
    }
}

