/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.SynRecord;
import com.ptteng.onway.platform.service.SynRecordService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SynRecordServiceImpl
extends BaseDaoServiceImpl
implements SynRecordService {
    private static final Log log = LogFactory.getLog(SynRecordServiceImpl.class);

    public Long insert(SynRecord synRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + synRecord));
        if (synRecord == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        synRecord.setCreateAt(Long.valueOf(currentTimeMillis));
        synRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)synRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + synRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<SynRecord> insertList(List<SynRecord> synRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (synRecordList == null ? "null" : Integer.valueOf(synRecordList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(synRecordList)) {
            return new ArrayList<SynRecord>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SynRecord synRecord : synRecordList) {
            synRecord.setCreateAt(Long.valueOf(currentTimeMillis));
            synRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(synRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + synRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(SynRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(SynRecord synRecord) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (synRecord == null ? "null" : synRecord.getId())));
        boolean result = false;
        if (synRecord == null) {
            return true;
        }
        synRecord.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)synRecord);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + synRecord));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + synRecord));
        }
        return result;
    }

    public boolean updateList(List<SynRecord> synRecordList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (synRecordList == null ? "null" : Integer.valueOf(synRecordList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(synRecordList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (SynRecord synRecord : synRecordList) {
            synRecord.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(synRecordList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + synRecordList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + synRecordList.size()));
        return result;
    }

    public SynRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        SynRecord synRecord = null;
        if (id == null) {
            return synRecord;
        }
        try {
            synRecord = (SynRecord)this.dao.get(SynRecord.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return synRecord;
    }

    public List<SynRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List synRecord = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<SynRecord>();
        }
        try {
            synRecord = this.dao.getList(SynRecord.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (synRecord == null ? "null" : Integer.valueOf(synRecord.size()))));
        return synRecord;
    }

    public List<Long> getSynRecordIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSynRecordIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getSynRecordIdsByTypePlatformStoreId(Integer synType, String platform, Long storeId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by synType,platform,storeId,start,limit  ================== " + synType + " , " + platform + " , " + storeId + " , " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSynRecordIdsByTypePlatformStoreId", new Object[]{synType, platform, storeId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by type,tart,limit)  : " + synType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSynRecordIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSynRecordIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSynRecordIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

