/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.onway.platform.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.onway.platform.model.FoodSolid;
import com.ptteng.onway.platform.service.FoodSolidService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FoodSolidServiceImpl
extends BaseDaoServiceImpl
implements FoodSolidService {
    private static final Log log = LogFactory.getLog(FoodSolidServiceImpl.class);

    public Long insert(FoodSolid foodSolid) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + foodSolid));
        if (foodSolid == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        foodSolid.setCreateAt(Long.valueOf(currentTimeMillis));
        foodSolid.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)foodSolid);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + foodSolid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<FoodSolid> insertList(List<FoodSolid> foodSolidList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (foodSolidList == null ? "null" : Integer.valueOf(foodSolidList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(foodSolidList)) {
            return new ArrayList<FoodSolid>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (FoodSolid foodSolid : foodSolidList) {
            foodSolid.setCreateAt(Long.valueOf(currentTimeMillis));
            foodSolid.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(foodSolidList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + foodSolidList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(FoodSolid.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(FoodSolid foodSolid) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (foodSolid == null ? "null" : foodSolid.getId())));
        boolean result = false;
        if (foodSolid == null) {
            return true;
        }
        foodSolid.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)foodSolid);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + foodSolid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + foodSolid));
        }
        return result;
    }

    public boolean updateList(List<FoodSolid> foodSolidList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (foodSolidList == null ? "null" : Integer.valueOf(foodSolidList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(foodSolidList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (FoodSolid foodSolid : foodSolidList) {
            foodSolid.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(foodSolidList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + foodSolidList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + foodSolidList.size()));
        return result;
    }

    public FoodSolid getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        FoodSolid foodSolid = null;
        if (id == null) {
            return foodSolid;
        }
        try {
            foodSolid = (FoodSolid)this.dao.get(FoodSolid.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return foodSolid;
    }

    public List<FoodSolid> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List foodSolid = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<FoodSolid>();
        }
        try {
            foodSolid = this.dao.getList(FoodSolid.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (foodSolid == null ? "null" : Integer.valueOf(foodSolid.size()))));
        return foodSolid;
    }

    public Long getFoodSolidIdByStoreNumAndGroupNumAndFoodNumAndStatus(String storeNum, String groupNum, String foodNum, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by storeNum,groupNum,foodNum,status  : " + storeNum + " , " + groupNum + " , " + foodNum + " , " + status));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getFoodSolidIdByStoreNumAndGroupNumAndFoodNumAndStatus", new Object[]{storeNum, groupNum, foodNum, status});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by storeNum,groupNum,foodNum,status  : " + storeNum + " , " + groupNum + " , " + foodNum + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getFoodSolidIdsByStoreNum(String storeNum, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by storeNum,start,limit  : " + storeNum + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodSolidIdsByStoreNum", new Object[]{storeNum}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by storeNum,start,limit)  : " + storeNum + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getFoodSolidIdsByStoreNumAndStatus(String storeNum, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by storeNum,start,status,limit  : " + storeNum + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodSolidIdsByStoreNumAndStatus", new Object[]{storeNum, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by storeNum,status,start,limit)  : " + storeNum + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getFoodSolidIdsByStoreNumAndGroupNumAndStatus(String storeNum, String groupNum, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by storeNum,groupNum,status,start,limit  : " + storeNum + " , " + groupNum + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodSolidIdsByStoreNumAndGroupNumAndStatus", new Object[]{storeNum, groupNum, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by storeNum,groupNum,status,start,limit)  : " + storeNum + " , " + groupNum + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFoodSolidIdsByStoreNumAndGroupNumAndStatus(String storeNum, String groupNum, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by storeNum,groupNum,status  : " + storeNum + " , " + groupNum + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getFoodSolidIdsByStoreNumAndGroupNumAndStatus", new Object[]{storeNum, groupNum, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by storeNum,groupNum,status)  : " + storeNum + " , " + groupNum + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getFoodSolidIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFoodSolidIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFoodSolidIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFoodSolidIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFoodSolidIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

