package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Maps;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.WaimaiStoreConsumerService;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.List;
import java.util.Map;

/**
 * 菜品消费者服务实现
 * Created by wanglei on 16/7/22.
 */
public class StoreConsumerServiceImpl implements WaimaiStoreConsumerService {

    @Autowired
    @Qualifier("meituanStoreService")
    private WaimaiStoreService meituanStoreService;

    private static Map<String, WaimaiStoreService> waimaiStoreServiceMap = Maps.newHashMap();

    private Map<String, WaimaiStoreService> getWaimaiStoreServiceMap(){
        if(CollectionUtils.isEmpty(waimaiStoreServiceMap.entrySet())){
            waimaiStoreServiceMap.put("meituan", meituanStoreService);
        }
        return waimaiStoreServiceMap;
    }

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {

        for(WaimaiStoreService s: getWaimaiStoreServiceMap().values()){
            s.updateStore(mchId, storeId, waimaiStoreDTO);
        }

    }

    @Override
    public void updateStoreByPlatform(Long mchId, Long storeId, List<String> platformTypes, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException {

        for(String platformType: platformTypes){
            if(getWaimaiStoreServiceMap().keySet().contains(platformType)){
                getWaimaiStoreServiceMap().get(platformType).updateStore(mchId, storeId, waimaiStoreDTO);
            }
        }
    }

    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        for(WaimaiStoreService s: getWaimaiStoreServiceMap().values()) {
            s.onlineStore(mchId, storeId);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        for(WaimaiStoreService s: getWaimaiStoreServiceMap().values()) {
            s.offlineStore(mchId, storeId);
        }
    }

    @Override
    public void onlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = getWaimaiStoreServiceMap().get(platform);
        if (service != null){
            waimaiStoreServiceMap.get(platform).onlineStore(mchId, storeId);
        }
    }

    @Override
    public void offlineStoreByPlatform(Long mchId, Long storeId, String platform) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = getWaimaiStoreServiceMap().get(platform);
        if (service != null){
            waimaiStoreServiceMap.get(platform).offlineStore(mchId, storeId);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = getWaimaiStoreServiceMap().get("meituan");
        if (service != null){
            return service.getStoreComment(mchId, storeId, startTime, endTime, pageSize);
        }
        return null;
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        WaimaiStoreService service = getWaimaiStoreServiceMap().get("meituan");
        if (service != null){
            service.replyStoreComment(mchId, storeId, commentId, replyContent);
        }
    }

}
