package com.ptteng.onway.platform.service.waimai.store.impls;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.google.common.collect.Lists;
import com.jiabangou.mtwmsdk.api.MtWmClient;
import com.jiabangou.mtwmsdk.api.ShopService;
import com.jiabangou.mtwmsdk.exception.MtWmErrorException;
import com.jiabangou.mtwmsdk.model.Comment;
import com.jiabangou.mtwmsdk.model.Shop;
import com.ptteng.onway.platform.model.WaimaiStoreDTO;
import com.ptteng.onway.platform.service.waimai.MeituanAbstractService;
import com.ptteng.onway.platform.service.waimai.other.CommonUtil;
import com.ptteng.onway.platform.service.waimai.other.ConvertUtils;
import com.ptteng.onway.platform.service.waimai.other.WaimaiConstants;
import com.ptteng.onway.platform.model.WaimaiStoreCommentDTO;
import com.ptteng.onway.platform.service.waimai.other.model.WaimaiStoreMapping;
import com.ptteng.onway.platform.service.waimai.store.WaimaiStoreService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Created by wanglei on 16-10-9.
 */
public class MeituanStroeServiceImpl extends MeituanAbstractService implements WaimaiStoreService {

    private static Logger logger = Logger.getLogger(MeituanStroeServiceImpl.class);

    private static final String DEFAULT_MEITUAN_STORE_ID = "0";

    @Override
    public void updateStore(Long mchId, Long storeId, WaimaiStoreDTO waimaiStoreDTO) throws ServiceException, ServiceDaoException  {
        //检查门店是否在美团平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }

        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到美团外卖
        if (client == null) {
            return;
        }

        ShopService shopService = client.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);

        String mappingId;

        if (storeMapping == null) {
            mappingId = String.valueOf(storeId);
        } else {
            mappingId = storeMapping.getMappingId();
        }

        try {

            Shop shop = buildUpdateShop(mappingId, waimaiStoreDTO, shopService);
            shopService.save(shop);

            if (storeMapping == null) {
                saveStoreMapping(mchId, storeId, DEFAULT_MEITUAN_STORE_ID, WaimaiConstants.PlatformType.MEITUAN);
            }

        } catch (MtWmErrorException mtWmErrorException) {
            logger.error(mtWmErrorException.getMessage(), mtWmErrorException);
        }
    }



    @Override
    public void onlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {
        //检查门店是否在美团平台上线
        if (!checkStorePlatformById(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN)) {
            return;
        }

        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到美团外卖
        if (client == null) {
            return;
        }

        ShopService shopService = client.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);

        String mappingId;

        if (storeMapping == null) {
            mappingId = String.valueOf(storeId);
        } else {
            mappingId = storeMapping.getMappingId();
        }
        logger.info("storeMapping is " +storeMapping + " ,mappingId is "+mappingId  );
        try {
            shopService.open(mappingId);
        } catch (MtWmErrorException mtWmErrorException) {
            logger.error(mtWmErrorException.getMessage(), mtWmErrorException);
        }
    }

    @Override
    public void offlineStore(Long mchId, Long storeId) throws ServiceException, ServiceDaoException {

        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到美团外卖
        if (client == null) {
            return;
        }

        ShopService shopService = client.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);

        String mappingId;

        if (storeMapping == null) {
            mappingId = String.valueOf(storeId);
        } else {
            mappingId = storeMapping.getMappingId();
        }

        try {
            Shop oldShop = getStore(mappingId, shopService);
            if(oldShop != null){
                shopService.close(mappingId);
            }
        } catch (MtWmErrorException mtWmErrorException) {
            logger.error(mtWmErrorException.getMessage(), mtWmErrorException);
        }
    }

    @Override
    public List<WaimaiStoreCommentDTO> getStoreComment(Long mchId, Long storeId, String startTime, String endTime, int pageSize) throws ServiceException, ServiceDaoException {
        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到美团外卖
        if (client == null) {
            return null;
        }

        ShopService shopService = client.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);

        if (storeMapping == null) {
            return null;
        }

        logger.info("getStoreComment is execute");
        try {
            List<Comment> comments = shopService.getShopComment(storeMapping.getMappingId(), startTime, endTime, pageSize);
            return ConvertUtils.converts(comments, WaimaiStoreCommentDTO.class);
        } catch (MtWmErrorException mtWmErrorException) {
            logger.error(mtWmErrorException.getMessage(), mtWmErrorException);
            return null;
        }
    }

    @Override
    public void replyStoreComment(Long mchId, Long storeId, Long commentId, String replyContent) throws ServiceException, ServiceDaoException {
        MtWmClient client = getMtWmClient(mchId);
        // 如果为空表示不支持同步到美团外卖
        if (client == null) {
            return;
        }

        ShopService shopService = client.getShopService();

        // 如果没有找到对应的餐厅对应就不处理了
        WaimaiStoreMapping storeMapping = findStoreMapping(mchId, storeId, WaimaiConstants.PlatformType.MEITUAN);

        if (storeMapping == null) {
            return;
        }

        logger.info("replyStoreComment is execute");

        try {
            shopService.replyShopComment(storeMapping.getMappingId(), String.valueOf(commentId), replyContent);
        } catch (MtWmErrorException mtWmErrorException) {
            logger.error(mtWmErrorException.getMessage(), mtWmErrorException);
        }
    }

    private Shop getStore(String mappingId, ShopService shopService) {

        try {
            List<Shop> shops = shopService.gets(Lists.newArrayList(mappingId));
            if (CollectionUtils.isNotEmpty(shops)) {
                return shops.get(0);
            } else {
                return null;
            }
        } catch (MtWmErrorException bdWmErrorException) {

            logger.error(bdWmErrorException.getMessage(), bdWmErrorException);
            return null;

        }
    }

    private Shop buildCreateShop(String mappingId, WaimaiStoreDTO waiMaiDTO){

        Shop shop = new Shop();
        shop.setApp_poi_code(mappingId);
        shop.setName(waiMaiDTO.getName());
        shop.setPhone(waiMaiDTO.getServicePhone());
        shop.setShipping_time(waiMaiDTO.getOpenTime());
        shop.setPic_url(waiMaiDTO.getShopLogo());
        shop.setPic_url_large(waiMaiDTO.getShopLogo());
        shop.setPre_book(waiMaiDTO.getIsBookable());
        shop.setStandby_tel(waiMaiDTO.getPhone());
        shop.setPromotion_info(waiMaiDTO.getPromotionInfo());
        if(waiMaiDTO.getIsInvoice() == 1){
            shop.setInvoice_support(1);
            shop.setInvoice_min_price(Double.valueOf(CommonUtil.fenChangeY(waiMaiDTO.getInvoiceMinAmount())));
            shop.setInvoice_description("");
        } else {
            shop.setInvoice_support(0);
        }
        return shop;
    }

    private Shop buildUpdateShop(String mappingId, WaimaiStoreDTO waiMaiDTO, ShopService shopService){
        Shop shop = buildCreateShop(mappingId, waiMaiDTO);
        Shop oldShop = getStore(mappingId, shopService);
        if(oldShop != null){
            shop.setAddress(oldShop.getAddress());
            shop.setLatitude(oldShop.getLatitude() / 1000000);
            shop.setLongitude(oldShop.getLongitude() / 1000000);
            shop.setShipping_fee(oldShop.getShipping_fee());
        }
        return shop;
    }

}
